/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.nodenetwork;

import gigaherz.graph.api.Graph;
import gigaherz.graph.api.Mergeable;
import java.util.Iterator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import org.valkyrienskies.addon.control.nodenetwork.IVSNode;
import org.valkyrienskies.addon.control.nodenetwork.IVSNodeProvider;
import org.valkyrienskies.addon.control.nodenetwork.VSNode_TileEntity;

public abstract class BasicNodeTileEntity
extends TileEntity
implements IVSNodeProvider,
ITickable {
    private final VSNode_TileEntity tileNode = new VSNode_TileEntity(this, this.getMaximumConnections());
    private boolean firstUpdate = true;

    public SPacketUpdateTileEntity func_189518_D_() {
        SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
        return packet;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.tileNode.writeToNBT(compound);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tileNode.readFromNBT(compound);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound toReturn = super.func_189517_E_();
        return this.func_189515_b(toReturn);
    }

    @Override
    public VSNode_TileEntity getNode() {
        return this.tileNode;
    }

    public void func_145843_s() {
        VSNode_TileEntity toInvalidate = this.getNode();
        Graph graph = toInvalidate.getGraph();
        if (graph != null) {
            graph.remove(toInvalidate);
            toInvalidate.breakAllConnections();
        }
        this.field_145846_f = true;
        toInvalidate.invalidate();
    }

    public void func_145829_t() {
        this.field_145846_f = false;
        this.getNode().validate();
    }

    public void func_73660_a() {
        if (this.firstUpdate) {
            this.firstUpdate = false;
            this.init();
        }
    }

    protected int getMaximumConnections() {
        return 1;
    }

    private void init() {
        if (this.tileNode.getGraph() == null) {
            return;
        }
        this.tileNode.getGraph().addNeighours(this.tileNode, this.tileNode.getNeighbours());
    }

    @Override
    public Iterable<IVSNode> getNetworkedConnections() {
        return () -> new IteratorCaster(this.tileNode.getGraph().getObjects().iterator());
    }

    private static class IteratorCaster
    implements Iterator<IVSNode> {
        private final Iterator toCast;

        private IteratorCaster(Iterator toCast) {
            this.toCast = toCast;
        }

        @Override
        public boolean hasNext() {
            return this.toCast.hasNext();
        }

        @Override
        public IVSNode next() {
            return (IVSNode)this.toCast.next();
        }
    }

    public static class GraphData
    implements Mergeable<GraphData> {
        private static volatile int sUid = 0;
        private final int uid;

        public GraphData() {
            this.uid = ++sUid;
        }

        public GraphData(int uid) {
            this.uid = uid;
        }

        @Override
        public GraphData mergeWith(GraphData other) {
            return new GraphData(this.uid + other.uid);
        }

        @Override
        public GraphData copy() {
            return new GraphData();
        }

        public int getUid() {
            return this.uid;
        }
    }
}

