/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.nodenetwork;

import gigaherz.graph.api.GraphObject;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;

public interface IVSNode
extends GraphObject {
    public static final String NBT_DATA_KEY = "VSNode_Tile_Data";

    public Iterable<IVSNode> getDirectlyConnectedNodes();

    public void makeConnection(IVSNode var1);

    public void breakConnection(IVSNode var1);

    public void validate();

    public void invalidate();

    public boolean isValid();

    public BlockPos getNodePos();

    public World getNodeWorld();

    public Set<BlockPos> getLinkedNodesPos();

    public void writeToNBT(NBTTagCompound var1);

    public void readFromNBT(NBTTagCompound var1);

    default public void breakAllConnections() {
        for (IVSNode node : this.getDirectlyConnectedNodes()) {
            this.breakConnection(node);
        }
    }

    default public boolean canLinkToOtherNode(IVSNode other) {
        return this.getLinkedNodesPos().size() < this.getMaximumConnections() && other.getLinkedNodesPos().size() < other.getMaximumConnections();
    }

    public void sendNodeUpdates();

    public void shiftConnections(BlockPos var1);

    public void setParentPhysicsObject(PhysicsObject var1);

    public PhysicsObject getPhysicsObject();

    public List<GraphObject> getNeighbours();

    public TileEntity getParentTile();

    public int getMaximumConnections();

    default public boolean isLinkedToNode(IVSNode other) {
        return this.getLinkedNodesPos().contains(other.getNodePos());
    }
}

