/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.nodenetwork;

import gigaherz.graph.api.Graph;
import gigaherz.graph.api.GraphObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.nodenetwork.BasicNodeTileEntity;
import org.valkyrienskies.addon.control.nodenetwork.IVSNode;
import org.valkyrienskies.addon.control.nodenetwork.IVSNodeProvider;
import org.valkyrienskies.fixes.VSNetwork;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;

public class VSNode_TileEntity
implements IVSNode {
    private final TileEntity parentTile;
    private final Set<BlockPos> linkedNodesPos;
    private final Set<BlockPos> unmodifiableLinkedNodesPos;
    private final int maximumConnections;
    private boolean isValid;
    private PhysicsObject parentPhysicsObject;
    private Graph nodeGraph;

    public VSNode_TileEntity(TileEntity parent, int maximumConnections) {
        this.parentTile = parent;
        this.linkedNodesPos = new HashSet<BlockPos>();
        this.unmodifiableLinkedNodesPos = Collections.unmodifiableSet(this.linkedNodesPos);
        this.isValid = false;
        this.parentPhysicsObject = null;
        this.maximumConnections = maximumConnections;
        Graph.integrate(this, Collections.EMPTY_LIST, graph -> new BasicNodeTileEntity.GraphData());
    }

    @Nullable
    @Deprecated
    public static IVSNode getVSNode_TileEntity(World world, BlockPos pos) {
        if (world == null || pos == null) {
            throw new IllegalArgumentException("Null arguments");
        }
        boolean isChunkLoaded = world.func_175667_e(pos);
        if (!isChunkLoaded) {
            return null;
        }
        TileEntity entity = world.func_175625_s(pos);
        if (entity == null) {
            return null;
        }
        if (entity instanceof IVSNodeProvider) {
            IVSNode vsNode = ((IVSNodeProvider)entity).getNode();
            if (!vsNode.isValid()) {
                return null;
            }
            return vsNode;
        }
        return null;
    }

    @Override
    public Iterable<IVSNode> getDirectlyConnectedNodes() {
        ArrayList<IVSNode> nodesList = new ArrayList<IVSNode>();
        for (BlockPos pos : this.linkedNodesPos) {
            IVSNode node = VSNode_TileEntity.getVSNode_TileEntity(this.getNodeWorld(), pos);
            if (node == null) continue;
            nodesList.add(node);
        }
        return nodesList;
    }

    @Override
    public void makeConnection(IVSNode other) {
        this.assertValidity();
        boolean contains = this.linkedNodesPos.contains(other.getNodePos());
        if (!contains) {
            this.linkedNodesPos.add(other.getNodePos());
            this.parentTile.func_70296_d();
            other.makeConnection(this);
            this.sendNodeUpdates();
            List<GraphObject> stupid = Collections.singletonList(other);
            this.getGraph().addNeighours(this, stupid);
        }
    }

    @Override
    public void breakConnection(IVSNode other) {
        this.assertValidity();
        boolean contains = this.linkedNodesPos.contains(other.getNodePos());
        if (contains) {
            this.linkedNodesPos.remove(other.getNodePos());
            this.parentTile.func_70296_d();
            other.breakConnection(this);
            this.sendNodeUpdates();
            try {
                if (this.getGraph() != null) {
                    this.getGraph().removeNeighbour(this, other);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public BlockPos getNodePos() {
        this.assertValidity();
        return this.parentTile.func_174877_v();
    }

    @Override
    public void validate() {
        this.isValid = true;
    }

    @Override
    public void invalidate() {
        this.isValid = false;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public World getNodeWorld() {
        return this.parentTile.func_145831_w();
    }

    @Override
    public Set<BlockPos> getLinkedNodesPos() {
        return this.unmodifiableLinkedNodesPos;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        int[] positions = new int[this.getLinkedNodesPos().size() * 3];
        int cont = 0;
        for (BlockPos pos : this.getLinkedNodesPos()) {
            positions[cont] = pos.func_177958_n();
            positions[cont + 1] = pos.func_177956_o();
            positions[cont + 2] = pos.func_177952_p();
            cont += 3;
        }
        compound.func_74783_a("VSNode_Tile_Data", positions);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        int[] positions = compound.func_74759_k("VSNode_Tile_Data");
        for (int i = 0; i < positions.length; i += 3) {
            this.linkedNodesPos.add(new BlockPos(positions[i], positions[i + 1], positions[i + 2]));
        }
    }

    @Override
    public PhysicsObject getPhysicsObject() {
        return this.parentPhysicsObject;
    }

    @Override
    public void sendNodeUpdates() {
        if (!this.getNodeWorld().field_72995_K && !this.parentTile.func_145837_r()) {
            VSNetwork.sendTileToAllNearby(this.parentTile);
        }
    }

    private void assertValidity() {
        if (!this.isValid()) {
            throw new IllegalStateException("This node at " + this.parentTile.func_174877_v() + " is not valid / initialized!");
        }
    }

    @Override
    public void shiftConnections(BlockPos offset) {
        if (this.isValid()) {
            throw new IllegalStateException("Cannot shift the connections of a Node while it is valid and in use!");
        }
        ArrayList<BlockPos> shiftedNodesPos = new ArrayList<BlockPos>(this.linkedNodesPos.size());
        for (BlockPos originalPos : this.linkedNodesPos) {
            shiftedNodesPos.add(originalPos.func_177971_a((Vec3i)offset));
        }
        this.linkedNodesPos.clear();
        this.linkedNodesPos.addAll(shiftedNodesPos);
    }

    @Override
    public void setParentPhysicsObject(PhysicsObject parent) {
        if (this.isValid()) {
            throw new IllegalStateException("Cannot change the parent physics object of a Node while it is valid and in use!");
        }
        this.parentPhysicsObject = parent;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof VSNode_TileEntity) {
            VSNode_TileEntity otherNode = (VSNode_TileEntity)other;
            return otherNode.getNodePos().equals((Object)this.getNodePos());
        }
        return false;
    }

    @Override
    public Graph getGraph() {
        return this.nodeGraph;
    }

    @Override
    public void setGraph(Graph graph) {
        this.nodeGraph = graph;
    }

    private List<GraphObject> getNeighbors() {
        ArrayList<GraphObject> neighbors = new ArrayList<GraphObject>();
        for (BlockPos pos : this.getLinkedNodesPos()) {
            IVSNode node = VSNode_TileEntity.getVSNode_TileEntity(this.getNodeWorld(), pos);
            if (node == null) {
                throw new IllegalStateException();
            }
            neighbors.add(node);
        }
        return neighbors;
    }

    @Override
    public List<GraphObject> getNeighbours() {
        ArrayList<GraphObject> nodesList = new ArrayList<GraphObject>();
        for (BlockPos pos : this.linkedNodesPos) {
            IVSNode node = VSNode_TileEntity.getVSNode_TileEntity(this.getNodeWorld(), pos);
            if (node == null) continue;
            nodesList.add(node);
        }
        return nodesList;
    }

    @Override
    public TileEntity getParentTile() {
        return this.parentTile;
    }

    @Override
    public int getMaximumConnections() {
        return this.maximumConnections;
    }
}

