/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.renderer;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import org.lwjgl.opengl.GL11;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityRudderPart;
import org.valkyrienskies.mod.client.render.GibsModelRegistry;
import org.valkyrienskies.mod.common.math.RotationMatrices;
import org.valkyrienskies.mod.common.math.Vector;

public class RudderPartTileEntityRenderer
extends TileEntitySpecialRenderer<TileEntityRudderPart> {
    public void render(TileEntityRudderPart tileentity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        double RUDDER_AXLE_SCALE_FACTOR = 4.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        this.func_147499_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        int brightness = tileentity.func_145831_w().func_175626_b(tileentity.func_174877_v(), 0);
        GlStateManager.func_179094_E();
        if (!tileentity.isPartOfAssembledMultiblock()) {
            GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
            GL11.glScaled((double)RUDDER_AXLE_SCALE_FACTOR, (double)1.0, (double)RUDDER_AXLE_SCALE_FACTOR);
            GL11.glTranslated((double)-0.5, (double)0.0, (double)-0.5);
            GibsModelRegistry.renderGibsModel("rudder_axle_geo", brightness);
        } else if (tileentity.isMaster() && tileentity.getRudderAxleAxisDirection().isPresent()) {
            IBlockState state = Blocks.field_150367_z.func_176223_P();
            EnumFacing axleAxis = tileentity.getRudderAxleAxisDirection().get();
            EnumFacing axleFacing = tileentity.getRudderAxleFacingDirection().get();
            double pitchRot = 0.0;
            double rollRot = 0.0;
            switch (axleAxis) {
                case DOWN: {
                    pitchRot = 180.0;
                    break;
                }
                case UP: {
                    break;
                }
                case NORTH: {
                    pitchRot = -90.0;
                    break;
                }
                case SOUTH: {
                    pitchRot = 90.0;
                    break;
                }
                case WEST: {
                    pitchRot = -90.0;
                    rollRot = 90.0;
                    break;
                }
                case EAST: {
                    pitchRot = -90.0;
                    rollRot = -90.0;
                }
            }
            Vector facingDirection = new Vector(axleFacing.func_176730_m().func_177958_n(), axleFacing.func_176730_m().func_177956_o(), axleFacing.func_176730_m().func_177952_p());
            double[] rotationMatrix = RotationMatrices.getRotationMatrix(-pitchRot, 0.0, 0.0);
            double[] rotationMatrix2 = RotationMatrices.getRotationMatrix(0.0, -rollRot, 0.0);
            RotationMatrices.applyTransform(rotationMatrix2, facingDirection);
            RotationMatrices.applyTransform(rotationMatrix, facingDirection);
            EnumFacing facingDirectionNew = EnumFacing.func_176737_a((float)((float)facingDirection.X), (float)((float)facingDirection.Y), (float)((float)facingDirection.Z));
            GL11.glTranslated((double)0.0, (double)0.5, (double)0.5);
            GL11.glRotated((double)pitchRot, (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)-0.5, (double)-0.5);
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.0);
            GL11.glRotated((double)rollRot, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)0.0);
            GL11.glPushMatrix();
            double rotYaw = -facingDirectionNew.func_185119_l() + 180.0f;
            GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
            GL11.glRotated((double)rotYaw, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)0.0, (double)-0.5);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
            GL11.glRotated((double)(tileentity.getRenderRudderAngle(partialTick) + 90.0), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)0.0, (double)-0.5);
            double rudderAxleLength = tileentity.getRudderAxleLength().get().intValue();
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
            GL11.glScaled((double)rudderAxleLength, (double)rudderAxleLength, (double)rudderAxleLength);
            GL11.glTranslated((double)-0.5, (double)0.0, (double)-0.5);
            GibsModelRegistry.renderGibsModel("rudder_geo", brightness);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            for (int i = 0; i < tileentity.getRudderAxleLength().get(); ++i) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
                GL11.glScaled((double)RUDDER_AXLE_SCALE_FACTOR, (double)1.0, (double)RUDDER_AXLE_SCALE_FACTOR);
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
                GibsModelRegistry.renderGibsModel("rudder_axle_geo", brightness);
                GL11.glPopMatrix();
                GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
            }
            GL11.glPopMatrix();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179117_G();
    }
}

