/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import org.valkyrienskies.addon.control.ValkyrienSkiesControl;
import org.valkyrienskies.addon.control.block.BlockCaptainsChair;
import org.valkyrienskies.addon.control.piloting.ControllerInputType;
import org.valkyrienskies.addon.control.piloting.PilotControlsMessage;
import org.valkyrienskies.addon.control.tileentity.TileEntityPilotableImpl;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.RotationMatrices;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import valkyrienwarfare.api.TransformType;

public class TileEntityCaptainsChair
extends TileEntityPilotableImpl {
    @Override
    void processControlMessage(PilotControlsMessage message, EntityPlayerMP sender) {
        IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (blockState.func_177230_c() == ValkyrienSkiesControl.INSTANCE.vsControlBlocks.captainsChair) {
            PhysicsWrapperEntity wrapper = this.getParentPhysicsEntity();
            if (wrapper != null) {
                this.processCalculationsForControlMessageAndApplyCalculations(wrapper, message, blockState);
            }
        } else {
            this.setPilotEntity(null);
        }
    }

    @Override
    final ControllerInputType getControlInputType() {
        return ControllerInputType.CaptainsChair;
    }

    @Override
    boolean setClientPilotingEntireShip() {
        return true;
    }

    @Override
    public final void onStartTileUsage(EntityPlayer player) {
        this.getParentPhysicsEntity().getPhysicsObject().getPhysicsProcessor().actAsArchimedes = true;
    }

    @Override
    public final void onStopTileUsage() {
        if (this.getParentPhysicsEntity() != null) {
            this.getParentPhysicsEntity().getPhysicsObject().getPhysicsProcessor().actAsArchimedes = false;
        }
    }

    private final void processCalculationsForControlMessageAndApplyCalculations(PhysicsWrapperEntity wrapper, PilotControlsMessage message, IBlockState state) {
        BlockPos chairPosition = this.func_174877_v();
        PhysicsObject controlledShip = wrapper.getPhysicsObject();
        if (controlledShip.getShipAligningToGrid()) {
            return;
        }
        double pilotPitch = 0.0;
        BlockCaptainsChair cfr_ignored_0 = (BlockCaptainsChair)state.func_177230_c();
        double pilotYaw = BlockCaptainsChair.getChairYaw(state, chairPosition);
        double pilotRoll = 0.0;
        double[] pilotRotationMatrix = RotationMatrices.getRotationMatrix(pilotPitch, pilotYaw, pilotRoll);
        Vector playerDirection = new Vector(1.0, 0.0, 0.0);
        RotationMatrices.applyTransform(pilotRotationMatrix, playerDirection);
        Vector upDirection = new Vector(0.0, 1.0, 0.0);
        Vector downDirection = new Vector(0.0, -1.0, 0.0);
        Vector idealAngularDirection = new Vector();
        Vector idealLinearVelocity = new Vector();
        Vector shipUp = new Vector(0.0, 1.0, 0.0);
        Vector shipUpPosIdeal = new Vector(0.0, 1.0, 0.0);
        if (message.airshipForward_KeyDown) {
            idealLinearVelocity.add(playerDirection);
        }
        if (message.airshipBackward_KeyDown) {
            idealLinearVelocity.subtract(playerDirection);
        }
        controlledShip.getShipTransformationManager().getCurrentTickTransform().rotate(idealLinearVelocity, TransformType.SUBSPACE_TO_GLOBAL);
        controlledShip.getShipTransformationManager().getCurrentTickTransform().rotate(shipUp, TransformType.SUBSPACE_TO_GLOBAL);
        if (message.airshipUp_KeyDown) {
            idealLinearVelocity.add(upDirection.getProduct(0.5));
        }
        if (message.airshipDown_KeyDown) {
            idealLinearVelocity.add(downDirection.getProduct(0.5));
        }
        double sidePitch = 0.0;
        if (message.airshipRight_KeyDown) {
            idealAngularDirection.subtract(shipUp);
            sidePitch -= 10.0;
        }
        if (message.airshipLeft_KeyDown) {
            idealAngularDirection.add(shipUp);
            sidePitch += 10.0;
        }
        Vector sidesRotationAxis = new Vector(playerDirection);
        controlledShip.getShipTransformationManager().getCurrentTickTransform().rotate(sidesRotationAxis, TransformType.SUBSPACE_TO_GLOBAL);
        double[] rotationSidesTransform = RotationMatrices.getRotationMatrix(sidesRotationAxis.X, sidesRotationAxis.Y, sidesRotationAxis.Z, Math.toRadians(sidePitch));
        shipUpPosIdeal.transform(rotationSidesTransform);
        idealAngularDirection.multiply(2.0);
        Vector shipUpRotationVector = shipUp.cross(shipUpPosIdeal);
        double shipUpTheta = shipUp.angleBetween(shipUpPosIdeal) + Math.PI;
        shipUpRotationVector.multiply(shipUpTheta);
        idealAngularDirection.add(shipUpRotationVector);
        idealLinearVelocity.multiply(20.0 * controlledShip.getPhysicsProcessor().getMass());
        if (message.airshipSprinting) {
            idealLinearVelocity.multiply(2.0);
        }
        double lerpFactor = 0.2;
        Vector linearMomentumDif = idealLinearVelocity.getSubtraction(controlledShip.getPhysicsProcessor().linearMomentum);
        Vector angularVelocityDif = idealAngularDirection.getSubtraction(controlledShip.getPhysicsProcessor().angularVelocity);
        linearMomentumDif.multiply(lerpFactor);
        angularVelocityDif.multiply(lerpFactor);
        controlledShip.getPhysicsProcessor().linearMomentum.subtract(linearMomentumDif);
        controlledShip.getPhysicsProcessor().angularVelocity.subtract(angularVelocityDif);
    }
}

