/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.tileentity;

import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.valkyrienskies.addon.control.block.torque.IRotationNode;
import org.valkyrienskies.addon.control.block.torque.TileEntityBasicRotationNodeTile;
import org.valkyrienskies.addon.control.block.torque.TileEntityBasicRotationTile;

public class TileEntityGearbox
extends TileEntityBasicRotationNodeTile {
    public static final int GEARBOX_SORTING_PRIORITY = 10;
    private EnumFacing inputFacing;
    private Optional<Double> outputRatio;
    private Optional<Double>[] connectedSidesRatios;

    public TileEntityGearbox() {
        this(EnumFacing.NORTH);
    }

    public TileEntityGearbox(EnumFacing inputFacing) {
        super(10);
        this.inputFacing = inputFacing;
        this.outputRatio = Optional.of(1.0);
        this.connectedSidesRatios = new Optional[]{Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()};
        this.updateRotationNodeRatios();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            Optional<Double>[] rotationNodeRatios = this.rotationNode.connectedRotationRatiosUnsychronized();
            for (EnumFacing facing : EnumFacing.values()) {
                if (this.rotationNode.isConnectedToSideUnsynchronized(facing)) continue;
                rotationNodeRatios[facing.ordinal()] = Optional.empty();
            }
            this.connectedSidesRatios = rotationNodeRatios;
        }
        this.func_70296_d();
    }

    public void setInputFacing(EnumFacing inputFacing) {
        this.inputFacing = inputFacing;
        this.updateRotationNodeRatios();
    }

    private void updateRotationNodeRatios() {
        EnumFacing inputFacingFinal = this.inputFacing;
        Optional<Double> outputRatioFinal = this.outputRatio;
        this.rotationNode.queueTask(() -> {
            for (EnumFacing facing : EnumFacing.values()) {
                double convention = (Double)TileEntityBasicRotationTile.FACING_TO_RATIO_MAP.get((Object)facing);
                if (facing == inputFacingFinal) {
                    this.rotationNode.setAngularVelocityRatio(facing, Optional.of(convention));
                    continue;
                }
                if (outputRatioFinal.isPresent()) {
                    this.rotationNode.setAngularVelocityRatio(facing, Optional.of(convention * (Double)outputRatioFinal.get()));
                    continue;
                }
                this.rotationNode.setAngularVelocityRatio(facing, Optional.empty());
            }
        });
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("inputFacing")) {
            this.inputFacing = EnumFacing.values()[compound.func_74771_c("inputFacing")];
        }
        if (compound.func_74764_b("hasOutput") && compound.func_74767_n("hasOutput") && compound.func_74764_b("outputRatio")) {
            this.outputRatio = Optional.of(compound.func_74769_h("outpuRatio"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74774_a("inputFacing", (byte)this.inputFacing.ordinal());
        Optional<Double> outputRatioFinal = this.outputRatio;
        compound.func_74757_a("hasOutput", outputRatioFinal.isPresent());
        if (outputRatioFinal.isPresent()) {
            compound.func_74780_a("outputRatio", outputRatioFinal.get().doubleValue());
        }
        return compound;
    }

    @SideOnly(value=Side.CLIENT)
    public IRotationNode getClientNode() {
        return this.rotationNode;
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagToSend = new NBTTagCompound();
        tagToSend.func_74780_a("rotation", this.rotation);
        tagToSend.func_74777_a("input_facing", (short)((byte)this.inputFacing.ordinal()));
        byte validSides = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.connectedSidesRatios[i].isPresent()) continue;
            validSides = (byte)(validSides | 1 << i);
            tagToSend.func_74776_a("side_rotation_ratio" + i, this.connectedSidesRatios[i].get().floatValue());
        }
        tagToSend.func_74774_a("valid_sides_byte", validSides);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tagToSend);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.nextRotation = pkt.func_148857_g().func_74769_h("rotation");
        this.inputFacing = EnumFacing.values()[pkt.func_148857_g().func_74771_c("input_facing")];
        byte validSidesByte = pkt.func_148857_g().func_74771_c("valid_sides_byte");
        for (int i = 0; i < 6; ++i) {
            this.connectedSidesRatios[i] = (validSidesByte & 1 << i) != 0 ? Optional.of(Double.valueOf(pkt.func_148857_g().func_74760_g("side_rotation_ratio" + i))) : Optional.empty();
        }
    }

    public Optional<Double> getOutputRatio() {
        return this.outputRatio;
    }

    public void setOutputRatio(Optional<Double> outputRatio) {
        this.outputRatio = outputRatio;
        this.updateRotationNodeRatios();
    }

    public Optional<Double>[] getConnectedSidesRatios() {
        return this.connectedSidesRatios;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumFacing getRenderFacing() {
        return this.inputFacing;
    }
}

