/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.tileentity;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.PhysicsCalculations;
import valkyrienwarfare.api.TransformType;

public class TileEntityGyroscopeStabilizer
extends TileEntity {
    public static final double MAXIMUM_TORQUE = 1.5E7;
    private static final Vector GRAVITY_UP = new Vector(0.0, 1.0, 0.0);

    public Vector getTorqueInGlobal(PhysicsCalculations physicsCalculations, BlockPos pos) {
        Vector shipLevelNormal = new Vector(GRAVITY_UP);
        physicsCalculations.getParent().getShipTransformationManager().getCurrentPhysicsTransform().rotate(shipLevelNormal, TransformType.SUBSPACE_TO_GLOBAL);
        Vector torqueDir = GRAVITY_UP.cross(shipLevelNormal);
        double angleBetween = Math.toDegrees(GRAVITY_UP.angleBetween(shipLevelNormal));
        torqueDir.normalize();
        double torquePowerFactor = angleBetween / 5.0;
        torquePowerFactor = Math.max(Math.min(1.0, torquePowerFactor), 0.0);
        torqueDir.multiply(1.5E7 * torquePowerFactor * physicsCalculations.getPhysicsTimeDeltaPerPhysTick() * -1.0);
        return torqueDir;
    }
}

