/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.tileentity;

import gigaherz.graph.api.GraphObject;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityValkyriumCompressorPart;
import org.valkyrienskies.addon.control.nodenetwork.VSNode_TileEntity;
import org.valkyrienskies.addon.control.piloting.ControllerInputType;
import org.valkyrienskies.addon.control.piloting.PilotControlsMessage;
import org.valkyrienskies.addon.control.tileentity.TileEntityPilotableImpl;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

public class TileEntityLiftLever
extends TileEntityPilotableImpl {
    private static final double LEVER_PULL_RATE = 0.075;
    private float leverOffset = 0.5f;
    private float nextLeverOffset = 0.5f;
    private float prevLeverOffset = 0.5f;
    private double targetYPosition = 0.0;
    private boolean isPilotSprinting = false;
    private int pilotSprintTicks = 0;
    private boolean hasHeightBeenSet = false;

    @Override
    ControllerInputType getControlInputType() {
        return ControllerInputType.LiftLever;
    }

    @Override
    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.prevLeverOffset = this.leverOffset;
            this.leverOffset = (float)((double)(this.nextLeverOffset - this.leverOffset) * 0.7 + (double)this.leverOffset);
        } else {
            if (!this.hasHeightBeenSet) {
                Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(this.func_145831_w(), this.func_174877_v());
                if (physicsObject.isPresent()) {
                    Vector currentPos = new Vector((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
                    physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transform(currentPos, TransformType.SUBSPACE_TO_GLOBAL);
                    this.targetYPosition = currentPos.Y;
                } else {
                    this.targetYPosition = (double)this.func_174877_v().func_177956_o() + 0.5;
                }
                this.hasHeightBeenSet = true;
            }
            if (this.getPilotEntity() == null) {
                this.leverOffset = (float)((double)this.leverOffset + 0.5 * (0.5 - (double)this.leverOffset));
            } else {
                this.func_70296_d();
            }
            this.targetYPosition = !this.isPilotSprinting ? (this.targetYPosition += ((double)this.leverOffset - 0.5) / 2.0) : (this.targetYPosition += ((double)this.leverOffset - 0.5) * 1.25);
            VSNode_TileEntity thisNode = this.getNode();
            Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(this.func_145831_w(), this.func_174877_v());
            if (physicsObject.isPresent()) {
                Vector linearVel = physicsObject.get().getPhysicsProcessor().getVelocityAtPoint(new Vector());
                Vector tilePos = new Vector((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
                physicsObject.get().getShipTransformationManager().getCurrentPhysicsTransform().transform(tilePos, TransformType.SUBSPACE_TO_GLOBAL);
                double heightWithIntegral = tilePos.Y + linearVel.Y * 0.3;
                double heightDelta = this.targetYPosition - heightWithIntegral;
                double multiplier = heightDelta / 2.0;
                multiplier = Math.max(0.0, Math.min(1.0, multiplier));
                for (GraphObject object : thisNode.getGraph().getObjects()) {
                    VSNode_TileEntity otherNode = (VSNode_TileEntity)object;
                    TileEntity tile = otherNode.getParentTile();
                    if (!(tile instanceof TileEntityValkyriumCompressorPart)) continue;
                    BlockPos masterPos = ((TileEntityValkyriumCompressorPart)tile).getMultiblockOrigin();
                    TileEntityValkyriumCompressorPart masterTile = (TileEntityValkyriumCompressorPart)tile.func_145831_w().func_175625_s(masterPos);
                    if (masterTile == null) continue;
                    masterTile.setThrustMultiplierGoal(multiplier);
                }
            }
            IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), blockState, blockState, 0);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPilotText(FontRenderer renderer, ScaledResolution gameResolution) {
        int color = 0xFFFFFF;
        String message = "Target Altitude:    ";
        int i = gameResolution.func_78326_a();
        int height = gameResolution.func_78328_b() - 35;
        float middle = i / 2 - renderer.func_78256_a(message) / 2;
        message = "Target Altitude: " + Math.round(this.targetYPosition);
        renderer.func_175063_a(message, middle, (float)height, color);
    }

    @Override
    void processControlMessage(PilotControlsMessage message, EntityPlayerMP sender) {
        this.isPilotSprinting = message.airshipSprinting;
        this.pilotSprintTicks = this.isPilotSprinting ? ++this.pilotSprintTicks : 0;
        if (message.airshipForward_KeyDown) {
            this.leverOffset = (float)((double)this.leverOffset + 0.075);
            if (this.pilotSprintTicks > 0 && this.pilotSprintTicks < 5) {
                this.leverOffset = (float)((double)this.leverOffset + 1.5);
            }
        }
        if (message.airshipBackward_KeyDown) {
            this.leverOffset = (float)((double)this.leverOffset - 0.075);
            if (this.pilotSprintTicks > 0 && this.pilotSprintTicks < 5) {
                this.leverOffset = (float)((double)this.leverOffset - 1.5);
            }
        }
        if (!message.airshipForward_KeyDown && !message.airshipBackward_KeyDown) {
            this.leverOffset = (double)this.leverOffset > 0.575 ? (float)((double)this.leverOffset - 0.0375) : ((double)this.leverOffset < 0.425 ? (float)((double)this.leverOffset + 0.0375) : 0.5f);
        }
        this.leverOffset = message.airshipSprinting ? (this.pilotSprintTicks > 0 && this.pilotSprintTicks < 5 ? Math.max(0.0f, Math.min(1.0f, this.leverOffset)) : Math.max(0.1f, Math.min(0.9f, this.leverOffset))) : Math.max(0.25f, Math.min(0.75f, this.leverOffset));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound toReturn = super.func_189515_b(compound);
        compound.func_74776_a("leverOffset", this.leverOffset);
        compound.func_74780_a("targetYPosition", this.targetYPosition);
        compound.func_74757_a("hasHeightBeenSet", this.hasHeightBeenSet);
        return toReturn;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.leverOffset = compound.func_74760_g("leverOffset");
        this.targetYPosition = compound.func_74769_h("targetYPosition");
        this.hasHeightBeenSet = compound.func_74767_n("hasHeightBeenSet");
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.nextLeverOffset = pkt.func_148857_g().func_74760_g("leverOffset");
        this.targetYPosition = pkt.func_148857_g().func_74769_h("targetYPosition");
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound toReturn = super.func_189517_E_();
        toReturn.func_74776_a("leverOffset", this.leverOffset);
        toReturn.func_74780_a("targetYPosition", this.targetYPosition);
        return toReturn;
    }

    public float getLeverOffset() {
        return this.leverOffset;
    }

    public float getPrevLeverOffset() {
        return this.prevLeverOffset;
    }
}

