/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.tileentity;

import java.util.Optional;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.valkyrienskies.addon.control.ValkyrienSkiesControl;
import org.valkyrienskies.addon.control.network.MessageStartPiloting;
import org.valkyrienskies.addon.control.network.MessageStopPiloting;
import org.valkyrienskies.addon.control.nodenetwork.BasicNodeTileEntity;
import org.valkyrienskies.addon.control.piloting.ControllerInputType;
import org.valkyrienskies.addon.control.piloting.ITileEntityPilotable;
import org.valkyrienskies.addon.control.piloting.PilotControlsMessage;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

public abstract class TileEntityPilotableImpl
extends BasicNodeTileEntity
implements ITileEntityPilotable {
    private EntityPlayer pilotPlayerEntity = null;

    TileEntityPilotableImpl() {
    }

    @Override
    public final void onPilotControlsMessage(PilotControlsMessage message, EntityPlayerMP sender) {
        if (sender == this.pilotPlayerEntity) {
            this.processControlMessage(message, sender);
        }
    }

    @Override
    public final EntityPlayer getPilotEntity() {
        return this.pilotPlayerEntity;
    }

    @Override
    public final void setPilotEntity(EntityPlayer toSet) {
        if (!this.func_145831_w().field_72995_K) {
            this.sendPilotUpdatePackets((EntityPlayerMP)toSet, (EntityPlayerMP)this.pilotPlayerEntity);
        }
        this.pilotPlayerEntity = toSet;
        if (this.pilotPlayerEntity != null) {
            this.onStartTileUsage(this.pilotPlayerEntity);
        } else {
            this.onStopTileUsage();
        }
    }

    @Override
    public final void playerWantsToStopPiloting(EntityPlayer player) {
        if (player == this.getPilotEntity()) {
            this.setPilotEntity(null);
        }
    }

    @Override
    public final PhysicsWrapperEntity getParentPhysicsEntity() {
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(this.field_145850_b, this.field_174879_c);
        if (physicsObject.isPresent()) {
            return physicsObject.get().getWrapperEntity();
        }
        return null;
    }

    private final void sendPilotUpdatePackets(EntityPlayerMP newPilot, EntityPlayerMP oldPilot) {
        if (oldPilot != null) {
            MessageStopPiloting stopMessage = new MessageStopPiloting(this.func_174877_v());
            ValkyrienSkiesControl.controlNetwork.sendTo((IMessage)stopMessage, oldPilot);
        }
        if (newPilot != null) {
            MessageStartPiloting startMessage = new MessageStartPiloting(this.func_174877_v(), this.setClientPilotingEntireShip(), this.getControlInputType());
            ValkyrienSkiesControl.controlNetwork.sendTo((IMessage)startMessage, newPilot);
        }
    }

    abstract ControllerInputType getControlInputType();

    @Deprecated
    boolean setClientPilotingEntireShip() {
        return false;
    }

    abstract void processControlMessage(PilotControlsMessage var1, EntityPlayerMP var2);

    protected boolean isPlayerInFront(EntityPlayer player, EnumFacing blockFacing) {
        double dotProduct;
        Vector tileRelativePos = new Vector((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        if (this.getParentPhysicsEntity() != null) {
            this.getParentPhysicsEntity().getPhysicsObject().getShipTransformationManager().getCurrentTickTransform().transform(tileRelativePos, TransformType.SUBSPACE_TO_GLOBAL);
        }
        tileRelativePos.subtract(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        Vector normal = new Vector(blockFacing.func_176730_m().func_177958_n() * -1, blockFacing.func_176730_m().func_177956_o(), blockFacing.func_176730_m().func_177952_p());
        if (this.getParentPhysicsEntity() != null) {
            this.getParentPhysicsEntity().getPhysicsObject().getShipTransformationManager().getCurrentTickTransform().rotate(normal, TransformType.SUBSPACE_TO_GLOBAL);
        }
        return (dotProduct = tileRelativePos.dot(normal)) > 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderPilotText(FontRenderer renderer, ScaledResolution gameResolution) {
    }
}

