/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.control.tileentity;

import gigaherz.graph.api.GraphObject;
import java.util.Optional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.valkyrienskies.addon.control.ValkyrienSkiesControl;
import org.valkyrienskies.addon.control.block.BlockShipHelm;
import org.valkyrienskies.addon.control.block.multiblocks.TileEntityRudderPart;
import org.valkyrienskies.addon.control.nodenetwork.VSNode_TileEntity;
import org.valkyrienskies.addon.control.piloting.ControllerInputType;
import org.valkyrienskies.addon.control.piloting.PilotControlsMessage;
import org.valkyrienskies.addon.control.tileentity.TileEntityPilotableImpl;
import org.valkyrienskies.fixes.VSNetwork;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

public class TileEntityShipHelm
extends TileEntityPilotableImpl
implements ITickable {
    public double compassAngle = 0.0;
    public double lastCompassAngle = 0.0;
    public double wheelRotation = 0.0;
    public double lastWheelRotation = 0.0;
    private double nextWheelRotation;

    @Override
    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.calculateCompassAngle();
            this.lastWheelRotation = this.wheelRotation;
            this.wheelRotation += (this.nextWheelRotation - this.wheelRotation) * 0.25;
        } else {
            if (this.getPilotEntity() == null) {
                double friction = 0.05;
                double toOriginRate = 0.05;
                if (Math.abs(this.wheelRotation) < 1.5) {
                    this.wheelRotation = 0.0;
                } else {
                    double deltaForce = Math.max(Math.abs(this.wheelRotation * toOriginRate) - friction, 0.0);
                    this.wheelRotation += deltaForce * -1.0 * Math.signum(this.wheelRotation);
                }
            }
            VSNode_TileEntity thisNode = this.getNode();
            for (GraphObject object : thisNode.getGraph().getObjects()) {
                VSNode_TileEntity otherNode = (VSNode_TileEntity)object;
                TileEntity tile = otherNode.getParentTile();
                if (!(tile instanceof TileEntityRudderPart)) continue;
                BlockPos masterPos = ((TileEntityRudderPart)tile).getMultiblockOrigin();
                TileEntityRudderPart masterTile = (TileEntityRudderPart)tile.func_145831_w().func_175625_s(masterPos);
                if (masterTile == null) continue;
                masterTile.setRudderAngle(-this.wheelRotation / 8.0);
            }
            VSNetwork.sendTileToAllNearby(this);
        }
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.nextWheelRotation = pkt.func_148857_g().func_74769_h("wheelRotation");
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagToSend = new NBTTagCompound();
        tagToSend.func_74780_a("wheelRotation", this.wheelRotation);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tagToSend);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound toReturn = super.func_189517_E_();
        toReturn.func_74780_a("wheelRotation", this.wheelRotation);
        return toReturn;
    }

    public void calculateCompassAngle() {
        this.lastCompassAngle = this.compassAngle;
        IBlockState helmState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (helmState.func_177230_c() != ValkyrienSkiesControl.INSTANCE.vsControlBlocks.shipHelm) {
            return;
        }
        EnumFacing enumfacing = (EnumFacing)helmState.func_177229_b((IProperty)BlockShipHelm.FACING);
        double wheelAndCompassStateRotation = enumfacing.func_185119_l();
        BlockPos spawnPos = this.func_145831_w().func_175694_M();
        Vector compassPoint = new Vector(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        compassPoint.add(1.0, 2.0, 1.0);
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(this.func_145831_w(), this.func_174877_v());
        if (physicsObject.isPresent()) {
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transform(compassPoint, TransformType.SUBSPACE_TO_GLOBAL);
        }
        Vector compassDirection = new Vector(compassPoint);
        compassDirection.subtract(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
        if (physicsObject.isPresent()) {
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().rotate(compassDirection, TransformType.GLOBAL_TO_SUBSPACE);
        }
        compassDirection.normalize();
        this.compassAngle = Math.toDegrees(Math.atan2(compassDirection.X, compassDirection.Z)) - wheelAndCompassStateRotation;
        this.compassAngle = (this.compassAngle + 360.0) % 360.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.lastWheelRotation = this.wheelRotation = compound.func_74769_h("wheelRotation");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound toReturn = super.func_189515_b(compound);
        compound.func_74780_a("wheelRotation", this.wheelRotation);
        return toReturn;
    }

    @Override
    ControllerInputType getControlInputType() {
        return ControllerInputType.ShipHelm;
    }

    @Override
    void processControlMessage(PilotControlsMessage message, EntityPlayerMP sender) {
        IBlockState blockState;
        double rotationDelta = 0.0;
        if (message.airshipLeft_KeyDown) {
            rotationDelta -= 12.5;
        }
        if (message.airshipRight_KeyDown) {
            rotationDelta += 12.5;
        }
        if ((blockState = this.func_145831_w().func_180495_p(this.func_174877_v())).func_177230_c() instanceof BlockShipHelm) {
            EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)BlockShipHelm.FACING);
            this.wheelRotation = this.isPlayerInFront((EntityPlayer)sender, facing) ? (this.wheelRotation += rotationDelta) : (this.wheelRotation -= rotationDelta);
        }
        double max_rotation = 720.0;
        this.wheelRotation = Math.min(Math.max(this.wheelRotation, -max_rotation), max_rotation);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPilotText(FontRenderer renderer, ScaledResolution gameResolution) {
        int color = 0xFFFFFF;
        String message = "Wheel Rotation:    ";
        int i = gameResolution.func_78326_a();
        int height = gameResolution.func_78328_b() - 35;
        float middle = i / 2 - renderer.func_78256_a(message) / 2;
        message = "Wheel Rotation: " + Math.round(this.wheelRotation);
        renderer.func_175063_a(message, middle, (float)height, color);
    }
}

