/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.world;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.addon.world.EntityFallingUpBlock;
import org.valkyrienskies.addon.world.ItemValkyriumCrystal;
import org.valkyrienskies.addon.world.WorldEventsCommon;
import org.valkyrienskies.addon.world.block.BlockValkyriumOre;
import org.valkyrienskies.addon.world.capability.ICapabilityAntiGravity;
import org.valkyrienskies.addon.world.capability.ImplCapabilityAntiGravity;
import org.valkyrienskies.addon.world.capability.StorageAntiGravity;
import org.valkyrienskies.addon.world.proxy.CommonProxyWorld;
import org.valkyrienskies.addon.world.worldgen.ValkyrienSkiesWorldGen;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;

@Mod(name="Valkyrien Skies World", modid="vs_world", version="1.0-alpha-1", dependencies="required-after:valkyrienskies", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber(modid="vs_world")
public class ValkyrienSkiesWorld {
    private static final Logger log = LogManager.getLogger(ValkyrienSkiesWorld.class);
    public static final String MOD_ID = "vs_world";
    static final String MOD_NAME = "Valkyrien Skies World";
    static final String MOD_VERSION = "1.0-alpha-1";
    @Mod.Instance(value="vs_world")
    public static ValkyrienSkiesWorld INSTANCE;
    @SidedProxy(clientSide="org.valkyrienskies.addon.world.proxy.ClientProxyWorld", serverSide="org.valkyrienskies.addon.world.proxy.CommonProxyWorld")
    private static CommonProxyWorld proxy;
    @CapabilityInject(value=ICapabilityAntiGravity.class)
    public static final Capability<ICapabilityAntiGravity> ANTI_GRAVITY_CAPABILITY;
    private static final WorldEventsCommon worldEventsCommon;
    public static boolean OREGEN_ENABLED;
    public Block valkyriumOre;
    public Item valkyriumCrystal;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        log.debug("Registering blocks...");
        ValkyrienSkiesWorld.INSTANCE.valkyriumOre = ((Block)new BlockValkyriumOre(Material.field_151576_e).func_149711_c(3.0f).func_149663_c("valkyrium_ore").setRegistryName(MOD_ID, "valkyrium_ore")).func_149647_a(ValkyrienSkiesMod.VS_CREATIVE_TAB);
        event.getRegistry().register((IForgeRegistryEntry)ValkyrienSkiesWorld.INSTANCE.valkyriumOre);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ValkyrienSkiesWorld.INSTANCE.valkyriumCrystal = ((Item)new ItemValkyriumCrystal().func_77655_b("valkyrium_crystal").setRegistryName(MOD_ID, "valkyrium_crystal")).func_77637_a(ValkyrienSkiesMod.VS_CREATIVE_TAB).func_77625_d(16);
        event.getRegistry().register((IForgeRegistryEntry)ValkyrienSkiesWorld.INSTANCE.valkyriumCrystal);
        event.getRegistry().register(new ItemBlock(ValkyrienSkiesWorld.INSTANCE.valkyriumOre).setRegistryName(ValkyrienSkiesWorld.INSTANCE.valkyriumOre.getRegistryName()));
    }

    @Mod.EventHandler
    private void preInit(FMLPreInitializationEvent event) {
        this.registerCapabilities();
        proxy.preInit((FMLStateEvent)event);
    }

    @Mod.EventHandler
    protected void init(FMLInitializationEvent event) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MOD_ID, "fall_up_block_entity"), EntityFallingUpBlock.class, (String)"fall_up_block_entity", (int)75, (Object)INSTANCE, (int)80, (int)1, (boolean)true);
        MinecraftForge.EVENT_BUS.register((Object)worldEventsCommon);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ValkyrienSkiesWorldGen(), (int)1);
        proxy.init((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit((FMLStateEvent)event);
    }

    private void registerCapabilities() {
        CapabilityManager.INSTANCE.register(ICapabilityAntiGravity.class, (Capability.IStorage)new StorageAntiGravity(), ImplCapabilityAntiGravity::new);
    }

    static {
        ANTI_GRAVITY_CAPABILITY = null;
        worldEventsCommon = new WorldEventsCommon();
        OREGEN_ENABLED = true;
    }
}

