/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.addon.world;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.valkyrienskies.addon.world.ItemValkyriumCrystal;
import org.valkyrienskies.addon.world.ValkyrienSkiesWorld;
import org.valkyrienskies.addon.world.block.BlockValkyriumOre;
import org.valkyrienskies.addon.world.capability.AntiGravityCapabilityProvider;
import org.valkyrienskies.addon.world.capability.ICapabilityAntiGravity;
import org.valkyrienskies.mod.common.config.VSConfig;

public class WorldEventsCommon {
    @SubscribeEvent
    public void onAttachCapabilityEventItem(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof ItemStack) {
            ItemBlock blockItem;
            ItemStack stack = (ItemStack)event.getObject();
            Item item = stack.func_77973_b();
            if (item instanceof ItemValkyriumCrystal) {
                event.addCapability(new ResourceLocation("vs_world", "AntiGravityValue"), (ICapabilityProvider)new AntiGravityCapabilityProvider(VSConfig.valkyriumCrystalForce));
            }
            if (stack.func_77973_b() instanceof ItemBlock && (blockItem = (ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockValkyriumOre) {
                event.addCapability(new ResourceLocation("vs_world", "AntiGravityValue"), (ICapabilityProvider)new AntiGravityCapabilityProvider(VSConfig.valkyriumOreForce));
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (Entity entity : event.world.field_72996_f) {
                EntityItem itemEntity;
                ItemStack itemStack;
                ICapabilityAntiGravity capability;
                if (!(entity instanceof EntityItem) || (capability = (ICapabilityAntiGravity)(itemStack = (itemEntity = (EntityItem)entity).func_92059_d()).getCapability(ValkyrienSkiesWorld.ANTI_GRAVITY_CAPABILITY, null)) == null || capability.getMultiplier() == 0.0) continue;
                double multiplier = 0.12 / capability.getMultiplier();
                itemEntity.func_70024_g(0.0, 0.1 - itemEntity.field_70181_x * multiplier, 0.0);
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityPlayer player = event.player;
            if (VSConfig.doValkyriumLifting && !player.func_184812_l_()) {
                for (NonNullList stackArray : player.field_71071_by.field_184440_g) {
                    for (ItemStack stack : stackArray) {
                        if (stack == null) continue;
                        if (stack.func_77973_b() instanceof ItemBlock) {
                            ItemBlock blockItem = (ItemBlock)stack.func_77973_b();
                            if (!(blockItem.func_179223_d() instanceof BlockValkyriumOre)) continue;
                            player.func_70024_g(0.0, 0.0025 * (double)stack.field_77994_a * VSConfig.valkyriumOreForce, 0.0);
                            continue;
                        }
                        if (!(stack.func_77973_b() instanceof ItemValkyriumCrystal)) continue;
                        player.func_70024_g(0.0, 0.0025 * (double)stack.field_77994_a * VSConfig.valkyriumCrystalForce, 0.0);
                    }
                }
            }
        }
    }
}

