/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.fixes;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.play.INetHandlerPlayServer;
import org.valkyrienskies.mod.common.MixinLoadManager;
import org.valkyrienskies.mod.common.coordinates.CoordinateSpaceType;
import org.valkyrienskies.mod.common.coordinates.ISubspace;
import org.valkyrienskies.mod.common.coordinates.ISubspaceProvider;
import org.valkyrienskies.mod.common.coordinates.ISubspacedEntity;
import org.valkyrienskies.mod.common.coordinates.ISubspacedEntityRecord;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import valkyrienwarfare.api.TransformType;

public interface ITransformablePacket {
    default public boolean isPacketOnMainThread(INetHandlerPlayServer server, boolean callingFromSponge) {
        if (!MixinLoadManager.isSpongeEnabled() || callingFromSponge) {
            NetHandlerPlayServer serverHandler = (NetHandlerPlayServer)server;
            EntityPlayerMP player = serverHandler.field_147369_b;
            return player.func_71121_q().func_152345_ab();
        }
        return false;
    }

    default public void doPreProcessing(INetHandlerPlayServer server, boolean callingFromSponge) {
        if (this.isPacketOnMainThread(server, callingFromSponge)) {
            NetHandlerPlayServer serverHandler = (NetHandlerPlayServer)server;
            EntityPlayerMP player = serverHandler.field_147369_b;
            PhysicsWrapperEntity wrapper = this.getPacketParent(serverHandler);
            if (wrapper != null && wrapper.getPhysicsObject().getShipTransformationManager() != null) {
                ISubspaceProvider worldProvider = (ISubspaceProvider)player.func_71121_q();
                ISubspace worldSubspace = worldProvider.getSubspace();
                worldSubspace.snapshotSubspacedEntity((ISubspacedEntity)player);
                wrapper.getPhysicsObject().getShipTransformationManager().getCurrentTickTransform().transform((Entity)player, TransformType.GLOBAL_TO_SUBSPACE);
            }
        }
    }

    default public void doPostProcessing(INetHandlerPlayServer server, boolean callingFromSponge) {
        if (this.isPacketOnMainThread(server, callingFromSponge)) {
            NetHandlerPlayServer serverHandler = (NetHandlerPlayServer)server;
            EntityPlayerMP player = serverHandler.field_147369_b;
            PhysicsWrapperEntity wrapper = this.getPacketParent(serverHandler);
            ISubspaceProvider worldProvider = (ISubspaceProvider)player.func_71121_q();
            ISubspace worldSubspace = worldProvider.getSubspace();
            ISubspacedEntity subspacedEntity = (ISubspacedEntity)player;
            ISubspacedEntityRecord record = worldSubspace.getRecordForSubspacedEntity(subspacedEntity);
            if (subspacedEntity.currentSubspaceType() == CoordinateSpaceType.SUBSPACE_COORDINATES) {
                subspacedEntity.restoreSubspacedEntityStateToRecord(record);
                player.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }
        }
    }

    public PhysicsWrapperEntity getPacketParent(NetHandlerPlayServer var1);
}

