/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.client.particle;

import java.util.Optional;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@Mixin(value={ParticleManager.class})
public abstract class MixinParticleManager {
    @Inject(method={"addEffect"}, at={@At(value="HEAD")}, cancellable=true)
    public void preAddEffect(Particle effect, CallbackInfo callbackInfoReturnable) {
        if (effect == null) {
            callbackInfoReturnable.cancel();
            return;
        }
        BlockPos pos = new BlockPos(effect.field_187126_f, effect.field_187127_g, effect.field_187128_h);
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(effect.field_187122_b, pos);
        if (physicsObject.isPresent()) {
            Vector posVec = new Vector(effect.field_187126_f, effect.field_187127_g, effect.field_187128_h);
            Vector velocity = new Vector(effect.field_187129_i, effect.field_187130_j, effect.field_187131_k);
            physicsObject.get().getShipTransformationManager().fromLocalToGlobal(posVec);
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().rotate(velocity, TransformType.SUBSPACE_TO_GLOBAL);
            effect.func_187109_b(posVec.X, posVec.Y, posVec.Z);
            effect.field_187129_i = velocity.X;
            effect.field_187130_j = velocity.Y;
            effect.field_187131_k = velocity.Z;
        }
    }
}

