/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.client.renderer;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.valkyrienskies.addon.control.piloting.IShipPilot;
import org.valkyrienskies.mod.common.math.Quaternion;
import org.valkyrienskies.mod.common.math.RotationMatrices;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physmanagement.interaction.IWorldVS;
import org.valkyrienskies.mod.common.util.EntityShipMountData;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@Mixin(value={EntityRenderer.class})
public abstract class MixinEntityRenderer {
    protected final Vector eyeVector = new Vector();
    protected final Vector cachedPosition = new Vector();
    protected EntityShipMountData mountData;
    protected float vs_partialTicks;
    @Shadow
    @Final
    public Minecraft field_78531_r;
    @Shadow
    public float field_78491_C;
    @Shadow
    public boolean field_78500_U;

    @Redirect(method={"Lnet/minecraft/client/renderer/EntityRenderer;orientCamera(F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getRenderViewEntity()Lnet/minecraft/entity/Entity;"))
    private Entity resetThingsBeforeOrientCamera(Minecraft mc, float partialTicks) {
        Entity entity = mc.func_175606_aa();
        this.vs_partialTicks = partialTicks;
        EntityShipMountData mountData = ValkyrienUtils.getMountedShipAndPos(entity);
        this.mountData = mountData.isMounted() ? mountData : null;
        this.eyeVector.setValue(0.0, (double)entity.func_70047_e() + (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70608_bn() ? 0.7 : 0.0), 0.0);
        if (this.mountData != null && this.mountData.getMountedShip().getShipRenderer().offsetPos != null) {
            Quaternion orientationQuat = this.mountData.getMountedShip().getShipRenderer().getSmoothRotationQuat(partialTicks);
            double[] radians = orientationQuat.toRadians();
            float moddedPitch = (float)Math.toDegrees(radians[0]);
            float moddedYaw = (float)Math.toDegrees(radians[1]);
            float moddedRoll = (float)Math.toDegrees(radians[2]);
            double[] orientationMatrix = RotationMatrices.getRotationMatrix(moddedPitch, moddedYaw, moddedRoll);
            RotationMatrices.applyTransform(orientationMatrix, this.eyeVector);
            this.cachedPosition.setValue(this.mountData.getMountPos());
            this.mountData.getMountedShip().getShipTransformationManager().getRenderTransform().transform(this.cachedPosition, TransformType.SUBSPACE_TO_GLOBAL);
        }
        return entity;
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/EntityRenderer;orientCamera(F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getEyeHeight()F"))
    private float dontGetEyeHeight(Entity e) {
        return 0.0f;
    }

    @ModifyVariable(method={"Lnet/minecraft/client/renderer/EntityRenderer;orientCamera(F)V"}, index=4, at=@At(value="JUMP", opcode=153, ordinal=0, shift=At.Shift.BY, by=-2))
    private double offsetXIfMounted(double oldVal) {
        return (this.mountData != null && this.mountData.getMountedShip().getShipRenderer().offsetPos != null ? this.cachedPosition.X : oldVal) + this.eyeVector.X;
    }

    @ModifyVariable(method={"Lnet/minecraft/client/renderer/EntityRenderer;orientCamera(F)V"}, index=6, at=@At(value="JUMP", opcode=153, ordinal=0, shift=At.Shift.BY, by=-2))
    private double offsetYIfMounted(double oldVal) {
        return (this.mountData != null && this.mountData.getMountedShip().getShipRenderer().offsetPos != null ? this.cachedPosition.Y : oldVal) + this.eyeVector.Y;
    }

    @ModifyVariable(method={"Lnet/minecraft/client/renderer/EntityRenderer;orientCamera(F)V"}, index=8, at=@At(value="JUMP", opcode=153, ordinal=0, shift=At.Shift.BY, by=-2))
    private double offsetZIfMounted(double oldVal) {
        return (this.mountData != null && this.mountData.getMountedShip().getShipRenderer().offsetPos != null ? this.cachedPosition.Z : oldVal) + this.eyeVector.Z;
    }

    @ModifyConstant(method={"Lnet/minecraft/client/renderer/EntityRenderer;orientCamera(F)V"}, constant={@Constant(doubleValue=1.0, ordinal=0)})
    private double dontIncrementF(double one) {
        return 0.0;
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/EntityRenderer;orientCamera(F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GlStateManager;translate(FFF)V", ordinal=0))
    private void dontDoTranslate1(float x, float y, float z) {
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/EntityRenderer;orientCamera(F)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/settings/GameSettings;debugCamEnable:Z", ordinal=0))
    private boolean dontRotateIfMounted(GameSettings settings, float partialTicks) {
        if (!settings.field_74325_U) {
            Entity entity = this.field_78531_r.func_175606_aa();
            if (this.mountData != null && this.mountData.getMountedShip().getShipRenderer().offsetPos != null) {
                Vector playerPosInLocal = new Vector(this.mountData.getMountPos());
                playerPosInLocal.subtract(0.5, 0.6875, 0.5);
                playerPosInLocal.roundToWhole();
                BlockPos bedPos = new BlockPos(playerPosInLocal.X, playerPosInLocal.Y, playerPosInLocal.Z);
                IBlockState state = this.field_78531_r.field_71441_e.func_180495_p(bedPos);
                Block block = state.func_177230_c();
                float angleYaw = 0.0f;
                if (block != null && block.isBed(state, (IBlockAccess)entity.field_70170_p, bedPos, entity)) {
                    angleYaw = (float)block.getBedDirection(state, (IBlockAccess)entity.field_70170_p, bedPos).func_176736_b() * 90.0f;
                    angleYaw += 180.0f;
                }
                entity.field_70177_z = entity.field_70126_B = angleYaw;
                entity.field_70127_C = 0.0f;
                entity.field_70125_A = 0.0f;
            } else {
                return true;
            }
        }
        return false;
    }

    @ModifyVariable(method={"Lnet/minecraft/client/renderer/EntityRenderer;orientCamera(F)V"}, index=10, at=@At(value="FIELD", target="Lnet/minecraft/client/settings/GameSettings;debugCamEnable:Z", ordinal=1))
    private double zoomOutIfPiloting(double oldZoom) {
        return ((IShipPilot)this.field_78531_r.field_71439_g).isPilotingShip() ? 15.0 : oldZoom;
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/EntityRenderer;orientCamera(F)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/settings/GameSettings;thirdPersonView:I", ordinal=1))
    private int excludeShipFromRayTracerBeforeDepthProbe(GameSettings settings) {
        ((IWorldVS)this.field_78531_r.field_71441_e).excludeShipFromRayTracer(((IShipPilot)this.field_78531_r.field_71439_g).getPilotedShip());
        return settings.field_74320_O;
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/EntityRenderer;orientCamera(F)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/settings/GameSettings;thirdPersonView:I", ordinal=2))
    private int unexcludeShipFromRayTracerAfterDepthProbe(GameSettings settings) {
        ((IWorldVS)this.field_78531_r.field_71441_e).unexcludeShipFromRayTracer(((IShipPilot)this.field_78531_r.field_71439_g).getPilotedShip());
        return settings.field_74320_O;
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/EntityRenderer;orientCamera(F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GlStateManager;translate(FFF)V", ordinal=4))
    private void rotateCameraAndFixFinalTranslate(float x, float y, float z, float partialTicks) {
        if (this.mountData != null && this.mountData.getMountedShip().getShipRenderer().getSmoothRotationQuat(partialTicks) != null) {
            Quaternion orientationQuat = this.mountData.getMountedShip().getShipRenderer().getSmoothRotationQuat(partialTicks);
            double[] radians = orientationQuat.toRadians();
            float moddedPitch = (float)Math.toDegrees(radians[0]);
            float moddedYaw = (float)Math.toDegrees(radians[1]);
            float moddedRoll = (float)Math.toDegrees(radians[2]);
            GlStateManager.func_179114_b((float)(-moddedRoll), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(-moddedYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-moddedPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        this.mountData = null;
        GlStateManager.func_179137_b((double)((double)x - this.eyeVector.X), (double)((double)y - this.eyeVector.Y), (double)((double)z - this.eyeVector.Z));
    }

    @Redirect(method={"Lnet/minecraft/client/renderer/EntityRenderer;orientCamera(F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderGlobal;hasCloudFog(DDDF)Z"))
    private boolean fixHasCloudFogCoordinates(RenderGlobal renderGlobal, double x, double y, double z, float partialTicks) {
        return renderGlobal.func_72721_a(x + this.eyeVector.X, y + this.eyeVector.Y, z + this.eyeVector.Z, partialTicks);
    }
}

