/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.client.renderer.entity;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.util.EntityShipMountData;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;

@Mixin(value={RenderManager.class})
public abstract class MixinRenderManager {
    private boolean hasChanged = false;

    @Shadow
    public abstract void func_188391_a(Entity var1, double var2, double var4, double var6, float var8, float var9, boolean var10);

    @Inject(method={"renderEntity"}, at={@At(value="HEAD")}, cancellable=true)
    public void preDoRenderEntity(Entity entityIn, double x, double y, double z, float yaw, float partialTicks, boolean p_188391_10_, CallbackInfo callbackInfo) {
        EntityShipMountData mountData;
        if (!this.hasChanged && (mountData = ValkyrienUtils.getMountedShipAndPos(entityIn)).isMounted()) {
            EntityPlayer player;
            double oldPosX = entityIn.field_70165_t;
            double oldPosY = entityIn.field_70163_u;
            double oldPosZ = entityIn.field_70161_v;
            double oldLastPosX = entityIn.field_70142_S;
            double oldLastPosY = entityIn.field_70137_T;
            double oldLastPosZ = entityIn.field_70136_U;
            Vector localPosition = new Vector(mountData.getMountPos());
            mountData.getMountedShip().getShipRenderer().applyRenderTransform(partialTicks);
            if (localPosition != null) {
                localPosition = new Vector(localPosition);
                localPosition.X -= (double)mountData.getMountedShip().getShipRenderer().offsetPos.func_177958_n();
                localPosition.Y -= (double)mountData.getMountedShip().getShipRenderer().offsetPos.func_177956_o();
                localPosition.Z -= (double)mountData.getMountedShip().getShipRenderer().offsetPos.func_177952_p();
                entityIn.field_70165_t = entityIn.field_70142_S = localPosition.X;
                x = entityIn.field_70142_S;
                entityIn.field_70163_u = entityIn.field_70137_T = localPosition.Y;
                y = entityIn.field_70137_T;
                entityIn.field_70161_v = entityIn.field_70136_U = localPosition.Z;
                z = entityIn.field_70136_U;
            }
            boolean makePlayerMount = false;
            PhysicsWrapperEntity shipRidden = null;
            if (entityIn instanceof EntityPlayer && (player = (EntityPlayer)entityIn).func_70608_bn()) {
                if (player.field_184239_as instanceof PhysicsWrapperEntity) {
                    shipRidden = (PhysicsWrapperEntity)player.field_184239_as;
                }
                if (shipRidden != null) {
                    player.field_184239_as = null;
                    makePlayerMount = true;
                    Vector playerPosInLocal = new Vector(mountData.getMountPos());
                    playerPosInLocal.subtract(0.5, 0.6875, 0.5);
                    playerPosInLocal.roundToWhole();
                    BlockPos bedPos = new BlockPos(playerPosInLocal.X, playerPosInLocal.Y, playerPosInLocal.Z);
                    IBlockState state = entityIn.field_70170_p.func_180495_p(bedPos);
                    Block block = state.func_177230_c();
                    float angleYaw = 0.0f;
                    if (block != null && block.isBed(state, (IBlockAccess)entityIn.field_70170_p, bedPos, entityIn)) {
                        angleYaw = block.getBedDirection(state, (IBlockAccess)entityIn.field_70170_p, bedPos).func_176736_b() * 90;
                    }
                    GL11.glRotatef((float)angleYaw, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            this.hasChanged = true;
            this.func_188391_a(entityIn, x, y, z, yaw, partialTicks, p_188391_10_);
            this.hasChanged = false;
            if (makePlayerMount) {
                player = (EntityPlayer)entityIn;
                player.field_184239_as = shipRidden;
            }
            if (localPosition != null) {
                mountData.getMountedShip().getShipRenderer().inverseTransform(partialTicks);
            }
            entityIn.field_70165_t = oldPosX;
            entityIn.field_70163_u = oldPosY;
            entityIn.field_70161_v = oldPosZ;
            entityIn.field_70142_S = oldLastPosX;
            entityIn.field_70137_T = oldLastPosY;
            entityIn.field_70136_U = oldLastPosZ;
            callbackInfo.cancel();
        }
    }
}

