/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.entity;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.coordinates.CoordinateSpaceType;
import org.valkyrienskies.mod.common.coordinates.ISubspacedEntity;
import org.valkyrienskies.mod.common.coordinates.ISubspacedEntityRecord;
import org.valkyrienskies.mod.common.coordinates.VectorImmutable;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.VSMath;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.physmanagement.chunk.PhysicsChunkManager;
import org.valkyrienskies.mod.common.physmanagement.interaction.IDraggable;
import org.valkyrienskies.mod.common.util.EntityShipMountData;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements IDraggable,
ISubspacedEntity {
    private final IDraggable thisAsDraggable = this;
    private final Entity thisAsEntity = (Entity)Entity.class.cast(this);
    @Shadow
    public float field_70177_z;
    @Shadow
    public float field_70125_A;
    @Shadow
    public float field_70126_B;
    @Shadow
    public float field_70127_C;
    @Shadow
    public World field_70170_p;
    @Shadow
    public double field_70165_t;
    @Shadow
    public double field_70163_u;
    @Shadow
    public double field_70161_v;
    private PhysicsWrapperEntity worldBelowFeet;
    private PhysicsWrapperEntity forcedRelativeWorldBelowFeet;
    private Vector velocityAddedToPlayer = new Vector();
    private double yawDifVelocity;
    private boolean cancelNextMove = false;
    private Vector positionInShipSpace;
    private Vector velocityInShipSpace;
    private Vector searchVector = null;

    @Override
    public CoordinateSpaceType currentSubspaceType() {
        int entityChunkXPosition = (int)this.field_70165_t >> 4;
        int entityChunkZPosition = (int)this.field_70161_v >> 4;
        boolean isInShipChunks = PhysicsChunkManager.isLikelyShipChunk(entityChunkXPosition, entityChunkZPosition);
        if (isInShipChunks) {
            return CoordinateSpaceType.SUBSPACE_COORDINATES;
        }
        return CoordinateSpaceType.GLOBAL_COORDINATES;
    }

    @Override
    public Vector createCurrentPositionVector() {
        return new Vector(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Override
    public Vector createLastTickPositionVector() {
        return new Vector(this.thisAsEntity.field_70142_S, this.thisAsEntity.field_70137_T, this.thisAsEntity.field_70136_U);
    }

    @Override
    public Vector createCurrentLookVector() {
        return new Vector(this.thisAsEntity.func_70040_Z());
    }

    @Override
    public Vector createCurrentVelocityVector() {
        return new Vector(this.thisAsEntity.field_70159_w, this.thisAsEntity.field_70181_x, this.thisAsEntity.field_70179_y);
    }

    @Override
    public void restoreSubspacedEntityStateToRecord(ISubspacedEntityRecord record) {
        VectorImmutable coordinates = record.getPosition();
        VectorImmutable coordinatesLastTick = record.getPositionLastTick();
        VectorImmutable lookVector = record.getLookDirection();
        VectorImmutable velocityVector = record.getVelocity();
        this.thisAsEntity.field_70142_S = coordinatesLastTick.getX();
        this.thisAsEntity.field_70137_T = coordinatesLastTick.getY();
        this.thisAsEntity.field_70136_U = coordinatesLastTick.getZ();
        double pitch = VSMath.getPitchFromVectorImmutable(lookVector);
        double yaw = VSMath.getYawFromVectorImmutable(lookVector, pitch);
        this.field_70125_A = (float)pitch;
        this.field_70177_z = (float)yaw;
        this.thisAsEntity.func_70107_b(coordinates.getX(), coordinates.getY(), coordinates.getZ());
    }

    @Override
    public int getSubspacedEntityID() {
        return this.thisAsEntity.func_145782_y();
    }

    @Override
    public PhysicsWrapperEntity getWorldBelowFeet() {
        return this.worldBelowFeet;
    }

    @Override
    public void setWorldBelowFeet(PhysicsWrapperEntity toSet) {
        this.worldBelowFeet = toSet;
    }

    @Override
    public Vector getVelocityAddedToPlayer() {
        return this.velocityAddedToPlayer;
    }

    @Override
    public void setVelocityAddedToPlayer(Vector toSet) {
        this.velocityAddedToPlayer = toSet;
    }

    @Override
    public double getYawDifVelocity() {
        return this.yawDifVelocity;
    }

    @Override
    public void setYawDifVelocity(double toSet) {
        this.yawDifVelocity = toSet;
    }

    @Override
    public void setCancelNextMove(boolean toSet) {
        this.cancelNextMove = toSet;
    }

    @Override
    public void setForcedRelativeSubspace(PhysicsWrapperEntity toSet) {
        this.forcedRelativeWorldBelowFeet = toSet;
    }

    @Override
    public PhysicsWrapperEntity getForcedSubspaceBelowFeet() {
        return this.forcedRelativeWorldBelowFeet;
    }

    @Overwrite
    public Vec3d func_70676_i(float partialTicks) {
        Vec3d original;
        if (partialTicks == 1.0f) {
            original = this.func_174806_f(this.field_70125_A, this.field_70177_z);
        } else {
            float f = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * partialTicks;
            float f1 = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * partialTicks;
            original = this.func_174806_f(f, f1);
        }
        EntityShipMountData mountData = ValkyrienUtils.getMountedShipAndPos((Entity)Entity.class.cast(this));
        if (mountData.isMounted()) {
            return mountData.getMountedShip().getShipTransformationManager().getRenderTransform().rotate(original, TransformType.SUBSPACE_TO_GLOBAL);
        }
        return original;
    }

    @Overwrite
    protected final Vec3d func_174806_f(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        Vec3d vanilla = new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
        EntityShipMountData mountData = ValkyrienUtils.getMountedShipAndPos((Entity)Entity.class.cast(this));
        if (mountData.isMounted()) {
            return mountData.getMountedShip().getShipTransformationManager().getRenderTransform().rotate(vanilla, TransformType.SUBSPACE_TO_GLOBAL);
        }
        return vanilla;
    }

    @Shadow
    public abstract void func_70091_d(MoverType var1, double var2, double var4, double var6);

    @Shadow
    protected abstract void func_180432_n(Entity var1);

    @Overwrite
    public double func_70092_e(double x, double y, double z) {
        double d0 = this.field_70165_t - x;
        double d1 = this.field_70163_u - y;
        double d2 = this.field_70161_v - z;
        double vanilla = d0 * d0 + d1 * d1 + d2 * d2;
        if (vanilla < 64.0) {
            return vanilla;
        }
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(this.field_70170_p, new BlockPos(x, y, z));
        if (physicsObject.isPresent()) {
            Vector posVec = new Vector(x, y, z);
            physicsObject.get().getShipTransformationManager().fromLocalToGlobal(posVec);
            posVec.X -= this.field_70165_t;
            posVec.Y -= this.field_70163_u;
            posVec.Z -= this.field_70161_v;
            if (vanilla > posVec.lengthSq()) {
                return posVec.lengthSq();
            }
        }
        return vanilla;
    }

    @Overwrite
    public double func_174818_b(BlockPos pos) {
        double vanilla = pos.func_185332_f((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        if (vanilla < 64.0) {
            return vanilla;
        }
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(this.field_70170_p, pos);
        if (physicsObject.isPresent()) {
            Vector posVec = new Vector((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            physicsObject.get().getShipTransformationManager().fromLocalToGlobal(posVec);
            posVec.X -= this.field_70165_t;
            posVec.Y -= this.field_70163_u;
            posVec.Z -= this.field_70161_v;
            if (vanilla > posVec.lengthSq()) {
                return posVec.lengthSq();
            }
        }
        return vanilla;
    }

    @Redirect(method={"createRunningParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;floor(D)I", ordinal=0))
    public int runningParticlesFirstFloor(double d) {
        PhysicsWrapperEntity worldBelow = this.thisAsDraggable.getWorldBelowFeet();
        if (worldBelow == null) {
            this.searchVector = null;
            return MathHelper.func_76128_c((double)d);
        }
        this.searchVector = new Vector(this.field_70165_t, this.field_70163_u - (double)0.2f, this.field_70161_v);
        worldBelow.getPhysicsObject().getShipTransformationManager().getCurrentTickTransform().transform(this.searchVector, TransformType.GLOBAL_TO_SUBSPACE);
        return MathHelper.func_76128_c((double)this.searchVector.X);
    }

    @Redirect(method={"createRunningParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;floor(D)I", ordinal=1))
    public int runningParticlesSecondFloor(double d) {
        if (this.searchVector == null) {
            return MathHelper.func_76128_c((double)d);
        }
        return MathHelper.func_76128_c((double)this.searchVector.Y);
    }

    @Redirect(method={"createRunningParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;floor(D)I", ordinal=2))
    public int runningParticlesThirdFloor(double d) {
        if (this.searchVector == null) {
            return MathHelper.func_76128_c((double)d);
        }
        return MathHelper.func_76128_c((double)this.searchVector.Z);
    }

    @Shadow
    public float func_70047_e() {
        return 0.0f;
    }

    @Inject(method={"getPositionEyes(F)Lnet/minecraft/util/math/Vec3d;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getPositionEyesInject(float partialTicks, CallbackInfoReturnable<Vec3d> callbackInfo) {
        EntityShipMountData mountData = ValkyrienUtils.getMountedShipAndPos((Entity)Entity.class.cast(this));
        if (mountData.isMounted()) {
            Vector playerPosition = new Vector(mountData.getMountPos());
            mountData.getMountedShip().getShipTransformationManager().getRenderTransform().transform(playerPosition, TransformType.SUBSPACE_TO_GLOBAL);
            Vector playerEyes = new Vector(0.0, this.func_70047_e(), 0.0);
            mountData.getMountedShip().getShipTransformationManager().getCurrentTickTransform().rotate(playerEyes, TransformType.SUBSPACE_TO_GLOBAL);
            playerPosition.add(playerEyes);
            callbackInfo.setReturnValue(playerPosition.toVec3d());
            callbackInfo.cancel();
        }
    }
}

