/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.entity.player;

import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.addon.control.piloting.ControllerInputType;
import org.valkyrienskies.addon.control.piloting.IShipPilot;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physmanagement.shipdata.ShipData;
import org.valkyrienskies.mod.common.physmanagement.shipdata.ShipPositionData;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@Deprecated
@Mixin(value={EntityPlayer.class})
public abstract class MixinEntityPlayer
extends EntityLivingBase
implements IShipPilot {
    public PhysicsWrapperEntity pilotedShip;
    public BlockPos blockBeingControlled;
    public ControllerInputType controlInputType;

    public MixinEntityPlayer() {
        super(null);
    }

    @Inject(method={"getBedSpawnLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private static void preGetBedSpawnLocation(World worldIn, BlockPos bedLocation, boolean forceSpawn, CallbackInfoReturnable<BlockPos> callbackInfo) {
        int chunkX = bedLocation.func_177958_n() >> 4;
        int chunkZ = bedLocation.func_177952_p() >> 4;
        Optional<ShipData> shipData = ValkyrienUtils.getQueryableData(worldIn).getShipFromChunk(chunkX, chunkZ);
        if (shipData.isPresent()) {
            ShipPositionData positionData = shipData.get().getPositionData();
            if (positionData != null) {
                Vector bedPositionInWorld = new Vector((double)bedLocation.func_177958_n() + 0.5, (double)bedLocation.func_177956_o() + 0.5, (double)bedLocation.func_177952_p() + 0.5);
                positionData.getTransform().transform(bedPositionInWorld, TransformType.SUBSPACE_TO_GLOBAL);
                bedPositionInWorld.Y += 1.0;
                bedLocation = new BlockPos(bedPositionInWorld.X, bedPositionInWorld.Y, bedPositionInWorld.Z);
                callbackInfo.setReturnValue(bedLocation);
            } else {
                System.err.println("A ship just had chunks claimed persistent, but not any position data persistent");
            }
        }
    }

    @Override
    public PhysicsWrapperEntity getPilotedShip() {
        return this.pilotedShip;
    }

    @Override
    public void setPilotedShip(PhysicsWrapperEntity wrapper) {
        this.pilotedShip = wrapper;
    }

    @Override
    public boolean isPilotingShip() {
        return this.pilotedShip != null;
    }

    @Override
    public BlockPos getPosBeingControlled() {
        return this.blockBeingControlled;
    }

    @Override
    public void setPosBeingControlled(BlockPos pos) {
        this.blockBeingControlled = pos;
    }

    @Override
    public ControllerInputType getControllerInputEnum() {
        return this.controlInputType;
    }

    @Override
    public void setControllerInputEnum(ControllerInputType type) {
        this.controlInputType = type;
    }

    @Override
    public boolean isPilotingATile() {
        return this.blockBeingControlled != null;
    }

    @Override
    public boolean isPiloting() {
        return this.isPilotingShip() || this.isPilotingATile();
    }

    @Override
    public void stopPilotingEverything() {
        this.setPilotedShip(null);
        this.setPosBeingControlled(null);
        this.setControllerInputEnum(null);
    }
}

