/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.network.play.client;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.world.GameType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.fixes.ITransformablePacket;
import org.valkyrienskies.mod.common.coordinates.ISubspace;
import org.valkyrienskies.mod.common.coordinates.ISubspacedEntity;
import org.valkyrienskies.mod.common.coordinates.ISubspacedEntityRecord;
import org.valkyrienskies.mod.common.coordinates.VectorImmutable;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.VSMath;
import org.valkyrienskies.mod.common.physmanagement.interaction.IDraggable;

@Mixin(value={CPacketPlayer.class})
public class MixinCPacketPlayer
implements ITransformablePacket {
    private final CPacketPlayer thisPacket = (CPacketPlayer)CPacketPlayer.class.cast(this);
    private GameType cachedPlayerGameType = null;

    @Inject(method={"processPacket"}, at={@At(value="HEAD")})
    public void preDiggingProcessPacket(INetHandlerPlayServer server, CallbackInfo info) {
        this.doPreProcessing(server, false);
    }

    @Inject(method={"processPacket"}, at={@At(value="RETURN")})
    public void postDiggingProcessPacket(INetHandlerPlayServer server, CallbackInfo info) {
        this.doPostProcessing(server, false);
    }

    @Override
    public void doPreProcessing(INetHandlerPlayServer server, boolean callingFromSponge) {
        PhysicsWrapperEntity parent;
        if (this.isPacketOnMainThread(server, callingFromSponge) && (parent = this.getPacketParent((NetHandlerPlayServer)server)) != null) {
            ISubspace parentSubspace = parent.getPhysicsObject().getSubspace();
            ISubspacedEntityRecord entityRecord = parentSubspace.getRecordForSubspacedEntity((ISubspacedEntity)this.getPacketPlayer(server));
            VectorImmutable positionGlobal = entityRecord.getPositionInGlobalCoordinates();
            VectorImmutable lookVectorGlobal = entityRecord.getLookDirectionInGlobalCoordinates();
            float pitch = (float)VSMath.getPitchFromVectorImmutable(lookVectorGlobal);
            float yaw = (float)VSMath.getYawFromVectorImmutable(lookVectorGlobal, pitch);
            this.thisPacket.field_149480_h = true;
            this.thisPacket.field_149474_g = true;
            this.thisPacket.field_149479_a = positionGlobal.getX();
            this.thisPacket.field_149477_b = positionGlobal.getY();
            this.thisPacket.field_149478_c = positionGlobal.getZ();
            this.thisPacket.field_149481_i = true;
            this.thisPacket.field_149476_e = yaw;
            this.thisPacket.field_149473_f = pitch;
            this.cachedPlayerGameType = this.getPacketPlayer((INetHandlerPlayServer)server).field_71134_c.field_73091_c;
            this.getPacketPlayer((INetHandlerPlayServer)server).field_71134_c.field_73091_c = GameType.CREATIVE;
        }
    }

    @Override
    public void doPostProcessing(INetHandlerPlayServer server, boolean callingFromSponge) {
        if (this.isPacketOnMainThread(server, callingFromSponge)) {
            PhysicsWrapperEntity parent;
            if (this.cachedPlayerGameType != null) {
                this.getPacketPlayer((INetHandlerPlayServer)server).field_71134_c.field_73091_c = this.cachedPlayerGameType;
            }
            if ((parent = this.getPacketParent((NetHandlerPlayServer)server)) != null) {
                parent.getPhysicsObject().getSubspace().forceSubspaceRecord((ISubspacedEntity)this.getPacketPlayer(server), null);
            }
            IDraggable draggable = (IDraggable)this.getPacketPlayer(server);
            draggable.setForcedRelativeSubspace(null);
        }
    }

    @Override
    public PhysicsWrapperEntity getPacketParent(NetHandlerPlayServer server) {
        EntityPlayerMP player = server.field_147369_b;
        IDraggable draggable = (IDraggable)player;
        return draggable.getForcedSubspaceBelowFeet();
    }

    private EntityPlayerMP getPacketPlayer(INetHandlerPlayServer server) {
        return ((NetHandlerPlayServer)server).field_147369_b;
    }
}

