/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.world;

import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import valkyrienwarfare.api.TransformType;

@Mixin(value={World.class})
public class MixinClientWorld {
    private final World world = (World)World.class.cast(this);

    @Inject(method={"getCombinedLight(Lnet/minecraft/util/math/BlockPos;I)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetCombinedLight(BlockPos pos, int lightValue, CallbackInfoReturnable<Integer> callbackInfoReturnable) {
        try {
            int i = this.world.func_175705_a(EnumSkyBlock.SKY, pos);
            int j = this.world.func_175705_a(EnumSkyBlock.BLOCK, pos);
            AxisAlignedBB lightBB = new AxisAlignedBB((double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() - 2), (double)(pos.func_177952_p() - 2), (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 2));
            List<PhysicsWrapperEntity> physEnts = ValkyrienSkiesMod.VS_PHYSICS_MANAGER.getManagerForWorld(this.world).getNearbyPhysObjects(lightBB);
            for (PhysicsWrapperEntity physEnt : physEnts) {
                BlockPos posInLocal = physEnt.getPhysicsObject().getShipTransformationManager().getCurrentTickTransform().transform(pos, TransformType.GLOBAL_TO_SUBSPACE);
                int localI = this.world.func_175705_a(EnumSkyBlock.SKY, posInLocal);
                int localJ = this.world.func_175705_a(EnumSkyBlock.BLOCK, posInLocal);
                if (localI == 0 && localJ == 0) {
                    localI = this.world.func_175705_a(EnumSkyBlock.SKY, posInLocal.func_177984_a());
                    localJ = this.world.func_175705_a(EnumSkyBlock.BLOCK, posInLocal.func_177984_a());
                }
                if (localI == 0 && localJ == 0) {
                    localI = this.world.func_175705_a(EnumSkyBlock.SKY, posInLocal.func_177977_b());
                    localJ = this.world.func_175705_a(EnumSkyBlock.BLOCK, posInLocal.func_177977_b());
                }
                if (localI == 0 && localJ == 0) {
                    localI = this.world.func_175705_a(EnumSkyBlock.SKY, posInLocal.func_177978_c());
                    localJ = this.world.func_175705_a(EnumSkyBlock.BLOCK, posInLocal.func_177978_c());
                }
                if (localI == 0 && localJ == 0) {
                    localI = this.world.func_175705_a(EnumSkyBlock.SKY, posInLocal.func_177968_d());
                    localJ = this.world.func_175705_a(EnumSkyBlock.BLOCK, posInLocal.func_177968_d());
                }
                if (localI == 0 && localJ == 0) {
                    localI = this.world.func_175705_a(EnumSkyBlock.SKY, posInLocal.func_177974_f());
                    localJ = this.world.func_175705_a(EnumSkyBlock.BLOCK, posInLocal.func_177974_f());
                }
                if (localI == 0 && localJ == 0) {
                    localI = this.world.func_175705_a(EnumSkyBlock.SKY, posInLocal.func_177976_e());
                    localJ = this.world.func_175705_a(EnumSkyBlock.BLOCK, posInLocal.func_177976_e());
                }
                i = Math.min(localI, i);
                j = Math.max(localJ, j);
            }
            if (j < lightValue) {
                j = lightValue;
            }
            callbackInfoReturnable.setReturnValue(i << 20 | j << 4);
        }
        catch (Exception e) {
            System.err.println("Something just went wrong here, getting default light value instead!");
            e.printStackTrace();
        }
    }
}

