/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.world;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeWorld;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeWorldProvider;
import org.valkyrienskies.addon.control.block.torque.ImplRotationNodeWorld;
import org.valkyrienskies.fixes.MixinWorldIntrinsicMethods;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.coordinates.ISubspace;
import org.valkyrienskies.mod.common.coordinates.ISubspaceProvider;
import org.valkyrienskies.mod.common.coordinates.ImplSubspace;
import org.valkyrienskies.mod.common.coordinates.ShipTransform;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.collision.polygons.Polygon;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.physics.management.WorldPhysObjectManager;
import org.valkyrienskies.mod.common.physmanagement.interaction.IWorldVS;
import org.valkyrienskies.mod.common.ship_handling.IHasShipManager;
import org.valkyrienskies.mod.common.ship_handling.IWorldShipManager;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@Mixin(value={World.class}, priority=2018)
@Implements(value={@Interface(iface=MixinWorldIntrinsicMethods.class, prefix="vs$", remap=Interface.Remap.NONE)})
public abstract class MixinWorld
implements IWorldVS,
ISubspaceProvider,
IHasShipManager,
IRotationNodeWorldProvider {
    private static final double MAX_ENTITY_RADIUS_ALT = 2.0;
    private static final double BOUNDING_BOX_EDGE_LIMIT = 10000.0;
    private static final double BOUNDING_BOX_SIZE_LIMIT = 10000.0;
    private boolean dontIntercept = false;
    private PhysicsWrapperEntity dontInterceptShip = null;
    private final ISubspace worldSubspace = new ImplSubspace(null);
    private final World world = (World)World.class.cast(this);
    private IWorldShipManager manager = null;
    private ImplRotationNodeWorld rotationNodeWorld = new ImplRotationNodeWorld(null);
    @Shadow
    protected List<IWorldEventListener> field_73021_x;

    @Override
    public ISubspace getSubspace() {
        return this.worldSubspace;
    }

    @Shadow
    public abstract Biome getBiomeForCoordsBody(BlockPos var1);

    @Intrinsic(displace=true)
    public Biome vs$getBiomeForCoordsBody(BlockPos pos) {
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(this.world, pos);
        if (physicsObject.isPresent()) {
            pos = physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transform(pos, TransformType.SUBSPACE_TO_GLOBAL);
        }
        return this.getBiomeForCoordsBody(pos);
    }

    private static boolean isBoundingBoxTooLarge(AxisAlignedBB alignedBB) {
        if ((alignedBB.field_72336_d - alignedBB.field_72340_a) * (alignedBB.field_72337_e - alignedBB.field_72338_b) * (alignedBB.field_72334_f - alignedBB.field_72339_c) > 10000.0) {
            return true;
        }
        if (alignedBB.field_72336_d - alignedBB.field_72340_a > 10000.0 || alignedBB.field_72337_e - alignedBB.field_72338_b > 10000.0 || alignedBB.field_72334_f - alignedBB.field_72339_c > 10000.0) {
            return true;
        }
        return alignedBB.field_72336_d > 2.147483647E9 || alignedBB.field_72336_d < -2.147483648E9 || alignedBB.field_72340_a > 2.147483647E9 || alignedBB.field_72340_a < -2.147483648E9 || alignedBB.field_72337_e > 2.147483647E9 || alignedBB.field_72337_e < -2.147483648E9 || alignedBB.field_72338_b > 2.147483647E9 || alignedBB.field_72338_b < -2.147483648E9 || alignedBB.field_72334_f > 2.147483647E9 || alignedBB.field_72334_f < -2.147483648E9 || alignedBB.field_72339_c > 2.147483647E9 || alignedBB.field_72339_c < -2.147483648E9;
    }

    @Overwrite
    public void func_175720_a(int particleID, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        BlockPos pos = new BlockPos(x, y, z);
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(this.world, pos);
        if (physicsObject.isPresent()) {
            Vector newPosVec = new Vector(x, y, z);
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transform(newPosVec, TransformType.SUBSPACE_TO_GLOBAL);
            x = newPosVec.X;
            y = newPosVec.Y;
            z = newPosVec.Z;
        }
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_180442_a(particleID, ignoreRange, x, y, z, xSpeed, ySpeed, zSpeed, parameters);
        }
    }

    @Shadow
    public IBlockState func_180495_p(BlockPos pos) {
        return null;
    }

    @Shadow
    protected abstract boolean func_175680_a(int var1, int var2, boolean var3);

    @Shadow
    public abstract Chunk func_72964_e(int var1, int var2);

    @Inject(method={"getCollisionBoxes(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;ZLjava/util/List;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetCollisionBoxes(@Nullable Entity entityIn, AxisAlignedBB aabb, boolean p_191504_3_, @Nullable List<AxisAlignedBB> outList, CallbackInfoReturnable<Boolean> callbackInfo) {
        double deltaZ;
        double deltaY;
        double deltaX = Math.abs(aabb.field_72336_d - aabb.field_72340_a);
        if (Math.max(deltaX, Math.max(deltaY = Math.abs(aabb.field_72337_e - aabb.field_72338_b), deltaZ = Math.abs(aabb.field_72334_f - aabb.field_72339_c))) > 99999.0) {
            System.err.println(entityIn + "\ntried going extremely fast during the collision step");
            new Exception().printStackTrace();
            callbackInfo.setReturnValue(Boolean.FALSE);
            callbackInfo.cancel();
        }
    }

    private <T extends Entity> List<T> getEntitiesWithinAABBOriginal(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        int i = MathHelper.func_76128_c((double)((aabb.field_72340_a - 2.0) / 16.0));
        int j = MathHelper.func_76143_f((double)((aabb.field_72336_d + 2.0) / 16.0));
        int k = MathHelper.func_76128_c((double)((aabb.field_72339_c - 2.0) / 16.0));
        int l = MathHelper.func_76143_f((double)((aabb.field_72334_f + 2.0) / 16.0));
        ArrayList list = Lists.newArrayList();
        for (int i1 = i; i1 < j; ++i1) {
            for (int j1 = k; j1 < l; ++j1) {
                if (!this.func_175680_a(i1, j1, true)) continue;
                this.func_72964_e(i1, j1).func_177430_a(clazz, aabb, (List)list, filter);
            }
        }
        return list;
    }

    private List<Entity> getEntitiesInAABBexcludingOriginal(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        ArrayList list = Lists.newArrayList();
        int i = MathHelper.func_76128_c((double)((boundingBox.field_72340_a - 2.0) / 16.0));
        int j = MathHelper.func_76128_c((double)((boundingBox.field_72336_d + 2.0) / 16.0));
        int k = MathHelper.func_76128_c((double)((boundingBox.field_72339_c - 2.0) / 16.0));
        int l = MathHelper.func_76128_c((double)((boundingBox.field_72334_f + 2.0) / 16.0));
        if (MixinWorld.isBoundingBoxTooLarge(boundingBox)) {
            new Exception("Tried getting entities from giant bounding box of " + boundingBox).printStackTrace();
            return list;
        }
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                if (!this.func_175680_a(i1, j1, true)) continue;
                this.func_72964_e(i1, j1).func_177414_a(entityIn, boundingBox, (List)list, predicate);
            }
        }
        return list;
    }

    @Overwrite
    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        List<T> toReturn = this.getEntitiesWithinAABBOriginal(clazz, aabb, filter);
        BlockPos pos = new BlockPos((aabb.field_72340_a + aabb.field_72336_d) / 2.0, (aabb.field_72338_b + aabb.field_72337_e) / 2.0, (aabb.field_72339_c + aabb.field_72334_f) / 2.0);
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(this.world, pos);
        if (physicsObject.isPresent()) {
            Polygon poly = new Polygon(aabb, physicsObject.get().getShipTransformationManager().getCurrentTickTransform(), TransformType.SUBSPACE_TO_GLOBAL);
            aabb = poly.getEnclosedAABB();
            toReturn.addAll(this.getEntitiesWithinAABBOriginal(clazz, aabb, filter));
            toReturn.remove((Object)physicsObject.get().getWrapperEntity());
        }
        return toReturn;
    }

    @Overwrite
    public List<Entity> func_175674_a(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        if (MixinWorld.isBoundingBoxTooLarge(boundingBox)) {
            new Exception("Tried getting entities from giant bounding box of " + boundingBox).printStackTrace();
            return new ArrayList<Entity>();
        }
        List<Entity> toReturn = this.getEntitiesInAABBexcludingOriginal(entityIn, boundingBox, predicate);
        BlockPos pos = new BlockPos((boundingBox.field_72340_a + boundingBox.field_72336_d) / 2.0, (boundingBox.field_72338_b + boundingBox.field_72337_e) / 2.0, (boundingBox.field_72339_c + boundingBox.field_72334_f) / 2.0);
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(this.world, pos);
        if (physicsObject.isPresent()) {
            Polygon poly = new Polygon(boundingBox, physicsObject.get().getShipTransformationManager().getCurrentTickTransform(), TransformType.SUBSPACE_TO_GLOBAL);
            if (MixinWorld.isBoundingBoxTooLarge(boundingBox = poly.getEnclosedAABB().func_186664_h(0.3))) {
                new Exception("Tried getting entities from giant bounding box of " + boundingBox).printStackTrace();
                return new ArrayList<Entity>();
            }
            toReturn.addAll(this.getEntitiesInAABBexcludingOriginal(entityIn, boundingBox, predicate));
            toReturn.remove((Object)physicsObject.get().getWrapperEntity());
        }
        return toReturn;
    }

    @Shadow(remap=false)
    public abstract Iterator<Chunk> getPersistentChunkIterable(Iterator<Chunk> var1);

    @Intrinsic(displace=true)
    public Iterator<Chunk> vs$getPersistentChunkIterable(Iterator<Chunk> chunkIterator) {
        ArrayList<Chunk> persistentChunks = new ArrayList<Chunk>();
        while (chunkIterator.hasNext()) {
            Chunk chunk = chunkIterator.next();
            persistentChunks.add(chunk);
        }
        Iterator<Chunk> replacementIterator = persistentChunks.iterator();
        return this.getPersistentChunkIterable(replacementIterator);
    }

    @Override
    public void excludeShipFromRayTracer(PhysicsWrapperEntity entity) {
        if (this.dontInterceptShip != null) {
            throw new IllegalStateException("excluded ship is already set!");
        }
        this.dontInterceptShip = entity;
    }

    @Override
    public void unexcludeShipFromRayTracer(PhysicsWrapperEntity entity) {
        if (this.dontInterceptShip != entity) {
            throw new IllegalStateException("must exclude the same ship!");
        }
        this.dontInterceptShip = null;
    }

    @Inject(method={"rayTraceBlocks(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;ZZZ)Lnet/minecraft/util/math/RayTraceResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void preRayTraceBlocks(Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, CallbackInfoReturnable<RayTraceResult> callbackInfo) {
        if (!this.dontIntercept) {
            callbackInfo.setReturnValue(this.rayTraceBlocksIgnoreShip(vec31, vec32, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock, this.dontInterceptShip));
        }
    }

    @Override
    public RayTraceResult rayTraceBlocksIgnoreShip(Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, PhysicsWrapperEntity toIgnore) {
        this.dontIntercept = true;
        RayTraceResult vanillaTrace = this.world.func_147447_a(vec31, vec32, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
        WorldPhysObjectManager physManager = ValkyrienSkiesMod.VS_PHYSICS_MANAGER.getManagerForWorld(this.world);
        if (physManager == null) {
            return vanillaTrace;
        }
        Vec3d playerReachVector = vec32.func_178788_d(vec31);
        AxisAlignedBB playerRangeBB = new AxisAlignedBB(vec31.field_72450_a, vec31.field_72448_b, vec31.field_72449_c, vec32.field_72450_a, vec32.field_72448_b, vec32.field_72449_c);
        List<PhysicsWrapperEntity> nearbyShips = physManager.getNearbyPhysObjects(playerRangeBB);
        nearbyShips.remove((Object)toIgnore);
        double reachDistance = playerReachVector.func_72433_c();
        double worldResultDistFromPlayer = 4.2E8;
        if (vanillaTrace != null && vanillaTrace.field_72307_f != null) {
            worldResultDistFromPlayer = vanillaTrace.field_72307_f.func_72438_d(vec31);
        }
        for (PhysicsWrapperEntity wrapper : nearbyShips) {
            double shipResultDistFromPlayer;
            Vec3d playerEyesPos = vec31;
            playerReachVector = vec32.func_178788_d(vec31);
            ShipTransform shipTransform = wrapper.getPhysicsObject().getShipTransformationManager().getRenderTransform();
            playerEyesPos = shipTransform.transform(playerEyesPos, TransformType.GLOBAL_TO_SUBSPACE);
            playerReachVector = shipTransform.rotate(playerReachVector, TransformType.GLOBAL_TO_SUBSPACE);
            Vec3d playerEyesReachAdded = playerEyesPos.func_72441_c(playerReachVector.field_72450_a * reachDistance, playerReachVector.field_72448_b * reachDistance, playerReachVector.field_72449_c * reachDistance);
            RayTraceResult resultInShip = this.world.func_147447_a(playerEyesPos, playerEyesReachAdded, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
            if (resultInShip == null || resultInShip.field_72307_f == null || resultInShip.field_72313_a != RayTraceResult.Type.BLOCK || !((shipResultDistFromPlayer = resultInShip.field_72307_f.func_72438_d(playerEyesPos)) < worldResultDistFromPlayer)) continue;
            worldResultDistFromPlayer = shipResultDistFromPlayer;
            resultInShip.field_72307_f = shipTransform.transform(resultInShip.field_72307_f, TransformType.SUBSPACE_TO_GLOBAL);
            vanillaTrace = resultInShip;
        }
        this.dontIntercept = false;
        return vanillaTrace;
    }

    @Override
    public IWorldShipManager getManager() {
        if (this.manager == null) {
            throw new IllegalStateException("We can't be accessing this manager since WorldEvent.load() was never called!");
        }
        return this.manager;
    }

    @Override
    public void setManager(Function<World, IWorldShipManager> managerSupplier) {
        this.manager = managerSupplier.apply(this.world);
    }

    @Override
    public IRotationNodeWorld getPhysicsRotationNodeWorld() {
        return this.rotationNodeWorld;
    }

    @Redirect(method={"getBlockDensity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;rayTraceBlocks(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/util/math/RayTraceResult;"))
    private RayTraceResult rayTraceBlocksForGetBlockDensity(World world, Vec3d start, Vec3d end) {
        this.dontIntercept = true;
        RayTraceResult result = this.func_72933_a(start, end);
        this.dontIntercept = false;
        return result;
    }

    @Shadow
    public abstract RayTraceResult func_72933_a(Vec3d var1, Vec3d var2);
}

