/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mixin.world.chunk;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.fixes.IPhysicsChunk;
import org.valkyrienskies.mod.client.render.ITileEntitiesToRenderProvider;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.physmanagement.chunk.PhysicsChunkManager;

@Mixin(value={Chunk.class}, priority=1001)
public abstract class MixinChunk
implements ITileEntitiesToRenderProvider,
IPhysicsChunk {
    private Optional<PhysicsObject> parentOptional = Optional.empty();
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    @Shadow
    @Final
    public World field_76637_e;
    private List<TileEntity>[] tileEntitesByExtendedData = new List[16];

    @Shadow
    public abstract World func_177412_p();

    @Override
    public void setParentPhysicsObject(Optional<PhysicsObject> physicsObjectOptional) {
        this.parentOptional = physicsObjectOptional;
    }

    @Override
    public Optional<PhysicsObject> getPhysicsObjectOptional() {
        return this.parentOptional;
    }

    @Override
    public List<TileEntity> getTileEntitiesToRender(int chunkExtendedDataIndex) {
        return this.tileEntitesByExtendedData[chunkExtendedDataIndex];
    }

    @Inject(method={"addTileEntity(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V"}, at={@At(value="TAIL")})
    public void post_addTileEntity(BlockPos pos, TileEntity tileEntityIn, CallbackInfo callbackInfo) {
        int yIndex = pos.func_177956_o() >> 4;
        this.removeTileEntityFromIndex(pos, yIndex);
        this.tileEntitesByExtendedData[yIndex].add(tileEntityIn);
        if (this.getPhysicsObjectOptional().isPresent()) {
            this.getPhysicsObjectOptional().get().onSetTileEntity(pos, tileEntityIn);
        }
    }

    @Inject(method={"removeTileEntity(Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="TAIL")})
    public void post_removeTileEntity(BlockPos pos, CallbackInfo callbackInfo) {
        int yIndex = pos.func_177956_o() >> 4;
        this.removeTileEntityFromIndex(pos, yIndex);
        if (this.getPhysicsObjectOptional().isPresent()) {
            this.getPhysicsObjectOptional().get().onRemoveTileEntity(pos);
        }
    }

    private void removeTileEntityFromIndex(BlockPos pos, int yIndex) {
        if (this.tileEntitesByExtendedData[yIndex] == null) {
            this.tileEntitesByExtendedData[yIndex] = new ArrayList<TileEntity>();
        }
        Iterator<TileEntity> tileEntitiesIterator = this.tileEntitesByExtendedData[yIndex].iterator();
        while (tileEntitiesIterator.hasNext()) {
            TileEntity tile = tileEntitiesIterator.next();
            if (!tile.func_174877_v().equals((Object)pos) && !tile.func_145837_r()) continue;
            tileEntitiesIterator.remove();
        }
    }

    @Inject(method={"populate(Lnet/minecraft/world/chunk/IChunkProvider;Lnet/minecraft/world/gen/IChunkGenerator;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void prePopulateChunk(IChunkProvider provider, IChunkGenerator generator, CallbackInfo callbackInfo) {
        if (PhysicsChunkManager.isLikelyShipChunk(this.field_76635_g, this.field_76647_h)) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"addEntity(Lnet/minecraft/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void preAddEntity(Entity entityIn, CallbackInfo callbackInfo) {
        Chunk realChunkFor;
        World world = this.field_76637_e;
        int i = MathHelper.func_76128_c((double)(entityIn.field_70165_t / 16.0));
        int j = MathHelper.func_76128_c((double)(entityIn.field_70161_v / 16.0));
        if ((i != this.field_76635_g || j != this.field_76647_h) && !(realChunkFor = world.func_72964_e(i, j)).func_76621_g() && realChunkFor.field_76636_d) {
            realChunkFor.func_76612_a(entityIn);
            callbackInfo.cancel();
        }
    }

    @Shadow
    public abstract IBlockState func_177435_g(BlockPos var1);
}

