/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.client;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;
import org.valkyrienskies.fixes.SoundFixWrapper;
import org.valkyrienskies.mod.client.render.GibsModelRegistry;
import org.valkyrienskies.mod.client.render.infuser_core_rendering.InfuserCoreBakedModel;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.physics.management.WorldPhysObjectManager;
import org.valkyrienskies.mod.common.physmanagement.interaction.EntityDraggable;
import org.valkyrienskies.mod.common.ship_handling.IHasShipManager;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

public class EventsClient {
    private static double oldXOff;
    private static double oldYOff;
    private static double oldZOff;

    public static void updatePlayerMouseOver(Entity entity) {
        if (entity == Minecraft.func_71410_x().field_71439_g) {
            Minecraft.func_71410_x().field_71460_t.func_78473_a(Minecraft.func_71410_x().func_184121_ak());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        switch (event.phase) {
            case START: {
                for (PhysicsWrapperEntity wrapper : ValkyrienSkiesMod.VS_PHYSICS_MANAGER.getManagerForWorld((World)world).getTickablePhysicsEntities()) {
                    wrapper.getPhysicsObject().getShipTransformationManager().updateRenderTransform(1.0);
                }
                break;
            }
            case END: {
                IHasShipManager shipManager = (IHasShipManager)world;
                shipManager.getManager().tick();
            }
        }
    }

    @SubscribeEvent
    public void onPlaySoundEvent(PlaySoundEvent event) {
        ISound sound;
        BlockPos pos;
        Optional<PhysicsObject> physicsObject;
        if (Minecraft.func_71410_x().field_71441_e != null && (physicsObject = ValkyrienUtils.getPhysicsObject((World)Minecraft.func_71410_x().field_71441_e, pos = new BlockPos((double)(sound = event.getSound()).func_147649_g(), (double)sound.func_147654_h(), (double)sound.func_147651_i()))).isPresent()) {
            Vector newSoundLocation = new Vector(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transform(newSoundLocation, TransformType.SUBSPACE_TO_GLOBAL);
            SoundFixWrapper soundFix = new SoundFixWrapper(sound, newSoundLocation);
            event.setResultSound((ISound)soundFix);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onClientTickEvent(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && !mc.func_147113_T()) {
            WorldPhysObjectManager manager = ValkyrienSkiesMod.VS_PHYSICS_MANAGER.getManagerForWorld((World)mc.field_71441_e);
            if (event.phase == TickEvent.Phase.END) {
                for (PhysicsWrapperEntity wrapper : manager.physicsEntities) {
                    wrapper.getPhysicsObject().onPostTickClient();
                }
                EntityDraggable.tickAddedVelocityForWorld((World)mc.field_71441_e);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onDrawBlockHighlightEventFirst(DrawBlockHighlightEvent event) {
        RayTraceResult objectOver;
        GL11.glPushMatrix();
        BlockPos pos = Minecraft.func_71410_x().field_71476_x.func_178782_a();
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject((World)Minecraft.func_71410_x().field_71441_e, pos);
        if (physicsObject.isPresent() && (objectOver = Minecraft.func_71410_x().field_71476_x) != null && objectOver.field_72307_f != null) {
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            oldXOff = buffer.field_179004_l;
            oldYOff = buffer.field_179005_m;
            oldZOff = buffer.field_179002_n;
            buffer.func_178969_c((double)(-physicsObject.get().getShipRenderer().offsetPos.func_177958_n()), (double)(-physicsObject.get().getShipRenderer().offsetPos.func_177956_o()), (double)(-physicsObject.get().getShipRenderer().offsetPos.func_177952_p()));
            physicsObject.get().getShipRenderer().applyRenderTransform(event.getPartialTicks());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onDrawBlockHighlightEventLast(DrawBlockHighlightEvent event) {
        RayTraceResult objectOver;
        BlockPos pos = Minecraft.func_71410_x().field_71476_x.func_178782_a();
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject((World)Minecraft.func_71410_x().field_71441_e, pos);
        if (physicsObject.isPresent() && (objectOver = Minecraft.func_71410_x().field_71476_x) != null && objectOver.field_72307_f != null) {
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.field_179004_l = oldXOff;
            buffer.field_179005_m = oldYOff;
            buffer.field_179002_n = oldZOff;
        }
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        GibsModelRegistry.registerTextures((TextureStitchEvent)event);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        GibsModelRegistry.onModelBakeEvent(event);
        ResourceLocation modelResourceLocation = new ResourceLocation("valkyrienskies", "item/infuser_core_main");
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)modelResourceLocation);
            IBakedModel inventoryModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
            IBakedModel handModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)new ModelResourceLocation("valkyrienskies:" + ValkyrienSkiesMod.INSTANCE.physicsCore.func_77658_a().substring(5), "inventory"));
            event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("valkyrienskies:testmodel", "inventory"), (Object)new InfuserCoreBakedModel(handModel, inventoryModel));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        ResourceLocation mainCoreInventoryTexture = new ResourceLocation("valkyrienskies", "items/main_core");
        ResourceLocation smallCoreInventoryTexture = new ResourceLocation("valkyrienskies", "items/small_core");
        event.getMap().func_174942_a(mainCoreInventoryTexture);
        event.getMap().func_174942_a(smallCoreInventoryTexture);
    }

    @SubscribeEvent
    public void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        double partialTicks = event.renderTickTime;
        if (Minecraft.func_71410_x().func_147113_T()) {
            partialTicks = Minecraft.func_71410_x().field_193996_ah;
        }
        if (event.phase == TickEvent.Phase.START) {
            for (PhysicsWrapperEntity wrapper : ValkyrienSkiesMod.VS_PHYSICS_MANAGER.getManagerForWorld((World)world).getTickablePhysicsEntities()) {
                wrapper.getPhysicsObject().getShipTransformationManager().updateRenderTransform(partialTicks);
            }
        }
    }
}

