/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.client.render;

import com.best108.atom_animation_reader.IAtomAnimation;
import com.best108.atom_animation_reader.impl.BasicAtomAnimationBuilder;
import com.best108.atom_animation_reader.parsers.AtomParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.valkyrienskies.mod.client.render.GibsModelRegistry;

public class GibsAnimationRegistry {
    private static final Map<String, IAtomAnimation> ANIMATION_MAP = new HashMap<String, IAtomAnimation>();

    public static void registerAnimation(String name, ResourceLocation location) {
        try {
            IResource animationResource = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
            Scanner data = new Scanner(animationResource.func_110527_b());
            AtomParser dataParser = new AtomParser(data);
            BasicAtomAnimationBuilder animationBuilder = new BasicAtomAnimationBuilder(dataParser);
            Set<String> modelsUsed = animationBuilder.getModelObjsUsed();
            String resourceDomainName = location.func_110624_b();
            StringBuilder modelResourceFolder = new StringBuilder();
            String[] temp = location.func_110623_a().split("/");
            for (int i = 1; i < temp.length - 1; ++i) {
                modelResourceFolder.append(temp[i]).append("/");
            }
            for (String modelName2 : modelsUsed) {
                String modelFullPath = modelResourceFolder + modelName2;
                ResourceLocation modelToRegister = new ResourceLocation(resourceDomainName, modelResourceFolder + modelName2 + ".obj");
                GibsModelRegistry.registerGibsModel(modelFullPath, modelToRegister);
            }
            String modelResourceFolderFinal = modelResourceFolder.toString();
            ANIMATION_MAP.put(name, animationBuilder.build((modelName, renderBrightness) -> GibsModelRegistry.renderGibsModel(modelResourceFolderFinal + modelName, renderBrightness)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static IAtomAnimation getAnimation(String name) {
        return ANIMATION_MAP.get(name);
    }

    public static void onResourceReload() {
    }
}

