/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;
import org.valkyrienskies.mod.client.render.PhysRenderChunk;
import org.valkyrienskies.mod.common.coordinates.ShipTransform;
import org.valkyrienskies.mod.common.math.Quaternion;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.proxy.ClientProxy;
import valkyrienwarfare.api.TransformType;

public class PhysObjectRenderManager {
    public BlockPos offsetPos;
    private int glCallListSolid;
    private int glCallListTranslucent;
    private int glCallListCutout;
    private int glCallListCutoutMipped;
    private PhysicsObject parent;
    private PhysRenderChunk[][] renderChunks;

    public PhysObjectRenderManager(PhysicsObject toRender) {
        this.parent = toRender;
        this.glCallListSolid = -1;
        this.glCallListTranslucent = -1;
        this.glCallListCutout = -1;
        this.glCallListCutoutMipped = -1;
        this.offsetPos = null;
        this.renderChunks = null;
    }

    public void updateOffsetPos(BlockPos newPos) {
        this.offsetPos = newPos;
    }

    public void renderBlockLayer(BlockRenderLayer layerToRender, double partialTicks, int pass) {
        if (this.renderChunks == null) {
            this.renderChunks = new PhysRenderChunk[this.parent.getOwnedChunks().chunkLengthX()][this.parent.getOwnedChunks().chunkLengthZ()];
            for (int xChunk = 0; xChunk < this.parent.getOwnedChunks().chunkLengthX(); ++xChunk) {
                for (int zChunk = 0; zChunk < this.parent.getOwnedChunks().chunkLengthZ(); ++zChunk) {
                    this.renderChunks[xChunk][zChunk] = new PhysRenderChunk(this.parent, this.parent.getChunkAt(xChunk + this.parent.getOwnedChunks().minX(), zChunk + this.parent.getOwnedChunks().minZ()));
                }
            }
        }
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        this.applyRenderTransform(partialTicks);
        PhysRenderChunk[][] physRenderChunkArray = this.renderChunks;
        int n = physRenderChunkArray.length;
        for (int i = 0; i < n; ++i) {
            PhysRenderChunk[] chunkArray;
            for (PhysRenderChunk renderChunk : chunkArray = physRenderChunkArray[i]) {
                renderChunk.renderBlockLayer(layerToRender, partialTicks, pass);
            }
        }
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GL11.glPopMatrix();
    }

    public void killRenderers() {
        if (this.renderChunks != null) {
            PhysRenderChunk[][] physRenderChunkArray = this.renderChunks;
            int n = physRenderChunkArray.length;
            for (int i = 0; i < n; ++i) {
                PhysRenderChunk[] chunks;
                for (PhysRenderChunk chunk : chunks = physRenderChunkArray[i]) {
                    chunk.killRenderChunk();
                }
            }
        }
    }

    public void updateRange(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean updateImmediately) {
        if (this.renderChunks == null || this.parent == null || this.parent.getOwnedChunks() == null) {
            return;
        }
        int size = (maxX + 1 - minX) * (maxZ + 1 - minZ) * (maxY + 1 - minY);
        if (size > 65535) {
            return;
        }
        int minChunkX = minX >> 4;
        int maxChunkX = maxX >> 4;
        int minChunkZ = minZ >> 4;
        int maxChunkZ = maxZ >> 4;
        int minBlockArrayY = Math.max(0, minY >> 4);
        int maxBlockArrayY = Math.min(15, maxY >> 4);
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                try {
                    if (chunkX < this.parent.getOwnedChunks().minX() || chunkZ < this.parent.getOwnedChunks().minZ() || chunkX - this.parent.getOwnedChunks().minX() >= this.renderChunks.length || chunkZ - this.parent.getOwnedChunks().minZ() >= this.renderChunks[0].length) continue;
                    PhysRenderChunk renderChunk = this.renderChunks[chunkX - this.parent.getOwnedChunks().minX()][chunkZ - this.parent.getOwnedChunks().minZ()];
                    if (renderChunk != null) {
                        renderChunk.updateLayers(minBlockArrayY, maxBlockArrayY);
                        continue;
                    }
                    System.err.println("SHIP RENDER CHUNK CAME OUT NULL! THIS IS VERY WRONG!!");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean shouldRender() {
        if (this.parent.getWrapperEntity().field_70128_L) {
            return false;
        }
        ICamera camera = ClientProxy.lastCamera;
        return true;
    }

    public void applyRenderTransform(double partialTicks) {
        Vector centerOfRotation = this.parent.getCenterCoord();
        double p0 = Minecraft.func_71410_x().field_71439_g.field_70142_S + (Minecraft.func_71410_x().field_71439_g.field_70165_t - Minecraft.func_71410_x().field_71439_g.field_70142_S) * partialTicks;
        double p1 = Minecraft.func_71410_x().field_71439_g.field_70137_T + (Minecraft.func_71410_x().field_71439_g.field_70163_u - Minecraft.func_71410_x().field_71439_g.field_70137_T) * partialTicks;
        double p2 = Minecraft.func_71410_x().field_71439_g.field_70136_U + (Minecraft.func_71410_x().field_71439_g.field_70161_v - Minecraft.func_71410_x().field_71439_g.field_70136_U) * partialTicks;
        ShipTransform renderTransform = this.parent.getShipTransformationManager().getRenderTransform();
        Vector renderPos = new Vector(centerOfRotation);
        renderTransform.transform(renderPos, TransformType.SUBSPACE_TO_GLOBAL);
        double moddedX = renderPos.X;
        double moddedY = renderPos.Y;
        double moddedZ = renderPos.Z;
        double[] radians = renderTransform.createRotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL).toRadians();
        double moddedPitch = Math.toDegrees(radians[0]);
        double moddedYaw = Math.toDegrees(radians[1]);
        double moddedRoll = Math.toDegrees(radians[2]);
        if (this.offsetPos != null) {
            double offsetX = (double)this.offsetPos.func_177958_n() - centerOfRotation.X;
            double offsetY = (double)this.offsetPos.func_177956_o() - centerOfRotation.Y;
            double offsetZ = (double)this.offsetPos.func_177952_p() - centerOfRotation.Z;
            GlStateManager.func_179137_b((double)(-p0 + moddedX), (double)(-p1 + moddedY), (double)(-p2 + moddedZ));
            GL11.glRotated((double)moddedPitch, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)moddedYaw, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)moddedRoll, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)offsetX, (double)offsetY, (double)offsetZ);
        }
    }

    @Deprecated
    public Quaternion getSmoothRotationQuat(double partialTick) {
        Quaternion oneTickBefore = this.parent.getShipTransformationManager().getPrevTickTransform().createRotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
        Quaternion nextQuat = this.parent.getShipTransformationManager().getCurrentTickTransform().createRotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
        return Quaternion.slerpInterpolate(oneTickBefore, nextQuat, partialTick);
    }

    public void inverseTransform(double partialTicks) {
        Vector centerOfRotation = this.parent.getCenterCoord();
        double p0 = Minecraft.func_71410_x().field_71439_g.field_70142_S + (Minecraft.func_71410_x().field_71439_g.field_70165_t - Minecraft.func_71410_x().field_71439_g.field_70142_S) * partialTicks;
        double p1 = Minecraft.func_71410_x().field_71439_g.field_70137_T + (Minecraft.func_71410_x().field_71439_g.field_70163_u - Minecraft.func_71410_x().field_71439_g.field_70137_T) * partialTicks;
        double p2 = Minecraft.func_71410_x().field_71439_g.field_70136_U + (Minecraft.func_71410_x().field_71439_g.field_70161_v - Minecraft.func_71410_x().field_71439_g.field_70136_U) * partialTicks;
        ShipTransform renderTransform = this.parent.getShipTransformationManager().getRenderTransform();
        Vector renderPos = new Vector(centerOfRotation);
        renderTransform.transform(renderPos, TransformType.SUBSPACE_TO_GLOBAL);
        double moddedX = renderPos.X;
        double moddedY = renderPos.Y;
        double moddedZ = renderPos.Z;
        double[] radians = renderTransform.createRotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL).toRadians();
        double moddedPitch = Math.toDegrees(radians[0]);
        double moddedYaw = Math.toDegrees(radians[1]);
        double moddedRoll = Math.toDegrees(radians[2]);
        if (this.offsetPos != null) {
            double offsetX = (double)this.offsetPos.func_177958_n() - centerOfRotation.X;
            double offsetY = (double)this.offsetPos.func_177956_o() - centerOfRotation.Y;
            double offsetZ = (double)this.offsetPos.func_177952_p() - centerOfRotation.Z;
            GL11.glTranslated((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
            GL11.glRotated((double)(-moddedRoll), (double)0.0, (double)0.0, (double)1.0);
            GL11.glRotated((double)(-moddedYaw), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(-moddedPitch), (double)1.0, (double)0.0, (double)0.0);
            GlStateManager.func_179137_b((double)(p0 - moddedX), (double)(p1 - moddedY), (double)(p2 - moddedZ));
        }
    }
}

