/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.client.render;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;
import org.valkyrienskies.mod.client.render.ITileEntitiesToRenderProvider;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;

public class PhysRenderChunk {
    public RenderLayer[] layers = new RenderLayer[16];
    public PhysicsObject toRender;
    public Chunk renderChunk;

    public PhysRenderChunk(PhysicsObject toRender, Chunk renderChunk) {
        this.toRender = toRender;
        this.renderChunk = renderChunk;
        for (int i = 0; i < 16; ++i) {
            RenderLayer renderLayer;
            ExtendedBlockStorage storage = renderChunk.field_76652_q[i];
            if (storage == null) continue;
            this.layers[i] = renderLayer = new RenderLayer(renderChunk, i * 16, i * 16 + 15, this);
        }
    }

    public void renderBlockLayer(BlockRenderLayer layerToRender, double partialTicks, int pass) {
        for (int i = 0; i < 16; ++i) {
            RenderLayer layer = this.layers[i];
            if (layer == null) continue;
            layer.renderBlockLayer(layerToRender, partialTicks, pass);
        }
    }

    public void updateLayers(int minLayer, int maxLayer) {
        for (int layerY = minLayer; layerY <= maxLayer; ++layerY) {
            RenderLayer renderLayer;
            RenderLayer layer = this.layers[layerY];
            if (layer != null) {
                layer.markDirtyRenderLists();
                continue;
            }
            this.layers[layerY] = renderLayer = new RenderLayer(this.renderChunk, layerY * 16, layerY * 16 + 15, this);
        }
    }

    void killRenderChunk() {
        for (int i = 0; i < 16; ++i) {
            RenderLayer layer = this.layers[i];
            if (layer == null) continue;
            layer.deleteRenderLayer();
        }
    }

    public static class RenderLayer {
        Chunk chunkToRender;
        int yMin;
        int yMax;
        int glCallListCutout;
        int glCallListCutoutMipped;
        int glCallListSolid;
        int glCallListTranslucent;
        PhysRenderChunk parent;
        boolean needsCutoutUpdate;
        boolean needsCutoutMippedUpdate;
        boolean needsSolidUpdate;
        boolean needsTranslucentUpdate;
        List<TileEntity> renderTiles = new ArrayList<TileEntity>();

        RenderLayer(Chunk chunk, int yMin, int yMax, PhysRenderChunk parent) {
            this.chunkToRender = chunk;
            this.yMin = yMin;
            this.yMax = yMax;
            this.parent = parent;
            this.markDirtyRenderLists();
            this.glCallListCutout = GLAllocation.func_74526_a((int)4);
            this.glCallListCutoutMipped = this.glCallListCutout + 1;
            this.glCallListSolid = this.glCallListCutout + 2;
            this.glCallListTranslucent = this.glCallListCutout + 3;
        }

        public void markDirtyRenderLists() {
            this.needsCutoutUpdate = true;
            this.needsCutoutMippedUpdate = true;
            this.needsSolidUpdate = true;
            this.needsTranslucentUpdate = true;
            this.updateRenderTileEntities();
        }

        public void updateRenderTileEntities() {
            ITileEntitiesToRenderProvider provider = (ITileEntitiesToRenderProvider)this.chunkToRender;
            List<TileEntity> updatedRenderTiles = provider.getTileEntitiesToRender(this.yMin >> 4);
            if (updatedRenderTiles != null) {
                Minecraft.func_71410_x().field_71438_f.func_181023_a(this.renderTiles, updatedRenderTiles);
                this.renderTiles = new ArrayList<TileEntity>(updatedRenderTiles);
            }
        }

        public void deleteRenderLayer() {
            this.clearRenderLists();
            Minecraft.func_71410_x().field_71438_f.func_181023_a(this.renderTiles, new ArrayList());
            this.renderTiles.clear();
        }

        private void clearRenderLists() {
            GLAllocation.func_74523_b((int)this.glCallListCutout);
            GLAllocation.func_74523_b((int)this.glCallListCutoutMipped);
            GLAllocation.func_74523_b((int)this.glCallListSolid);
            GLAllocation.func_74523_b((int)this.glCallListTranslucent);
        }

        public void renderBlockLayer(BlockRenderLayer layerToRender, double partialTicks, int pass) {
            switch (layerToRender) {
                case CUTOUT: {
                    if (this.needsCutoutUpdate) {
                        this.updateList(layerToRender);
                    }
                    GL11.glCallList((int)this.glCallListCutout);
                    break;
                }
                case CUTOUT_MIPPED: {
                    if (this.needsCutoutMippedUpdate) {
                        this.updateList(layerToRender);
                    }
                    GL11.glCallList((int)this.glCallListCutoutMipped);
                    break;
                }
                case SOLID: {
                    if (this.needsSolidUpdate) {
                        this.updateList(layerToRender);
                    }
                    GL11.glCallList((int)this.glCallListSolid);
                    break;
                }
                case TRANSLUCENT: {
                    if (this.needsTranslucentUpdate) {
                        this.updateList(layerToRender);
                    }
                    GL11.glCallList((int)this.glCallListTranslucent);
                    break;
                }
            }
        }

        private void updateList(BlockRenderLayer layerToUpdate) {
            if (this.parent.toRender.getShipRenderer() == null) {
                return;
            }
            BlockPos offsetPos = this.parent.toRender.getShipRenderer().offsetPos;
            if (offsetPos == null) {
                return;
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            worldrenderer.func_178969_c((double)(-offsetPos.func_177958_n()), (double)(-offsetPos.func_177956_o()), (double)(-offsetPos.func_177952_p()));
            GL11.glPushMatrix();
            switch (layerToUpdate) {
                case CUTOUT: {
                    GLAllocation.func_74523_b((int)this.glCallListCutout);
                    GL11.glNewList((int)this.glCallListCutout, (int)4864);
                    break;
                }
                case CUTOUT_MIPPED: {
                    GLAllocation.func_74523_b((int)this.glCallListCutoutMipped);
                    GL11.glNewList((int)this.glCallListCutoutMipped, (int)4864);
                    break;
                }
                case SOLID: {
                    GLAllocation.func_74523_b((int)this.glCallListSolid);
                    GL11.glNewList((int)this.glCallListSolid, (int)4864);
                    break;
                }
                case TRANSLUCENT: {
                    GLAllocation.func_74523_b((int)this.glCallListTranslucent);
                    GL11.glNewList((int)this.glCallListTranslucent, (int)4864);
                    break;
                }
            }
            GlStateManager.func_179094_E();
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layerToUpdate);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = this.chunkToRender.field_76635_g * 16; x < this.chunkToRender.field_76635_g * 16 + 16; ++x) {
                for (int z = this.chunkToRender.field_76647_h * 16; z < this.chunkToRender.field_76647_h * 16 + 16; ++z) {
                    for (int y = this.yMin; y <= this.yMax; ++y) {
                        pos.func_181079_c(x, y, z);
                        IBlockState iblockstate = this.chunkToRender.func_177435_g((BlockPos)pos);
                        try {
                            if (!iblockstate.func_177230_c().canRenderInLayer(iblockstate, layerToUpdate)) continue;
                            Minecraft.func_71410_x().func_175602_ab().func_175018_a(iblockstate, (BlockPos)pos, (IBlockAccess)this.chunkToRender.field_76637_e, worldrenderer);
                            continue;
                        }
                        catch (NullPointerException e) {
                            System.out.println("Something was null! LValkyrienSkiesBase/render/PhysRenderChunk#updateList");
                        }
                    }
                }
            }
            tessellator.func_78381_a();
            ForgeHooksClient.setRenderLayer(null);
            GlStateManager.func_179121_F();
            GL11.glEndList();
            GL11.glPopMatrix();
            worldrenderer.func_178969_c(0.0, 0.0, 0.0);
            switch (layerToUpdate) {
                case CUTOUT: {
                    this.needsCutoutUpdate = false;
                    break;
                }
                case CUTOUT_MIPPED: {
                    this.needsCutoutMippedUpdate = false;
                    break;
                }
                case SOLID: {
                    this.needsSolidUpdate = false;
                    break;
                }
                case TRANSLUCENT: {
                    this.needsTranslucentUpdate = false;
                    break;
                }
            }
        }
    }
}

