/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.fixes.IPhysicsChunk;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.coordinates.CoordinateSpaceType;
import org.valkyrienskies.mod.common.entity.EntityMountable;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.physics.management.PhysicsTickHandler;
import org.valkyrienskies.mod.common.physmanagement.interaction.VSWorldEventListener;
import org.valkyrienskies.mod.common.physmanagement.shipdata.IValkyrienSkiesWorldData;
import org.valkyrienskies.mod.common.ship_handling.IHasShipManager;
import org.valkyrienskies.mod.common.ship_handling.WorldClientShipManager;
import org.valkyrienskies.mod.common.ship_handling.WorldServerShipManager;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

public class EventsCommon {
    @Deprecated
    private static final Map<EntityPlayer, double[]> lastPositions = new HashMap<EntityPlayer, double[]>();
    private static final Logger logger = LogManager.getLogger(EventsCommon.class);

    @SubscribeEvent
    public void onPlayerSleepInBedEvent(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(player.func_130014_f_(), pos);
        if (physicsObject.isPresent() && player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            player.func_145747_a((ITextComponent)new TextComponentString("Spawn Point Set!"));
            player.func_180473_a(pos, true);
            event.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_HERE);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack;
        if (!event.getWorld().field_72995_K && (stack = event.getItemStack()).func_77973_b() instanceof ItemNameTag) {
            BlockPos posAt = event.getPos();
            EntityPlayer player = event.getEntityPlayer();
            World world = event.getWorld();
            Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(world, posAt);
            if (physicsObject.isPresent()) {
                physicsObject.get().getWrapperEntity().func_96094_a(stack.func_82833_r());
                --stack.field_77994_a;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        World world = entity.field_70170_p;
        BlockPos posAt = new BlockPos(entity);
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(world, posAt);
        if (!event.getWorld().field_72995_K && physicsObject.isPresent() && !(entity instanceof EntityFallingBlock)) {
            if (entity instanceof EntityArmorStand || entity instanceof EntityPig || entity instanceof EntityBoat) {
                EntityMountable entityMountable = new EntityMountable(world, entity.func_174791_d(), CoordinateSpaceType.SUBSPACE_COORDINATES, posAt);
                world.func_72838_d((Entity)entityMountable);
                entity.func_184220_m((Entity)entityMountable);
            }
            physicsObject.get().getShipTransformationManager().getCurrentTickTransform().transform(entity, TransformType.SUBSPACE_TO_GLOBAL);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldTickEvent(TickEvent.WorldTickEvent event) {
        if (event.side == Side.CLIENT) {
            throw new IllegalStateException("This event should never get called client side");
        }
        World world = event.world;
        switch (event.phase) {
            case START: {
                PhysicsTickHandler.onWorldTickStart(world);
                break;
            }
            case END: {
                IHasShipManager shipManager = (IHasShipManager)world;
                shipManager.getManager().tick();
                PhysicsTickHandler.onWorldTickEnd(world);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            EntityPlayerMP p = (EntityPlayerMP)event.player;
            double[] pos = lastPositions.computeIfAbsent((EntityPlayer)p, k -> new double[3]);
            try {
                if ((pos[0] != p.field_70165_t || pos[2] != p.field_70161_v) && (Math.abs(p.field_70165_t) > 2.7E7 || Math.abs(p.field_70161_v) > 2.7E7)) {
                    p.func_184595_k(pos[0], pos[1], pos[2]);
                    p.func_145747_a((ITextComponent)new TextComponentString("You can't go beyond 27000000 blocks because airships are stored there!"));
                }
            }
            catch (NullPointerException e) {
                logger.warn("Nullpointer EventsCommon.java:onPlayerTickEvent");
            }
            pos[0] = p.field_70165_t;
            pos[1] = p.field_70163_u;
            pos[2] = p.field_70161_v;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        event.getWorld().func_72954_a((IWorldEventListener)new VSWorldEventListener(world));
        IHasShipManager shipManager = (IHasShipManager)world;
        if (!event.getWorld().field_72995_K) {
            ValkyrienSkiesMod.VS_CHUNK_MANAGER.initWorld(world);
            shipManager.setManager(WorldServerShipManager::new);
        } else {
            shipManager.setManager(WorldClientShipManager::new);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            ValkyrienSkiesMod.VS_CHUNK_MANAGER.removeWorld(event.getWorld());
        } else {
            lastPositions.clear();
        }
        ValkyrienSkiesMod.VS_PHYSICS_MANAGER.removeWorld(event.getWorld());
        IHasShipManager shipManager = (IHasShipManager)event.getWorld();
        shipManager.getManager().onWorldUnload();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityUntrack(PlayerEvent.StopTracking event) {
        Entity ent;
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && (ent = event.getTarget()) instanceof PhysicsWrapperEntity) {
            ((PhysicsWrapperEntity)ent).getPhysicsObject().onPlayerUntracking(event.getEntityPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        BlockPos pos = event.getPos();
        Optional<PhysicsObject> physicsObject = ValkyrienUtils.getPhysicsObject(event.getWorld(), pos);
        if (physicsObject.isPresent()) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void attachWorldCapabilities(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("valkyrienskies", "world_data_capability"), (ICapabilityProvider)new ICapabilitySerializable<NBTBase>(){
            IValkyrienSkiesWorldData inst = (IValkyrienSkiesWorldData)ValkyrienSkiesMod.VS_WORLD_DATA.getDefaultInstance();

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return capability == ValkyrienSkiesMod.VS_WORLD_DATA;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)(capability == ValkyrienSkiesMod.VS_WORLD_DATA ? ValkyrienSkiesMod.VS_WORLD_DATA.cast((Object)this.inst) : null);
            }

            public NBTBase serializeNBT() {
                return ValkyrienSkiesMod.VS_WORLD_DATA.getStorage().writeNBT(ValkyrienSkiesMod.VS_WORLD_DATA, (Object)this.inst, null);
            }

            public void deserializeNBT(NBTBase nbt) {
                ValkyrienSkiesMod.VS_WORLD_DATA.getStorage().readNBT(ValkyrienSkiesMod.VS_WORLD_DATA, (Object)this.inst, null, nbt);
            }
        });
    }

    @SubscribeEvent
    public void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            lastPositions.put((EntityPlayer)player, new double[]{0.0, 256.0, 0.0});
            if (player.func_70005_c_().equals("Drake_Eldridge") || player.func_70005_c_().equals("thebest108") || player.func_70005_c_().equals("DaPorkChop_")) {
                WorldServer server = (WorldServer)event.player.field_70170_p;
                if (Math.random() < 0.2) {
                    server.field_73061_a.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + "An absolute " + TextFormatting.RED + TextFormatting.ITALIC + "legend" + TextFormatting.BLUE + " has arrived! Welcome " + TextFormatting.GOLD + TextFormatting.BOLD + player.func_70005_c_()));
                }
            }
        }
    }

    @SubscribeEvent
    public void onLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            lastPositions.remove(event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockBreakFirst(BlockEvent event) {
        BlockPos pos = event.getPos();
        Chunk chunk = event.getWorld().func_175726_f(pos);
        IPhysicsChunk physicsChunk = (IPhysicsChunk)chunk;
        if (physicsChunk.getPhysicsObjectOptional().isPresent()) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onExplosionStart(ExplosionEvent.Start event) {
        if (!event.getWorld().field_72995_K) {
            Explosion explosion = event.getExplosion();
            Vector center = new Vector(explosion.field_77284_b, explosion.field_77285_c, explosion.field_77282_d);
            Optional<PhysicsObject> optionalPhysicsObject = ValkyrienUtils.getPhysicsObject(event.getWorld(), new BlockPos(event.getExplosion().getPosition()), true);
            if (optionalPhysicsObject.isPresent()) {
                return;
            }
            float radius = explosion.field_77280_f;
            AxisAlignedBB toCheck = new AxisAlignedBB(center.X - (double)radius, center.Y - (double)radius, center.Z - (double)radius, center.X + (double)radius, center.Y + (double)radius, center.Z + (double)radius);
            List<PhysicsWrapperEntity> shipsNear = ValkyrienSkiesMod.VS_PHYSICS_MANAGER.getManagerForWorld(event.getWorld()).getNearbyPhysObjects(toCheck);
            for (PhysicsWrapperEntity ship : shipsNear) {
                Vector inLocal = new Vector(center);
                ship.getPhysicsObject().getShipTransformationManager().getCurrentTickTransform().transform(inLocal, TransformType.GLOBAL_TO_SUBSPACE);
                Explosion expl = new Explosion(event.getWorld(), null, inLocal.X, inLocal.Y, inLocal.Z, radius, explosion.field_77286_a, true);
                double waterRange = 0.6;
                int x = (int)Math.floor(expl.field_77284_b - waterRange);
                while ((double)x <= Math.ceil(expl.field_77284_b + waterRange)) {
                    int y = (int)Math.floor(expl.field_77285_c - waterRange);
                    while ((double)y <= Math.ceil(expl.field_77285_c + waterRange)) {
                        int z = (int)Math.floor(expl.field_77282_d - waterRange);
                        while ((double)z <= Math.ceil(expl.field_77282_d + waterRange)) {
                            IBlockState state = event.getWorld().func_180495_p(new BlockPos(x, y, z));
                            if (state.func_177230_c() instanceof BlockLiquid) {
                                return;
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                expl.func_77278_a();
                event.getExplosion().field_77281_g.addAll(expl.field_77281_g);
            }
        }
    }

    @SubscribeEvent
    public void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        if (event.getEntity() instanceof PhysicsWrapperEntity) {
            event.setCanceled(true);
        }
    }
}

