/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common;

import com.esotericsoftware.kryo.Kryo;
import com.googlecode.cqengine.ConcurrentIndexedCollection;
import de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import de.javakaffee.kryoserializers.UUIDSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import de.javakaffee.kryoserializers.guava.ArrayListMultimapSerializer;
import de.javakaffee.kryoserializers.guava.ArrayTableSerializer;
import de.javakaffee.kryoserializers.guava.HashBasedTableSerializer;
import de.javakaffee.kryoserializers.guava.HashMultimapSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableListSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableMapSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableMultimapSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableSetSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableTableSerializer;
import de.javakaffee.kryoserializers.guava.LinkedHashMultimapSerializer;
import de.javakaffee.kryoserializers.guava.LinkedListMultimapSerializer;
import de.javakaffee.kryoserializers.guava.ReverseListSerializer;
import de.javakaffee.kryoserializers.guava.TreeBasedTableSerializer;
import de.javakaffee.kryoserializers.guava.TreeMultimapSerializer;
import de.javakaffee.kryoserializers.guava.UnmodifiableNavigableSetSerializer;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.mixin.MixinLoaderForge;
import org.valkyrienskies.mod.client.gui.TabValkyrienSkies;
import org.valkyrienskies.mod.common.block.BlockPhysicsInfuser;
import org.valkyrienskies.mod.common.block.BlockPhysicsInfuserCreative;
import org.valkyrienskies.mod.common.block.BlockPhysicsInfuserDummy;
import org.valkyrienskies.mod.common.command.framework.VSModCommandRegistry;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.item.ItemPhysicsCore;
import org.valkyrienskies.mod.common.network.PhysWrapperPositionHandler;
import org.valkyrienskies.mod.common.network.SubspacedEntityRecordHandler;
import org.valkyrienskies.mod.common.network.SubspacedEntityRecordMessage;
import org.valkyrienskies.mod.common.network.VSGuiButtonHandler;
import org.valkyrienskies.mod.common.network.VSGuiButtonMessage;
import org.valkyrienskies.mod.common.network.WrapperPositionMessage;
import org.valkyrienskies.mod.common.physics.management.DimensionPhysObjectManager;
import org.valkyrienskies.mod.common.physmanagement.VS_APIPhysicsEntityManager;
import org.valkyrienskies.mod.common.physmanagement.chunk.DimensionPhysicsChunkManager;
import org.valkyrienskies.mod.common.physmanagement.chunk.VSChunkClaim;
import org.valkyrienskies.mod.common.physmanagement.shipdata.IValkyrienSkiesWorldData;
import org.valkyrienskies.mod.common.physmanagement.shipdata.ImplValkyrienSkiesWorldData;
import org.valkyrienskies.mod.common.physmanagement.shipdata.ShipData;
import org.valkyrienskies.mod.common.physmanagement.shipdata.ShipPositionData;
import org.valkyrienskies.mod.common.physmanagement.shipdata.StorageValkyrienSkiesWorldData;
import org.valkyrienskies.mod.common.tileentity.TileEntityPhysicsInfuser;
import org.valkyrienskies.mod.proxy.CommonProxy;
import valkyrienwarfare.api.IPhysicsEntityManager;

@Mod(modid="valkyrienskies", name="Valkyrien Skies", version="1.0-alpha-1", updateJSON="https://raw.githubusercontent.com/ValkyrienSkies/Valkyrien-Skies/master/update.json", certificateFingerprint="b308676914a5e7d99459c1d2fb298744387899a7", acceptedMinecraftVersions="[1.12.2]")
public class ValkyrienSkiesMod {
    private static final Logger log = LogManager.getLogger(ValkyrienSkiesMod.class);
    public static final String MOD_ID = "valkyrienskies";
    public static final String MOD_NAME = "Valkyrien Skies";
    public static final String MOD_VERSION = "1.0-alpha-1";
    static final String MOD_FINGERPRINT = "b308676914a5e7d99459c1d2fb298744387899a7";
    @Mod.Instance(value="valkyrienskies")
    public static ValkyrienSkiesMod INSTANCE;
    @CapabilityInject(value=IValkyrienSkiesWorldData.class)
    public static final Capability<IValkyrienSkiesWorldData> VS_WORLD_DATA;
    @SidedProxy(clientSide="org.valkyrienskies.mod.proxy.ClientProxy", serverSide="org.valkyrienskies.mod.proxy.ServerProxy")
    public static CommonProxy proxy;
    static final int VS_ENTITY_LOAD_DISTANCE = 128;
    public static final DimensionPhysicsChunkManager VS_CHUNK_MANAGER;
    public static final DimensionPhysObjectManager VS_PHYSICS_MANAGER;
    private static ExecutorService PHYSICS_THREADS_EXECUTOR;
    public Block physicsInfuser;
    public Block physicsInfuserCreative;
    public Block physicsInfuserDummy;
    public Item physicsCore;
    public static SimpleNetworkWrapper physWrapperNetwork;
    public static final CreativeTabs VS_CREATIVE_TAB;
    private CompletableFuture<Kryo> kryoInstance;

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (MixinLoaderForge.isObfuscatedEnvironment) {
            FMLLog.bigWarning((String)"Valkyrien Skies JAR fingerprint corrupted, which means this copy of the mod may have come from unofficial sources. Please check out our official website: https://valkyrienskies.org", (Object[])new Object[0]);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log.debug("Initializing configuration");
        this.runConfiguration();
        log.debug("Instantiating the physics thread executor");
        PHYSICS_THREADS_EXECUTOR = Executors.newFixedThreadPool(VSConfig.threadCount);
        log.debug("Beginning asynchronous Kryo initialization");
        this.serializationInitAsync();
        this.registerNetworks((FMLStateEvent)event);
        this.registerCapabilities();
        proxy.preInit(event);
        log.debug("Initializing the VS API");
        try {
            Field instanceField = IPhysicsEntityManager.class.getDeclaredField("INSTANCE");
            instanceField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(instanceField, instanceField.getModifiers() & 0xFFFFFFEF);
            instanceField.set(null, new VS_APIPhysicsEntityManager());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.fatal("FAILED TO INITIALIZE VS API!");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        log.info("Valkyrien Skies Initialization:");
        log.info("We are running on " + Runtime.getRuntime().availableProcessors() + " threads; 4 or more is recommended!");
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        VSModCommandRegistry.registerCommands(server);
    }

    private void registerNetworks(FMLStateEvent event) {
        physWrapperNetwork = NetworkRegistry.INSTANCE.newSimpleChannel("physChannel");
        physWrapperNetwork.registerMessage(PhysWrapperPositionHandler.class, WrapperPositionMessage.class, 0, Side.CLIENT);
        physWrapperNetwork.registerMessage(SubspacedEntityRecordHandler.class, SubspacedEntityRecordMessage.class, 1, Side.CLIENT);
        physWrapperNetwork.registerMessage(SubspacedEntityRecordHandler.class, SubspacedEntityRecordMessage.class, 2, Side.SERVER);
        physWrapperNetwork.registerMessage(VSGuiButtonHandler.class, VSGuiButtonMessage.class, 3, Side.SERVER);
    }

    void registerBlocks(RegistryEvent.Register<Block> event) {
        this.physicsInfuser = ((Block)new BlockPhysicsInfuser(Material.field_151576_e).func_149711_c(8.0f).func_149663_c("physics_infuser").setRegistryName(MOD_ID, "physics_infuser")).func_149647_a(VS_CREATIVE_TAB);
        this.physicsInfuserCreative = ((Block)new BlockPhysicsInfuserCreative(Material.field_151576_e).func_149711_c(12.0f).func_149663_c("creative_physics_infuser").setRegistryName(MOD_ID, "creative_physics_infuser")).func_149647_a(VS_CREATIVE_TAB);
        this.physicsInfuserDummy = ((Block)new BlockPhysicsInfuserDummy(Material.field_151576_e).func_149711_c(12.0f).func_149663_c("dummy_physics_infuser").setRegistryName(MOD_ID, "dummy_physics_infuser")).func_149647_a(VS_CREATIVE_TAB);
        event.getRegistry().register((IForgeRegistryEntry)this.physicsInfuser);
        event.getRegistry().register((IForgeRegistryEntry)this.physicsInfuserCreative);
        event.getRegistry().register((IForgeRegistryEntry)this.physicsInfuserDummy);
        this.registerTileEntities();
    }

    private void serializationInitAsync() {
        this.kryoInstance = CompletableFuture.supplyAsync(() -> {
            long start = System.currentTimeMillis();
            Kryo kryo = new Kryo();
            UnmodifiableCollectionsSerializer.registerSerializers(kryo);
            SynchronizedCollectionsSerializer.registerSerializers(kryo);
            ImmutableListSerializer.registerSerializers(kryo);
            ImmutableSetSerializer.registerSerializers(kryo);
            ImmutableMapSerializer.registerSerializers(kryo);
            ImmutableMultimapSerializer.registerSerializers(kryo);
            ImmutableTableSerializer.registerSerializers(kryo);
            ReverseListSerializer.registerSerializers(kryo);
            UnmodifiableNavigableSetSerializer.registerSerializers(kryo);
            ArrayListMultimapSerializer.registerSerializers(kryo);
            HashMultimapSerializer.registerSerializers(kryo);
            LinkedHashMultimapSerializer.registerSerializers(kryo);
            LinkedListMultimapSerializer.registerSerializers(kryo);
            TreeMultimapSerializer.registerSerializers(kryo);
            ArrayTableSerializer.registerSerializers(kryo);
            HashBasedTableSerializer.registerSerializers(kryo);
            TreeBasedTableSerializer.registerSerializers(kryo);
            kryo.register(ConcurrentIndexedCollection.class);
            kryo.register(ShipData.class);
            kryo.register(ShipPositionData.class);
            kryo.register(VSChunkClaim.class);
            kryo.register(HashSet.class);
            kryo.register(UUID.class, new UUIDSerializer());
            kryo.setRegistrationRequired(false);
            log.debug("Kryo initialization: " + (System.currentTimeMillis() - start) + "ms");
            return kryo;
        });
    }

    public Kryo getKryo() {
        try {
            return this.kryoInstance.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void registerItems(RegistryEvent.Register<Item> event) {
        ValkyrienSkiesMod.registerItemBlock(event, this.physicsInfuser);
        ValkyrienSkiesMod.registerItemBlock(event, this.physicsInfuserCreative);
        this.physicsCore = ((Item)new ItemPhysicsCore().func_77655_b("physics_core").setRegistryName(MOD_ID, "physics_core")).func_77637_a(VS_CREATIVE_TAB);
        event.getRegistry().register((IForgeRegistryEntry)this.physicsCore);
    }

    private static void registerItemBlock(RegistryEvent.Register<Item> event, Block block) {
        event.getRegistry().register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }

    void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ValkyrienSkiesMod.registerRecipe(event, "recipe_physics_infuser", new ItemStack(this.physicsInfuser), "IEI", "ODO", "IEI", Character.valueOf('E'), Items.field_151079_bi, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('O'), Item.func_150898_a((Block)Blocks.field_150343_Z), Character.valueOf('I'), Items.field_151042_j);
    }

    private static void registerRecipe(RegistryEvent.Register<IRecipe> event, String registryName, ItemStack out, Object ... in) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])in);
        event.getRegistry().register(new ShapedRecipes(MOD_ID, primer.width, primer.height, primer.input, out).setRegistryName(MOD_ID, registryName));
    }

    private void runConfiguration() {
        VSConfig.sync();
    }

    private void registerCapabilities() {
        CapabilityManager.INSTANCE.register(IValkyrienSkiesWorldData.class, (Capability.IStorage)new StorageValkyrienSkiesWorldData(), ImplValkyrienSkiesWorldData::new);
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityPhysicsInfuser.class, (ResourceLocation)new ResourceLocation(MOD_ID, "tile_physics_infuser"));
    }

    public static ExecutorService getPHYSICS_THREADS_EXECUTOR() {
        return PHYSICS_THREADS_EXECUTOR;
    }

    static {
        VS_WORLD_DATA = null;
        VS_CHUNK_MANAGER = new DimensionPhysicsChunkManager();
        VS_PHYSICS_MANAGER = new DimensionPhysObjectManager();
        PHYSICS_THREADS_EXECUTOR = null;
        VS_CREATIVE_TAB = new TabValkyrienSkies(MOD_ID);
    }
}

