/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.valkyrienskies.mod.common.coordinates.ShipTransform;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import valkyrienwarfare.api.TransformType;

public interface IBlockForceProvider {
    @Nullable
    default public Vector getBlockForceInWorldSpace(World world, BlockPos pos, IBlockState state, PhysicsObject physicsObject, double secondsToApply) {
        Vector toReturn = this.getBlockForceInShipSpace(world, pos, state, physicsObject, secondsToApply);
        if (toReturn == null) {
            return null;
        }
        if (this.shouldLocalForceBeRotated(world, pos, state, secondsToApply)) {
            ShipTransform shipTransform = physicsObject.getShipTransformationManager().getCurrentTickTransform();
            shipTransform.rotate(toReturn, TransformType.SUBSPACE_TO_GLOBAL);
        }
        return toReturn;
    }

    @Nullable
    public Vector getBlockForceInShipSpace(World var1, BlockPos var2, IBlockState var3, PhysicsObject var4, double var5);

    public boolean shouldLocalForceBeRotated(World var1, BlockPos var2, IBlockState var3, double var4);

    @Nullable
    default public Vector getCustomBlockForcePosition(World world, BlockPos pos, IBlockState state, PhysicsObject physicsObject, double secondsToApply) {
        return null;
    }

    default public boolean doesForceSpawnParticles() {
        return false;
    }
}

