/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.command;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.valkyrienskies.mod.common.command.autocompleters.ShipNameAutocompleter;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.multithreaded.VSThread;
import org.valkyrienskies.mod.common.physmanagement.shipdata.QueryableShipData;
import org.valkyrienskies.mod.common.physmanagement.shipdata.ShipData;
import org.valkyrienskies.mod.common.ship_handling.IHasShipManager;
import org.valkyrienskies.mod.common.ship_handling.WorldServerShipManager;
import org.valkyrienskies.mod.common.tileentity.TileEntityPhysicsInfuser;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import picocli.CommandLine;

@CommandLine.Command(name="valkyrienskies", aliases={"vs"}, synopsisSubcommandLabel="COMMAND", mixinStandardHelpOptions=true, usageHelpWidth=55, subcommands={CommandLine.HelpCommand.class, ListShips.class, DisableShip.class, GC.class, TPS.class})
public class MainCommand
implements Runnable {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @Inject
    private ICommandSender sender;

    @Override
    public void run() {
        String usageMessage = this.spec.commandLine().getUsageMessage().replace("\r", "");
        this.sender.func_145747_a((ITextComponent)new TextComponentString(usageMessage));
    }

    @CommandLine.Command(name="list-ships", aliases={"ls"})
    static class ListShips
    implements Runnable {
        @Inject
        ICommandSender sender;
        @CommandLine.Option(names={"-v", "--verbose"})
        boolean verbose;

        ListShips() {
        }

        @Override
        public void run() {
            World world = this.sender.func_130014_f_();
            QueryableShipData data = ValkyrienUtils.getQueryableData(world);
            if (data.getShips().size() == 0) {
                this.sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.vs.list-ships.noships", new Object[0]));
                return;
            }
            String listOfShips = this.verbose ? data.getShips().stream().map(shipData -> {
                if (shipData.getPositionData() == null) {
                    return String.format("%s, Unknown Location", shipData.getName());
                }
                return String.format("%s [%.1f, %.1f, %.1f]", shipData.getName(), shipData.getPositionData().getPosX(), shipData.getPositionData().getPosY(), shipData.getPositionData().getPosZ());
            }).collect(Collectors.joining(",\n")) : data.getShips().stream().map(ShipData::getName).collect(Collectors.joining(",\n"));
            this.sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.vs.list-ships.ships", new Object[]{listOfShips}));
        }
    }

    @CommandLine.Command(name="ship-physics")
    static class DisableShip
    implements Runnable {
        @Inject
        ICommandSender sender;
        @CommandLine.Spec
        CommandLine.Model.CommandSpec spec;
        @CommandLine.Parameters(index="0", completionCandidates=ShipNameAutocompleter.class)
        String shipName;
        @CommandLine.Parameters(index="1", arity="0..1")
        boolean enabled;

        DisableShip() {
        }

        @Override
        public void run() {
            World world = this.sender.func_130014_f_();
            QueryableShipData data = QueryableShipData.get(world);
            Optional<ShipData> oTargetShipData = data.getShipFromName(this.shipName);
            if (!oTargetShipData.isPresent()) {
                this.sender.func_145747_a((ITextComponent)new TextComponentString("That ship, " + this.shipName + " could not be found"));
                return;
            }
            ShipData targetShipData = oTargetShipData.get();
            Optional<Entity> oEntity = world.func_72910_y().stream().filter(e -> e.getPersistentID().equals(targetShipData.getUUID())).findFirst();
            if (!oEntity.isPresent()) {
                throw new RuntimeException("QueryableShipData is incorrect?");
            }
            try {
                PhysicsWrapperEntity wrapperEntity = (PhysicsWrapperEntity)oEntity.get();
                BlockPos infuserPos = wrapperEntity.getPhysicsObject().getPhysicsInfuserPos();
                TileEntityPhysicsInfuser infuser = Objects.requireNonNull((TileEntityPhysicsInfuser)world.func_175625_s(infuserPos));
                if (this.spec.commandLine().getParseResult().hasMatchedPositional(1)) {
                    infuser.setPhysicsEnabled(this.enabled);
                    this.sender.func_145747_a((ITextComponent)new TextComponentString("Successfully set the physics of ship " + this.shipName + " to " + (infuser.isPhysicsEnabled() ? "enabled" : "disabled")));
                } else {
                    this.sender.func_145747_a((ITextComponent)new TextComponentString("The physics of the ship " + this.shipName + " is " + (infuser.isPhysicsEnabled() ? "enabled" : "disabled")));
                }
            }
            catch (ClassCastException e2) {
                throw new RuntimeException("Ship entity is not PhysicsWrapperEntity or Physics infuser is not a physics infuser?", e2);
            }
        }
    }

    @CommandLine.Command(name="tps")
    static class TPS
    implements Runnable {
        @Inject
        ICommandSender sender;
        @CommandLine.Option(names={"--world", "-w"})
        World world;

        TPS() {
        }

        @Override
        public void run() {
            VSThread worldPhysicsThread;
            if (this.world == null) {
                this.world = this.sender.func_130014_f_();
            }
            if ((worldPhysicsThread = ((WorldServerShipManager)((IHasShipManager)this.world).getManager()).getPhysicsThread()) != null) {
                long averagePhysTickTimeNano = worldPhysicsThread.getAveragePhysicsTickTimeNano();
                double ticksPerSecond = 1.0E9 / (double)averagePhysTickTimeNano;
                double ticksPerSecondTwoDecimals = Math.floor(ticksPerSecond * 100.0) / 100.0;
                this.sender.func_145747_a((ITextComponent)new TextComponentString("Player world: " + ticksPerSecondTwoDecimals + " physics ticks per second"));
            }
        }
    }

    @CommandLine.Command(name="gc")
    static class GC
    implements Runnable {
        @Inject
        ICommandSender sender;

        GC() {
        }

        @Override
        public void run() {
            System.gc();
            this.sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.vs.gc.success", new Object[0]));
        }
    }
}

