/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.command.config;

import java.lang.reflect.Field;
import javax.annotation.Nullable;

class ConfigCommandUtils {
    ConfigCommandUtils() {
    }

    public static void setFieldFromString(String string, Field field) {
        ConfigCommandUtils.setFieldFromString(string, field, null);
    }

    public static void setFieldFromString(String string, Field field, @Nullable Object object) {
        if (!ConfigCommandUtils.isSupportedType(field.getType())) {
            throw new IllegalArgumentException("Unsupported field type");
        }
        try {
            if (field.getType() == Integer.TYPE) {
                field.setInt(object, Integer.parseInt(string));
            } else if (field.getType() == Double.TYPE) {
                field.setDouble(object, Double.parseDouble(string));
            } else if (field.getType() == Float.TYPE) {
                field.setFloat(object, Float.parseFloat(string));
            } else if (field.getType() == Boolean.TYPE) {
                field.setBoolean(object, Boolean.parseBoolean(string));
            } else if (field.getType() == Byte.TYPE) {
                field.setByte(object, Byte.parseByte(string));
            } else if (field.getType() == Long.TYPE) {
                field.setLong(object, Long.parseLong(string));
            } else if (field.getType() == Short.TYPE) {
                field.setShort(object, Short.parseShort(string));
            } else if (field.getType() == Character.TYPE) {
                field.setChar(object, string.charAt(0));
            } else if (field.getType() == String.class) {
                field.set(object, string);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isSupportedType(Class<?> type) {
        return type == Integer.TYPE || type == Double.TYPE || type == Float.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Long.TYPE || type == Short.TYPE || type == Character.TYPE || type == String.class;
    }

    public static String getStringFromField(Field field) {
        return ConfigCommandUtils.getStringFromField(field, null);
    }

    public static String getStringFromField(Field field, @Nullable Object object) {
        try {
            return field.get(object).toString();
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }
}

