/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.valkyrienskies.mod.common.command.config.ShortName;
import org.valkyrienskies.mod.common.config.VSConfigTemplate;
import org.valkyrienskies.mod.common.math.Vector;

@Config(modid="valkyrienskies", name="Valkyrien Skies")
public class VSConfig
extends VSConfigTemplate {
    @Config.Name(value="Ship Y-Height Maximum")
    public static double shipUpperLimit = 1000.0;
    @Config.Name(value="Ship Y-Height Minimum")
    public static double shipLowerLimit = -30.0;
    @Config.Name(value="Enable airship permissions (does nothing atm)")
    public static boolean runAirshipPermissions = false;
    @Config.Name(value="Enable gravity")
    public static boolean doGravity = true;
    public static boolean doPhysicsBlocks = true;
    public static boolean doValkyriumLifting = true;
    public static boolean doAirshipRotation = true;
    public static boolean doAirshipMovement = true;
    @Config.Name(value="Disable wrench modes")
    @Config.Comment(value={"Makes wrench toggle a multiblock's constructed state, removes modes."})
    public static boolean wrenchModeless = false;
    public static double physSpeed = 0.01;
    @Config.Comment(value={"The number of threads to use for physics, recommended to use your cpu's thread count minus 2. Cannot be set at runtime."})
    @Config.RangeInt(min=2)
    public static int threadCount = Math.max(2, Runtime.getRuntime().availableProcessors() - 2);
    @Config.Name(value="Max airships per player")
    @Config.Comment(value={"Players can't own more than this many airships at once. Set to -1 to disable"})
    public static int maxAirships = -1;
    public static int maxShipSize = 15000;
    public static double gravityVecX = 0.0;
    public static double gravityVecY = -9.8;
    public static double gravityVecZ = 0.0;
    @Config.Name(value="Valkyrium Crystal Anti-Gravity force")
    @Config.Comment(value={"Default is 1. Set to 0 to disable."})
    public static double valkyriumCrystalForce = 1.0;
    @Config.Name(value="Valkyrium Ore Anti-Gravity force")
    @Config.Comment(value={"1 is the same as a crystal, default is 4. Set to 0 to disable."})
    public static double valkyriumOreForce = 4.0;
    @Config.Name(value="Network Relay connections limit")
    @Config.Comment(value={"How many components or relays can be connected, default is 8."})
    public static int networkRelayLimit = 8;
    @Config.Name(value="Relay Wire Length")
    @Config.Comment(value={"How long, in metres, a single relay wire can extend. Default is 8m."})
    public static double relayWireLength = 8.0;
    @Config.Name(value="Engine Power")
    @ShortName(value="enginePower")
    public static final EnginePower ENGINE_POWER = new EnginePower();
    @Config.Comment(value={"Blocks to not be included when assembling a ship"})
    public static String[] shipSpawnDetectorBlacklist = new String[]{"minecraft:air", "minecraft:dirt", "minecraft:grass", "minecraft:stone", "minecraft:tallgrass", "minecraft:water", "minecraft:flowing_water", "minecraft:sand", "minecraft:sandstone", "minecraft:gravel", "minecraft:ice", "minecraft:snow", "minecraft:snow_layer", "minecraft:lava", "minecraft:flowing_lava", "minecraft:grass_path", "minecraft:bedrock", "minecraft:end_portal_frame", "minecraft:end_portal", "minecraft:end_gateway", "minecraft:portal"};
    public static String[] blockMass = new String[]{"minecraft:grass=1500"};

    public static Vector gravity() {
        return new Vector(gravityVecX, gravityVecY, gravityVecZ);
    }

    public static void sync() {
        ConfigManager.sync((String)"valkyrienskies", (Config.Type)Config.Type.INSTANCE);
        VSConfig.onSync();
    }

    @Mod.EventBusSubscriber(modid="valkyrienskies")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("valkyrienskies")) {
                VSConfig.sync();
            }
        }
    }

    public static class EnginePower {
        @Config.RequiresMcRestart
        public double basicEnginePower = 2000.0;
        @Config.RequiresMcRestart
        public double advancedEnginePower = 2500.0;
        @Config.RequiresMcRestart
        public double eliteEnginePower = 5000.0;
        @Config.RequiresMcRestart
        public double ultimateEnginePower = 10000.0;
        @Config.RequiresMcRestart
        public double redstoneEnginePower = 500.0;
    }
}

