/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.container;

import java.util.function.Function;
import org.valkyrienskies.mod.common.tileentity.TileEntityPhysicsInfuser;

public enum EnumInfuserButton {
    ASSEMBLE_SHIP("gui.assemble_ship", "gui.disassemble_ship", tileEntity -> !tileEntity.isCurrentlyInShip(), tileEntity -> tileEntity.canMaintainShip() && tileEntity.canShipBeDeconstructed() && tileEntity.isCenterOfShip()),
    ENABLE_PHYSICS("gui.enable_physics", "gui.disable_physics", tileEntity -> !tileEntity.isPhysicsEnabled(), tileEntity -> tileEntity.canMaintainShip() && tileEntity.isCurrentlyInShip() && tileEntity.isCenterOfShip()),
    ALIGN_SHIP("gui.align_ship", "gui.stop_align_ship", tileEntity -> !tileEntity.isTryingToAlignShip(), tileEntity -> tileEntity.canMaintainShip() && tileEntity.isCurrentlyInShip() && tileEntity.isCenterOfShip());

    private final String trueMessage;
    private final String falseMessage;
    private final Function<TileEntityPhysicsInfuser, Boolean> messageDiscriminator;
    private final Function<TileEntityPhysicsInfuser, Boolean> buttonEnabled;

    private EnumInfuserButton(String trueMessage, String falseMessage, Function<TileEntityPhysicsInfuser, Boolean> messageDiscriminator, Function<TileEntityPhysicsInfuser, Boolean> buttonEnabled) {
        this.trueMessage = trueMessage;
        this.falseMessage = falseMessage;
        this.messageDiscriminator = messageDiscriminator;
        this.buttonEnabled = buttonEnabled;
    }

    public String getButtonText(TileEntityPhysicsInfuser tileEntity) {
        return this.messageDiscriminator.apply(tileEntity) != false ? this.trueMessage : this.falseMessage;
    }

    public boolean buttonEnabled(TileEntityPhysicsInfuser tileEntity) {
        return this.buttonEnabled.apply(tileEntity);
    }
}

