/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.coordinates;

import javax.annotation.concurrent.Immutable;
import org.valkyrienskies.mod.common.coordinates.CoordinateSpaceType;
import org.valkyrienskies.mod.common.coordinates.ISubspace;
import org.valkyrienskies.mod.common.coordinates.ISubspacedEntity;
import org.valkyrienskies.mod.common.coordinates.VectorImmutable;
import valkyrienwarfare.api.TransformType;

@Immutable
public interface ISubspacedEntityRecord {
    public ISubspacedEntity getParentEntity();

    public ISubspace getParentSubspace();

    public VectorImmutable getPosition();

    public VectorImmutable getPositionLastTick();

    public VectorImmutable getLookDirection();

    public VectorImmutable getVelocity();

    default public VectorImmutable getPositionInGlobalCoordinates() {
        if (this.getParentSubspace().getSubspaceCoordinatesType() == CoordinateSpaceType.GLOBAL_COORDINATES) {
            return this.getPosition();
        }
        return this.getParentSubspace().getSubspaceTransform().transform(this.getPosition(), TransformType.SUBSPACE_TO_GLOBAL);
    }

    default public VectorImmutable getPositionLastTickInGlobalCoordinates() {
        if (this.getParentSubspace().getSubspaceCoordinatesType() == CoordinateSpaceType.GLOBAL_COORDINATES) {
            return this.getPositionLastTick();
        }
        return this.getParentSubspace().getSubspaceTransform().transform(this.getPositionLastTick(), TransformType.SUBSPACE_TO_GLOBAL);
    }

    default public VectorImmutable getLookDirectionInGlobalCoordinates() {
        if (this.getParentSubspace().getSubspaceCoordinatesType() == CoordinateSpaceType.GLOBAL_COORDINATES) {
            return this.getLookDirection();
        }
        return this.getParentSubspace().getSubspaceTransform().rotate(this.getLookDirection(), TransformType.SUBSPACE_TO_GLOBAL);
    }

    default public VectorImmutable getVelocityInGlobalCoordinates() {
        if (this.getParentSubspace().getSubspaceCoordinatesType() == CoordinateSpaceType.GLOBAL_COORDINATES) {
            return this.getVelocity();
        }
        return this.getParentSubspace().getSubspaceTransform().rotate(this.getVelocity(), TransformType.SUBSPACE_TO_GLOBAL);
    }
}

