/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.coordinates;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.valkyrienskies.mod.common.coordinates.CoordinateSpaceType;
import org.valkyrienskies.mod.common.coordinates.ISubspace;
import org.valkyrienskies.mod.common.coordinates.ISubspacedEntity;
import org.valkyrienskies.mod.common.coordinates.ISubspacedEntityRecord;
import org.valkyrienskies.mod.common.coordinates.ImplSubspacedEntityRecord;
import org.valkyrienskies.mod.common.coordinates.ShipTransform;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import valkyrienwarfare.api.TransformType;

public class ImplSubspace
implements ISubspace {
    private final PhysicsObject parent;
    private final Map<ISubspacedEntity, ISubspacedEntityRecord> subspacedEntityRecords;

    public ImplSubspace(@Nullable PhysicsObject parent) {
        this.parent = parent;
        this.subspacedEntityRecords = new HashMap<ISubspacedEntity, ISubspacedEntityRecord>();
    }

    @Override
    public boolean hasRecordForSubspacedEntity(ISubspacedEntity subspaced) {
        return this.subspacedEntityRecords.containsKey(subspaced);
    }

    @Override
    public ISubspacedEntityRecord getRecordForSubspacedEntity(ISubspacedEntity subspaced) {
        return this.subspacedEntityRecords.get(subspaced);
    }

    @Override
    public void snapshotSubspacedEntity(ISubspacedEntity subspaced) {
        if (subspaced.currentSubspaceType() != CoordinateSpaceType.GLOBAL_COORDINATES) {
            throw new IllegalArgumentException("Subspace snapshots can only be taken for entities that in the global coordinates system!");
        }
        if (subspaced instanceof PhysicsWrapperEntity) {
            throw new IllegalArgumentException("Do not create subspace records for PhysicsWrapperEntities!!");
        }
        this.subspacedEntityRecords.put(subspaced, this.createRecordForSubspacedEntity(subspaced));
    }

    private ISubspacedEntityRecord createRecordForSubspacedEntity(ISubspacedEntity subspacedEntity) {
        Vector position = subspacedEntity.createCurrentPositionVector();
        Vector positionLastTick = subspacedEntity.createLastTickPositionVector();
        Vector look = subspacedEntity.createCurrentLookVector();
        Vector velocity = subspacedEntity.createCurrentVelocityVector();
        ShipTransform subspaceTransform = this.getSubspaceTransform();
        if (subspaceTransform != null) {
            subspaceTransform.transform(position, TransformType.GLOBAL_TO_SUBSPACE);
            subspaceTransform.rotate(look, TransformType.GLOBAL_TO_SUBSPACE);
            subspaceTransform.rotate(velocity, TransformType.GLOBAL_TO_SUBSPACE);
        }
        return new ImplSubspacedEntityRecord(subspacedEntity, this, position.toImmutable(), positionLastTick.toImmutable(), look.toImmutable(), velocity.toImmutable());
    }

    @Override
    public CoordinateSpaceType getSubspaceCoordinatesType() {
        if (this.parent == null) {
            return CoordinateSpaceType.GLOBAL_COORDINATES;
        }
        return CoordinateSpaceType.SUBSPACE_COORDINATES;
    }

    @Override
    public ShipTransform getSubspaceTransform() {
        if (this.getSubspaceCoordinatesType() == CoordinateSpaceType.GLOBAL_COORDINATES) {
            return null;
        }
        ShipTransform transform = this.parent.getShipTransformationManager().getCurrentTickTransform();
        if (transform == null) {
            throw new IllegalStateException("A PhysicsObject got a request to use its subspace, but it had no transforms loaded. This is crash worthy.");
        }
        return transform;
    }

    @Override
    public int getSubspaceParentEntityID() {
        if (this.getSubspaceCoordinatesType() == CoordinateSpaceType.GLOBAL_COORDINATES) {
            throw new IllegalStateException("The World coordinate subspace doesn't have an entity ID. Don't call this method unless you're sure that the subspace isn't the world.");
        }
        return this.parent.getWrapperEntity().func_145782_y();
    }

    @Override
    public void forceSubspaceRecord(ISubspacedEntity entity, ISubspacedEntityRecord record) {
        this.subspacedEntityRecords.put(entity, record);
    }
}

