/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.coordinates;

import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.mod.common.coordinates.VectorImmutable;
import org.valkyrienskies.mod.common.math.Quaternion;
import org.valkyrienskies.mod.common.math.RotationMatrices;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.util.ValkyrienNBTUtils;
import valkyrienwarfare.api.TransformType;

@Immutable
public class ShipTransform {
    private static final Logger log = LogManager.getLogger(ShipTransform.class);
    private final double[] subspaceToGlobal;
    private final double[] globalToSubspace;

    @Deprecated
    public ShipTransform(double[] subspaceToGlobal) {
        this.subspaceToGlobal = subspaceToGlobal;
        this.globalToSubspace = RotationMatrices.inverse(subspaceToGlobal);
    }

    public ShipTransform(ShipTransform current, ShipTransform next) {
        double[] currentWorldToLocal = current.globalToSubspace;
        double[] nextLocaltoWorld = next.subspaceToGlobal;
        double[] currentWorldToNextWorld = RotationMatrices.getMatrixProduct(nextLocaltoWorld, currentWorldToLocal);
        this.subspaceToGlobal = currentWorldToNextWorld;
        this.globalToSubspace = RotationMatrices.inverse(this.subspaceToGlobal);
    }

    public ShipTransform(double posX, double posY, double posZ, double pitch, double yaw, double roll, Vector centerCoord) {
        double[] lToWTransform = RotationMatrices.getTranslationMatrix(posX, posY, posZ);
        lToWTransform = RotationMatrices.rotateAndTranslate(lToWTransform, pitch, yaw, roll, centerCoord);
        this.subspaceToGlobal = lToWTransform;
        this.globalToSubspace = RotationMatrices.inverse(this.subspaceToGlobal);
    }

    public ShipTransform(double translateX, double translateY, double translateZ) {
        this(translateX, translateY, translateZ, 0.0, 0.0, 0.0, new Vector());
    }

    public ShipTransform() {
        this(RotationMatrices.getDoubleIdentity());
    }

    public static ShipTransform createRotationTransform(double pitch, double yaw, double roll) {
        double[] rotationOnlyMatrix = RotationMatrices.getRotationMatrix(pitch, yaw, roll);
        return new ShipTransform(rotationOnlyMatrix);
    }

    public void transform(Vector vector, TransformType transformType) {
        RotationMatrices.applyTransform(this.getInternalMatrix(transformType), vector);
    }

    public void rotate(Vector vector, TransformType transformType) {
        RotationMatrices.doRotationOnly(this.getInternalMatrix(transformType), vector);
    }

    public Vec3d transform(Vec3d vec3d, TransformType transformType) {
        Vector vec3dAsVector = new Vector(vec3d);
        this.transform(vec3dAsVector, transformType);
        return vec3dAsVector.toVec3d();
    }

    public Vec3d rotate(Vec3d vec3d, TransformType transformType) {
        Vector vec3dAsVector = new Vector(vec3d);
        this.rotate(vec3dAsVector, transformType);
        return vec3dAsVector.toVec3d();
    }

    public BlockPos transform(BlockPos pos, TransformType transformType) {
        Vector blockPosAsVector = new Vector((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        this.transform(blockPosAsVector, transformType);
        return new BlockPos(blockPosAsVector.X - 0.5, blockPosAsVector.Y - 0.5, blockPosAsVector.Z - 0.5);
    }

    public Quaternion createRotationQuaternion(TransformType transformType) {
        return Quaternion.QuaternionFromMatrix(this.getInternalMatrix(transformType));
    }

    public void writeToNBT(NBTTagCompound compound, String name) {
        compound.func_74773_a(name, ValkyrienNBTUtils.toByteArray(this.subspaceToGlobal));
    }

    @Nullable
    public static ShipTransform readFromNBT(NBTTagCompound compound, String name) {
        byte[] localToGlobalAsBytes = compound.func_74770_j(name);
        if (localToGlobalAsBytes.length == 0) {
            log.error("Loading from the ShipTransform has failed, now we are forced to fallback on Vanilla MC positions. This probably won't go well at all!");
            return null;
        }
        double[] localToGlobalInternalArray = ValkyrienNBTUtils.toDoubleArray(localToGlobalAsBytes);
        return new ShipTransform(localToGlobalInternalArray);
    }

    public VectorImmutable transform(VectorImmutable vector, TransformType transformType) {
        Vector vectorMutable = vector.createMutableVectorCopy();
        this.transform(vectorMutable, transformType);
        return vectorMutable.toImmutable();
    }

    public VectorImmutable rotate(VectorImmutable vector, TransformType transformType) {
        Vector vectorMutable = vector.createMutableVectorCopy();
        this.rotate(vectorMutable, transformType);
        return vectorMutable.toImmutable();
    }

    @Deprecated
    private double[] getInternalMatrix(TransformType transformType) {
        switch (transformType) {
            case SUBSPACE_TO_GLOBAL: {
                return Arrays.copyOf(this.subspaceToGlobal, this.subspaceToGlobal.length);
            }
            case GLOBAL_TO_SUBSPACE: {
                return Arrays.copyOf(this.globalToSubspace, this.globalToSubspace.length);
            }
        }
        throw new IllegalArgumentException("Unexpected TransformType Enum: " + (Object)((Object)transformType));
    }

    @Deprecated
    public void transform(Entity entity, TransformType subspaceToGlobal) {
        RotationMatrices.applyTransform(this, entity, subspaceToGlobal);
    }

    public Matrix3d createRotationMatrix(TransformType transformType) {
        double[] internalRotationMatrix = this.getInternalMatrix(transformType);
        return new Matrix3d(internalRotationMatrix[0], internalRotationMatrix[1], internalRotationMatrix[2], internalRotationMatrix[4], internalRotationMatrix[5], internalRotationMatrix[6], internalRotationMatrix[8], internalRotationMatrix[9], internalRotationMatrix[10]);
    }

    public Matrix4d createTransformMatrix(TransformType transformType) {
        double[] internalMatrix = this.getInternalMatrix(transformType);
        return new Matrix4d(internalMatrix);
    }

    @Deprecated
    public float[] generateFastRawTransformMatrix(TransformType transformType) {
        double[] internalMatrix = this.getInternalMatrix(transformType);
        float[] floatMatrix = new float[internalMatrix.length];
        for (int i = 0; i < internalMatrix.length; ++i) {
            floatMatrix[i] = (float)internalMatrix[i];
        }
        return floatMatrix;
    }
}

