/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.entity;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import org.valkyrienskies.mod.common.coordinates.CoordinateSpaceType;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.util.ValkyrienUtils;
import valkyrienwarfare.api.TransformType;

@ParametersAreNonnullByDefault
public class EntityMountable
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<NBTTagCompound> SHARED_NBT = EntityDataManager.func_187226_a(EntityMountable.class, (DataSerializer)DataSerializers.field_192734_n);
    private Vec3d mountPos = null;
    private CoordinateSpaceType mountPosSpace = null;
    private BlockPos referencePos = null;

    public EntityMountable(World worldIn) {
        super(worldIn);
        this.field_70130_N = 0.01f;
        this.field_70131_O = 0.01f;
        this.field_70180_af.func_187214_a(SHARED_NBT, (Object)new NBTTagCompound());
    }

    private EntityMountable(World worldIn, Vec3d chairPos, CoordinateSpaceType coordinateSpaceType) {
        this(worldIn);
        this.mountPos = chairPos;
        this.func_70107_b(chairPos.field_72450_a, chairPos.field_72448_b, chairPos.field_72449_c);
        this.mountPosSpace = coordinateSpaceType;
    }

    public EntityMountable(World worldIn, Vec3d chairPos, CoordinateSpaceType coordinateSpaceType, BlockPos shipReferencePos) {
        this(worldIn, chairPos, coordinateSpaceType);
        this.referencePos = shipReferencePos;
    }

    public void setMountValues(Vec3d mountPos, CoordinateSpaceType mountPosSpace, BlockPos referencePos) {
        this.mountPos = mountPos;
        this.mountPosSpace = mountPosSpace;
        this.referencePos = referencePos;
        this.updateSharedNBT();
    }

    private void updateSharedNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_70014_b(tagCompound);
        this.field_70180_af.func_187227_b(SHARED_NBT, (Object)tagCompound);
    }

    public Vec3d getMountPos() {
        return this.mountPos;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key == SHARED_NBT) {
            this.func_70037_a((NBTTagCompound)this.field_70180_af.func_187225_a(SHARED_NBT));
        }
    }

    public void func_70071_h_() {
        if (this.field_70148_d) {
            this.updateSharedNBT();
        }
        super.func_70071_h_();
        if (this.mountPos == null) {
            throw new IllegalStateException("Mounting position not present!");
        }
        if (this.mountPosSpace == null) {
            throw new IllegalStateException("Mounting space type not present!");
        }
        if (!this.func_130014_f_().field_72995_K && !this.func_184207_aI()) {
            this.func_70106_y();
        }
        Vec3d entityPos = this.mountPos;
        if (this.mountPosSpace == CoordinateSpaceType.SUBSPACE_COORDINATES) {
            if (this.referencePos == null) {
                throw new IllegalStateException("Mounting reference position for ship not present!");
            }
            Optional<PhysicsObject> mountedOnto = this.getMountedShip();
            if (mountedOnto.isPresent()) {
                entityPos = mountedOnto.get().transformVector(entityPos, TransformType.SUBSPACE_TO_GLOBAL);
            } else {
                new IllegalStateException("Couldn't access ship with reference coordinates " + this.referencePos).printStackTrace();
                return;
            }
        }
        this.func_70107_b(entityPos.field_72450_a, entityPos.field_72448_b, entityPos.field_72449_c);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.mountPos = new Vec3d(compound.func_74769_h("vs_mount_pos_x"), compound.func_74769_h("vs_mount_pos_y"), compound.func_74769_h("vs_mount_pos_z"));
        this.mountPosSpace = CoordinateSpaceType.values()[compound.func_74762_e("vs_coord_type")];
        this.referencePos = compound.func_74767_n("vs_ref_pos_present") ? new BlockPos(compound.func_74762_e("vs_ref_pos_x"), compound.func_74762_e("vs_ref_pos_y"), compound.func_74762_e("vs_ref_pos_z")) : null;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        Vec3d mountPosLocal = this.mountPos;
        compound.func_74780_a("vs_mount_pos_x", mountPosLocal.field_72450_a);
        compound.func_74780_a("vs_mount_pos_y", mountPosLocal.field_72448_b);
        compound.func_74780_a("vs_mount_pos_z", mountPosLocal.field_72449_c);
        compound.func_74768_a("vs_coord_type", this.mountPosSpace.ordinal());
        compound.func_74757_a("vs_ref_pos_present", this.referencePos != null);
        if (this.referencePos != null) {
            compound.func_74768_a("vs_ref_pos_x", this.referencePos.func_177958_n());
            compound.func_74768_a("vs_ref_pos_y", this.referencePos.func_177956_o());
            compound.func_74768_a("vs_ref_pos_z", this.referencePos.func_177952_p());
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        PacketBuffer packetBuffer = new PacketBuffer(buffer);
        Vec3d mountPosLocal = this.mountPos;
        packetBuffer.writeDouble(mountPosLocal.field_72450_a);
        packetBuffer.writeDouble(mountPosLocal.field_72448_b);
        packetBuffer.writeDouble(mountPosLocal.field_72449_c);
        packetBuffer.writeInt(this.mountPosSpace.ordinal());
        packetBuffer.writeBoolean(this.referencePos != null);
        if (this.referencePos != null) {
            packetBuffer.func_179255_a(this.referencePos);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        PacketBuffer packetBuffer = new PacketBuffer(additionalData);
        this.mountPos = new Vec3d(packetBuffer.readDouble(), packetBuffer.readDouble(), packetBuffer.readDouble());
        this.mountPosSpace = CoordinateSpaceType.values()[packetBuffer.readInt()];
        this.referencePos = packetBuffer.readBoolean() ? packetBuffer.func_179259_c() : null;
    }

    Optional<BlockPos> getReferencePos() {
        return Optional.ofNullable(this.referencePos);
    }

    public Optional<PhysicsObject> getMountedShip() {
        if (this.referencePos != null) {
            return ValkyrienUtils.getPhysicsObject(this.field_70170_p, this.referencePos, false);
        }
        return Optional.empty();
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            passenger.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }
}

