/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.math;

@Deprecated
public class Quaternion {
    private double x;
    private double y;
    private double z;
    private double w;

    public Quaternion(double xx, double yy, double zz, double ww) {
        this.x = xx;
        this.y = yy;
        this.z = zz;
        this.w = ww;
    }

    private Quaternion() {
    }

    public static Quaternion QuaternionFromMatrix(double[] matrix) {
        Quaternion q = new Quaternion();
        q.w = Math.sqrt(Math.max(0.0, 1.0 + matrix[0] + matrix[5] + matrix[10])) / 2.0;
        q.x = Math.sqrt(Math.max(0.0, 1.0 + matrix[0] - matrix[5] - matrix[10])) / 2.0;
        q.y = Math.sqrt(Math.max(0.0, 1.0 - matrix[0] + matrix[5] - matrix[10])) / 2.0;
        q.z = Math.sqrt(Math.max(0.0, 1.0 - matrix[0] - matrix[5] + matrix[10])) / 2.0;
        q.x *= Math.signum(q.x * (matrix[6] - matrix[9]));
        q.y *= Math.signum(q.y * (matrix[8] - matrix[2]));
        q.z *= Math.signum(q.z * (matrix[1] - matrix[4]));
        return q;
    }

    public static Quaternion slerpInterpolate(Quaternion old, Quaternion newOne, double timeStep) {
        boolean makeNegative;
        double dotProduct = Quaternion.dotProduct(old, newOne);
        boolean bl = makeNegative = dotProduct < 0.0;
        if (makeNegative) {
            old.x *= -1.0;
            old.y *= -1.0;
            old.z *= -1.0;
            old.w *= -1.0;
            dotProduct *= -1.0;
        }
        double betweenAngle = Math.acos(dotProduct);
        double sinMod = Math.sin((float)betweenAngle);
        double oldMod = 1.0 - timeStep;
        double newMod = timeStep;
        if (Math.abs(sinMod) > 0.0) {
            oldMod = Math.sin(oldMod * betweenAngle) / sinMod;
            newMod = Math.sin(timeStep * betweenAngle) / sinMod;
        }
        Quaternion betweenQuat = new Quaternion(old.x * oldMod + newOne.x * newMod, old.y * oldMod + newOne.y * newMod, old.z * oldMod + newOne.z * newMod, old.w * oldMod + newOne.w * newMod);
        double betweenLength = Math.sqrt(betweenQuat.x * betweenQuat.x + betweenQuat.y * betweenQuat.y + betweenQuat.z * betweenQuat.z + betweenQuat.w * betweenQuat.w);
        betweenQuat.x /= betweenLength;
        betweenQuat.y /= betweenLength;
        betweenQuat.z /= betweenLength;
        betweenQuat.w /= betweenLength;
        if (makeNegative) {
            old.x *= -1.0;
            old.y *= -1.0;
            old.z *= -1.0;
            old.w *= -1.0;
        }
        return betweenQuat;
    }

    public static double dotProduct(Quaternion first, Quaternion second) {
        return first.x * second.x + first.y * second.y + first.z * second.z + first.w * second.w;
    }

    public double[] toRadians() {
        double sqw = this.w * this.w;
        double sqx = this.x * this.x;
        double sqy = this.y * this.y;
        double sqz = this.z * this.z;
        double pitch = -Math.atan2(2.0 * (this.y * this.z + this.x * this.w), -sqx - sqy + sqz + sqw);
        double yaw = -Math.asin(-2.0 * (this.x * this.z - this.y * this.w) / (sqx + sqy + sqz + sqw));
        double roll = -Math.atan2(2.0 * (this.x * this.y + this.z * this.w), sqx - sqy - sqz + sqw);
        sqw = this.x * this.y + this.z * this.w;
        if (sqw > 0.9) {
            System.out.println("Quaternion singularity at North Pole");
            roll = 2.0 * Math.atan2(this.x, this.w);
            yaw = 1.5707963267948966;
            pitch = 0.0;
        }
        if (sqw < -0.9) {
            System.out.println("Quaternion singularity at South Pole");
            roll = -2.0 * Math.atan2(this.x, this.w);
            yaw = -1.5707963267948966;
            pitch = 0.0;
        }
        return new double[]{pitch, yaw, roll};
    }

    public void multiply(Quaternion q1) {
        double oldw = this.w;
        double oldx = this.x;
        double oldy = this.y;
        double oldz = this.z;
        this.w = oldw * q1.w - oldx * q1.x - oldy * q1.y - oldz * q1.z;
        this.x = oldw * q1.x + q1.w * oldx + oldy * q1.z - oldz * q1.y;
        this.y = oldw * q1.y + q1.w * oldy - oldx * q1.z + oldz * q1.x;
        this.z = oldw * q1.z + q1.w * oldz + oldx * q1.y - oldy * q1.x;
        oldw = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        if (Math.abs(1.0 - oldw) > 0.001) {
            oldw = Math.sqrt(oldw);
            this.w /= oldw;
            this.x /= oldw;
            this.y /= oldw;
            this.z /= oldw;
        }
    }

    public Quaternion crossProduct(Quaternion other) {
        Quaternion toReturn = new Quaternion(this.x, this.y, this.z, this.w);
        toReturn.multiply(other);
        return toReturn;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }
}

