/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.math;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.util.math.AxisAlignedBB;
import org.valkyrienskies.mod.common.coordinates.ISubspacedEntity;
import org.valkyrienskies.mod.common.coordinates.ShipTransform;
import org.valkyrienskies.mod.common.coordinates.VectorImmutable;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.VSMath;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.collision.polygons.Polygon;
import valkyrienwarfare.api.TransformType;

public class RotationMatrices {
    public static double[] getTranslationMatrix(double x, double y, double z) {
        double[] matrix = RotationMatrices.getDoubleIdentity();
        matrix[3] = x;
        matrix[7] = y;
        matrix[11] = z;
        return matrix;
    }

    public static double[] rotateAndTranslate(double[] input, double pitch, double yaw, double roll, Vector localOrigin) {
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getRotationMatrix(1.0, 0.0, 0.0, Math.toRadians(pitch)));
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getRotationMatrix(0.0, 1.0, 0.0, Math.toRadians(yaw)));
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getRotationMatrix(0.0, 0.0, 1.0, Math.toRadians(roll)));
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getTranslationMatrix(-localOrigin.X, -localOrigin.Y, -localOrigin.Z));
        return input;
    }

    public static double[] getRotationMatrix(double pitch, double yaw, double roll) {
        double[] input = RotationMatrices.getRotationMatrix(1.0, 0.0, 0.0, Math.toRadians(pitch));
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getRotationMatrix(0.0, 1.0, 0.0, Math.toRadians(yaw)));
        input = RotationMatrices.getMatrixProduct(input, RotationMatrices.getRotationMatrix(0.0, 0.0, 1.0, Math.toRadians(roll)));
        return input;
    }

    public static double[] getRotationMatrix(double ux, double uy, double uz, double angle) {
        if (ux == 0.0 && uy == 0.0 && uz == 0.0) {
            return RotationMatrices.getDoubleIdentity();
        }
        double C = Math.cos(angle);
        double S = Math.sin(angle);
        double t = 1.0 - C;
        double axismag = Math.sqrt(ux * ux + uy * uy + uz * uz);
        double[] matrix = RotationMatrices.getDoubleIdentity();
        matrix[0] = t * (ux /= axismag) * ux + C;
        matrix[1] = t * ux * (uy /= axismag) - S * (uz /= axismag);
        matrix[2] = t * ux * uz + S * uy;
        matrix[4] = t * ux * uy + S * uz;
        matrix[5] = t * uy * uy + C;
        matrix[6] = t * uy * uz - S * ux;
        matrix[8] = t * ux * uz - S * uy;
        matrix[9] = t * uy * uz + S * ux;
        matrix[10] = t * uz * uz + C;
        return matrix;
    }

    public static double[] getDoubleIdentity() {
        return new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    }

    public static double[] getZeroMatrix(int size) {
        return new double[size * size];
    }

    public static double[] getMatrixProduct(double[] M1, double[] M2) {
        double[] product = new double[]{M1[0] * M2[0] + M1[1] * M2[4] + M1[2] * M2[8] + M1[3] * M2[12], M1[0] * M2[1] + M1[1] * M2[5] + M1[2] * M2[9] + M1[3] * M2[13], M1[0] * M2[2] + M1[1] * M2[6] + M1[2] * M2[10] + M1[3] * M2[14], M1[0] * M2[3] + M1[1] * M2[7] + M1[2] * M2[11] + M1[3] * M2[15], M1[4] * M2[0] + M1[5] * M2[4] + M1[6] * M2[8] + M1[7] * M2[12], M1[4] * M2[1] + M1[5] * M2[5] + M1[6] * M2[9] + M1[7] * M2[13], M1[4] * M2[2] + M1[5] * M2[6] + M1[6] * M2[10] + M1[7] * M2[14], M1[4] * M2[3] + M1[5] * M2[7] + M1[6] * M2[11] + M1[7] * M2[15], M1[8] * M2[0] + M1[9] * M2[4] + M1[10] * M2[8] + M1[11] * M2[12], M1[8] * M2[1] + M1[9] * M2[5] + M1[10] * M2[9] + M1[11] * M2[13], M1[8] * M2[2] + M1[9] * M2[6] + M1[10] * M2[10] + M1[11] * M2[14], M1[8] * M2[3] + M1[9] * M2[7] + M1[10] * M2[11] + M1[11] * M2[15], M1[12] * M2[0] + M1[13] * M2[4] + M1[14] * M2[8] + M1[15] * M2[12], M1[12] * M2[1] + M1[13] * M2[5] + M1[14] * M2[9] + M1[15] * M2[13], M1[12] * M2[2] + M1[13] * M2[6] + M1[14] * M2[10] + M1[15] * M2[14], M1[12] * M2[3] + M1[13] * M2[7] + M1[14] * M2[11] + M1[15] * M2[15]};
        return product;
    }

    public static void applyTransform(double[] M, Vector vec) {
        double x = vec.X;
        double y = vec.Y;
        double z = vec.Z;
        vec.X = x * M[0] + y * M[1] + z * M[2] + M[3];
        vec.Y = x * M[4] + y * M[5] + z * M[6] + M[7];
        vec.Z = x * M[8] + y * M[9] + z * M[10] + M[11];
    }

    @Deprecated
    public static void applyTransform(ShipTransform shipTransform, Entity entity, TransformType transformType) {
        if (entity instanceof PhysicsWrapperEntity) {
            throw new IllegalArgumentException("Tried applying a transform to the PhysicsWrapeerEntity, this creates instability so we crash here!");
        }
        ISubspacedEntity entitySubspaceTracker = (ISubspacedEntity)entity;
        Vector entityPos = new Vector(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        Vector entityLook = new Vector(entity.func_70676_i(1.0f));
        Vector entityMotion = new Vector(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
        if (entity instanceof EntityFireball) {
            EntityFireball ball = (EntityFireball)entity;
            entityMotion.X = ball.field_70232_b;
            entityMotion.Y = ball.field_70233_c;
            entityMotion.Z = ball.field_70230_d;
        }
        shipTransform.transform(entityPos, transformType);
        shipTransform.rotate(entityLook, transformType);
        shipTransform.rotate(entityMotion, transformType);
        entityLook.normalize();
        if (entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            living.field_70759_as = entity.field_70177_z;
            living.field_70758_at = entity.field_70177_z;
        }
        VectorImmutable entityLookImmutable = entityLook.toImmutable();
        double pitch = VSMath.getPitchFromVectorImmutable(entityLookImmutable);
        double yaw = VSMath.getYawFromVectorImmutable(entityLookImmutable, pitch);
        entity.field_70177_z = (float)yaw;
        entity.field_70125_A = (float)pitch;
        if (entity instanceof EntityFireball) {
            EntityFireball ball = (EntityFireball)entity;
            ball.field_70232_b = entityMotion.X;
            ball.field_70233_c = entityMotion.Y;
            ball.field_70230_d = entityMotion.Z;
        }
        entity.field_70159_w = entityMotion.X;
        entity.field_70181_x = entityMotion.Y;
        entity.field_70179_y = entityMotion.Z;
        AxisAlignedBB playerBB = entity.func_174813_aQ();
        Polygon playerBBPoly = new Polygon(playerBB, shipTransform, transformType);
        entity.func_70107_b(entityPos.X, entityPos.Y, entityPos.Z);
        entity.func_174826_a(playerBBPoly.getEnclosedAABB());
    }

    public static void applyTransform3by3(double[] M, Vector vec) {
        double xx = vec.X;
        double yy = vec.Y;
        double zz = vec.Z;
        vec.X = xx * M[0] + yy * M[1] + zz * M[2];
        vec.Y = xx * M[3] + yy * M[4] + zz * M[5];
        vec.Z = xx * M[6] + yy * M[7] + zz * M[8];
    }

    public static void doRotationOnly(double[] M, Vector vec) {
        double x = vec.X;
        double y = vec.Y;
        double z = vec.Z;
        vec.X = x * M[0] + y * M[1] + z * M[2];
        vec.Y = x * M[4] + y * M[5] + z * M[6];
        vec.Z = x * M[8] + y * M[9] + z * M[10];
    }

    public static Vector get3by3TransformedVec(double[] M, Vector v) {
        Vector vec = new Vector(v);
        RotationMatrices.applyTransform3by3(M, vec);
        return vec;
    }

    public static double[] inverse3by3(double[] matrix) {
        double[] inverse = new double[9];
        inverse[0] = matrix[4] * matrix[8] - matrix[5] * matrix[7];
        inverse[3] = matrix[5] * matrix[6] - matrix[3] * matrix[8];
        inverse[6] = matrix[3] * matrix[7] - matrix[4] * matrix[6];
        inverse[1] = matrix[2] * matrix[6] - matrix[1] * matrix[8];
        inverse[4] = matrix[0] * matrix[8] - matrix[2] * matrix[6];
        inverse[7] = matrix[6] * matrix[1] - matrix[0] * matrix[7];
        inverse[2] = matrix[1] * matrix[5] - matrix[2] * matrix[4];
        inverse[5] = matrix[2] * matrix[3] - matrix[0] * matrix[5];
        inverse[8] = matrix[0] * matrix[4] - matrix[1] * matrix[3];
        double det = matrix[0] * inverse[0] + matrix[1] * inverse[3] + matrix[2] * inverse[6];
        for (int i = 0; i < 9; i += 3) {
            int n = i;
            inverse[n] = inverse[n] / det;
            int n2 = i + 1;
            inverse[n2] = inverse[n2] / det;
            int n3 = i + 2;
            inverse[n3] = inverse[n3] / det;
        }
        return inverse;
    }

    public static double[] inverse(double[] matrix) {
        double[] inverse = new double[16];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                inverse[i * 4 + j] = matrix[i + j * 4];
            }
            inverse[i * 4 + 3] = -inverse[i * 4] * matrix[3] - inverse[i * 4 + 1] * matrix[7] - inverse[i * 4 + 2] * matrix[11];
        }
        inverse[12] = 0.0;
        inverse[13] = 0.0;
        inverse[14] = 0.0;
        inverse[15] = 1.0;
        return inverse;
    }
}

