/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.math;

import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;
import org.valkyrienskies.mod.common.coordinates.VectorImmutable;
import org.valkyrienskies.mod.common.math.Vector;

public class VSMath {
    public static final int AABB_MERGE_PASSES = 5;
    public static final double STANDING_TOLERANCE = 0.42;

    public static double getPitchFromVectorImmutable(VectorImmutable vec) {
        return -Math.asin(vec.getY()) * 180.0 / Math.PI;
    }

    public static double getYawFromVectorImmutable(VectorImmutable vec, double rotPitch) {
        double f2 = -Math.cos(-rotPitch * (Math.PI / 180));
        double yawFromRotVec = Math.atan2(vec.getX() / f2, vec.getZ() / f2);
        yawFromRotVec += Math.PI;
        return yawFromRotVec /= -0.01745329238474369;
    }

    public static double[] getMinMaxOfArray(double[] elements) {
        double[] minMax = new double[2];
        minMax[0] = minMax[1] = elements[elements.length - 1];
        for (int i = elements.length - 2; i >= 0; --i) {
            minMax[0] = Math.min(minMax[0], elements[i]);
            minMax[1] = Math.max(minMax[1], elements[i]);
        }
        return minMax;
    }

    public static boolean canStandOnNormal(Vector normal) {
        double radius = normal.X * normal.X + normal.Z * normal.Z;
        return radius < 0.42;
    }

    public static void mergeAABBList(List<AxisAlignedBB> toFuse) {
        boolean changed = true;
        int passes = 0;
        while (changed && passes < 5) {
            changed = false;
            ++passes;
            for (int i = 0; i < toFuse.size(); ++i) {
                AxisAlignedBB bb = toFuse.get(i);
                for (int j = i + 1; j < toFuse.size(); ++j) {
                    AxisAlignedBB nextOne = toFuse.get(j);
                    if (!VSMath.connected(bb, nextOne)) continue;
                    AxisAlignedBB fused = VSMath.getFusedBoundingBox(bb, nextOne);
                    toFuse.remove(j);
                    toFuse.remove(i);
                    toFuse.add(fused);
                    j = toFuse.size();
                    changed = true;
                }
            }
        }
    }

    private static AxisAlignedBB getFusedBoundingBox(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        double mnX = bb1.field_72340_a;
        double mnY = bb1.field_72338_b;
        double mnZ = bb1.field_72339_c;
        double mxX = bb1.field_72336_d;
        double mxY = bb1.field_72337_e;
        double mxZ = bb1.field_72334_f;
        if (bb2.field_72340_a < mnX) {
            mnX = bb2.field_72340_a;
        }
        if (bb2.field_72338_b < mnY) {
            mnY = bb2.field_72338_b;
        }
        if (bb2.field_72339_c < mnZ) {
            mnZ = bb2.field_72339_c;
        }
        if (bb2.field_72336_d > mxX) {
            mxX = bb2.field_72336_d;
        }
        if (bb2.field_72337_e > mxY) {
            mxY = bb2.field_72337_e;
        }
        if (bb2.field_72334_f > mxZ) {
            mxZ = bb2.field_72334_f;
        }
        return new AxisAlignedBB(mnX, mnY, mnZ, mxX, mxY, mxZ);
    }

    private static boolean connected(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return VSMath.connectedInX(bb1, bb2) || VSMath.connectedInY(bb1, bb2) || VSMath.connectedInZ(bb1, bb2);
    }

    private static boolean connectedInX(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return VSMath.intersectInX(bb1, bb2) && VSMath.areXAligned(bb1, bb2);
    }

    private static boolean connectedInY(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return VSMath.intersectInY(bb1, bb2) && VSMath.areYAligned(bb1, bb2);
    }

    private static boolean connectedInZ(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return VSMath.intersectInZ(bb1, bb2) && VSMath.areZAligned(bb1, bb2);
    }

    private static boolean intersectInX(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72336_d >= bb2.field_72340_a && bb1.field_72336_d < bb2.field_72336_d || bb1.field_72340_a > bb2.field_72340_a && bb1.field_72340_a <= bb2.field_72336_d;
    }

    private static boolean intersectInY(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72337_e >= bb2.field_72338_b && bb1.field_72337_e < bb2.field_72337_e || bb1.field_72338_b > bb2.field_72338_b && bb1.field_72338_b <= bb2.field_72337_e;
    }

    private static boolean intersectInZ(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72334_f >= bb2.field_72339_c && bb1.field_72334_f < bb2.field_72334_f || bb1.field_72339_c > bb2.field_72339_c && bb1.field_72339_c <= bb2.field_72334_f;
    }

    private static boolean areXAligned(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72338_b == bb2.field_72338_b && bb1.field_72339_c == bb2.field_72339_c && bb1.field_72337_e == bb2.field_72337_e && bb1.field_72334_f == bb2.field_72334_f;
    }

    private static boolean areYAligned(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72340_a == bb2.field_72340_a && bb1.field_72339_c == bb2.field_72339_c && bb1.field_72336_d == bb2.field_72336_d && bb1.field_72334_f == bb2.field_72334_f;
    }

    private static boolean areZAligned(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72340_a == bb2.field_72340_a && bb1.field_72338_b == bb2.field_72338_b && bb1.field_72336_d == bb2.field_72336_d && bb1.field_72337_e == bb2.field_72337_e;
    }

    public static double interpolateModulatedNumbers(double prev, double current, double partialStep, double modulus) {
        double deltaBackward;
        double delta = current - prev;
        double deltaForward = VSMath.calculateRemainder(delta, modulus);
        double shortestDelta = deltaForward < -(deltaBackward = deltaForward - modulus) ? deltaForward : deltaBackward;
        double interpolatedButPossiblyNegative = prev + shortestDelta * partialStep;
        return VSMath.calculateRemainder(interpolatedButPossiblyNegative, modulus);
    }

    private static double calculateRemainder(double dividend, double divisor) {
        double remainder = dividend % divisor;
        if (remainder < 0.0) {
            remainder += divisor;
        }
        return remainder;
    }
}

