/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.math;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.valkyrienskies.mod.common.coordinates.VectorImmutable;
import org.valkyrienskies.mod.common.math.RotationMatrices;

public class Vector {
    public double X;
    public double Y;
    public double Z;

    public Vector(double x, double y, double z) {
        this.X = x;
        this.Y = y;
        this.Z = z;
    }

    public Vector() {
    }

    public Vector(VectorImmutable vec) {
        this(vec.getX(), vec.getY(), vec.getZ());
    }

    public Vector(double x, double y, double z, double[] rotationMatrix) {
        this(x, y, z);
        this.transform(rotationMatrix);
    }

    public Vector(Vector v) {
        this(v.X, v.Y, v.Z);
    }

    public Vector(Vector v, double scale) {
        this(v);
        this.multiply(scale);
    }

    public Vector(Vec3d vec3) {
        this(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
    }

    public Vector(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public Vector(ByteBuf toRead) {
        this(toRead.readDouble(), toRead.readDouble(), toRead.readDouble());
    }

    public Vector(Vector theNormal, double[] matrixTransform) {
        this(theNormal.X, theNormal.Y, theNormal.Z, matrixTransform);
    }

    public Vector(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                this.Y = 1.0;
                break;
            }
            case UP: {
                this.Y = -1.0;
                break;
            }
            case EAST: {
                this.X = -1.0;
                break;
            }
            case NORTH: {
                this.Z = 1.0;
                break;
            }
            case WEST: {
                this.X = 1.0;
                break;
            }
            case SOUTH: {
                this.Z = -1.0;
            }
        }
    }

    public Vector(Vec3i directionVec) {
        this(directionVec.func_177958_n(), directionVec.func_177956_o(), directionVec.func_177952_p());
    }

    public static Vector[] generateAxisAlignedNorms() {
        Vector[] norms = new Vector[]{new Vector(1.0, 0.0, 0.0), new Vector(0.0, 1.0, 0.0), new Vector(0.0, 0.0, 1.0)};
        return norms;
    }

    public Vector getSubtraction(Vector v) {
        return new Vector(v.X - this.X, v.Y - this.Y, v.Z - this.Z);
    }

    public Vector getAddition(Vector v) {
        return new Vector(v.X + this.X, v.Y + this.Y, v.Z + this.Z);
    }

    public void subtract(Vector v) {
        this.subtract(v.X, v.Y, v.Z);
    }

    public void subtract(double x, double y, double z) {
        this.X -= x;
        this.Y -= y;
        this.Z -= z;
    }

    public void add(Vector v) {
        this.add(v.X, v.Y, v.Z);
    }

    public void add(double x, double y, double z) {
        this.X += x;
        this.Y += y;
        this.Z += z;
    }

    public double dot(Vector v) {
        return this.X * v.X + this.Y * v.Y + this.Z * v.Z;
    }

    public Vector cross(Vector v) {
        return new Vector(this.Y * v.Z - v.Y * this.Z, this.Z * v.X - this.X * v.Z, this.X * v.Y - v.X * this.Y);
    }

    public void setCross(Vector v1, Vector v2) {
        this.X = v1.Y * v2.Z - v2.Y * v1.Z;
        this.Y = v1.Z * v2.X - v1.X * v2.Z;
        this.Z = v1.X * v2.Y - v2.X * v1.Y;
    }

    public void multiply(double scale) {
        this.X *= scale;
        this.Y *= scale;
        this.Z *= scale;
    }

    public void divide(double scale) {
        this.X /= scale;
        this.Y /= scale;
        this.Z /= scale;
    }

    public Vector getProduct(double scale) {
        return new Vector(this.X * scale, this.Y * scale, this.Z * scale);
    }

    public Vec3d toVec3d() {
        return new Vec3d(this.X, this.Y, this.Z);
    }

    public void normalize() {
        double length = this.length();
        if (length > 1.0E-6) {
            this.divide(length);
        } else {
            this.zero();
        }
    }

    public double length() {
        return Math.sqrt(this.lengthSq());
    }

    public double lengthSq() {
        return this.X * this.X + this.Y * this.Y + this.Z * this.Z;
    }

    public boolean isZero() {
        return this.lengthSq() < 1.0E-12;
    }

    public void zero() {
        this.Z = 0.0;
        this.Y = 0.0;
        this.X = 0.0;
    }

    public void roundToWhole() {
        this.X = Math.round(this.X);
        this.Y = Math.round(this.Y);
        this.Z = Math.round(this.Z);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Vector) {
            Vector vec = (Vector)other;
            return vec.X == this.X && vec.Y == this.Y && vec.Z == this.Z;
        }
        return false;
    }

    public String toString() {
        String coords = "<" + this.X + ", " + this.Y + ", " + this.Z + ">";
        return coords;
    }

    public Vector crossAndUnit(Vector v) {
        Vector crossProduct = this.cross(v);
        crossProduct.normalize();
        return crossProduct;
    }

    public void writeToByteBuf(ByteBuf toWrite) {
        toWrite.writeDouble(this.X);
        toWrite.writeDouble(this.Y);
        toWrite.writeDouble(this.Z);
    }

    public void setSubtraction(Vector inLocal, Vector centerCoord) {
        this.X = inLocal.X - centerCoord.X;
        this.Y = inLocal.Y - centerCoord.Y;
        this.Z = inLocal.Z - centerCoord.Z;
    }

    public void transform(double[] rotationMatrix) {
        RotationMatrices.applyTransform(rotationMatrix, this);
    }

    public void setValue(double x, double y, double z) {
        this.X = x;
        this.Y = y;
        this.Z = z;
    }

    public void setValue(Vector toCopy) {
        this.setValue(toCopy.X, toCopy.Y, toCopy.Z);
    }

    public void setValue(Vec3d toCopy) {
        this.setValue(toCopy.field_72450_a, toCopy.field_72448_b, toCopy.field_72449_c);
    }

    public double angleBetween(Vector other) {
        double dotProduct = this.dot(other);
        double normalizedDotProduct = dotProduct / (this.length() * other.length());
        return Math.acos(normalizedDotProduct);
    }

    public VectorImmutable toImmutable() {
        return new VectorImmutable(this);
    }

    public boolean isNaN() {
        return Double.isNaN(this.X) || Double.isNaN(this.Y) || Double.isNaN(this.Z);
    }
}

