/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.multithreaded;

import net.minecraft.util.math.AxisAlignedBB;
import org.valkyrienskies.mod.common.coordinates.ShipTransform;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.collision.polygons.Polygon;
import valkyrienwarfare.api.TransformType;

public class PhysicsShipTransform
extends ShipTransform {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final double pitch;
    private final double yaw;
    private final double roll;
    private final Vector centerOfMass;
    private final AxisAlignedBB shipBoundingBox;

    public PhysicsShipTransform(double physX, double physY, double physZ, double physPitch, double physYaw, double physRoll, Vector physCenterOfMass, AxisAlignedBB gameTickShipBoundingBox, ShipTransform gameTickTransform) {
        super(physX, physY, physZ, physPitch, physYaw, physRoll, physCenterOfMass);
        this.posX = physX;
        this.posY = physY;
        this.posZ = physZ;
        this.pitch = physPitch;
        this.yaw = physYaw;
        this.roll = physRoll;
        this.centerOfMass = new Vector(physCenterOfMass);
        this.shipBoundingBox = this.createApproxBoundingBox(gameTickShipBoundingBox, gameTickTransform);
    }

    private AxisAlignedBB createApproxBoundingBox(AxisAlignedBB gameTickBB, ShipTransform gameTickTransform) {
        Polygon gameTickBBPoly = new Polygon(gameTickBB);
        gameTickBBPoly.transform(gameTickTransform, TransformType.GLOBAL_TO_SUBSPACE);
        gameTickBBPoly.transform(this, TransformType.SUBSPACE_TO_GLOBAL);
        return gameTickBBPoly.getEnclosedAABB();
    }

    public double getPosX() {
        return this.posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public double getPosZ() {
        return this.posZ;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getRoll() {
        return this.roll;
    }

    public Vector getCenterOfMass() {
        return this.centerOfMass;
    }

    public AxisAlignedBB getShipBoundingBox() {
        return this.shipBoundingBox;
    }
}

