/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.multithreaded;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="valkyrienskies")
public class TickSyncCompletableFuture<T> {
    private CompletableFuture<T> base;
    private boolean isRegistered = false;

    private TickSyncCompletableFuture(CompletableFuture<T> future) {
        this.base = future;
    }

    public TickSyncCompletableFuture() {
        this(new CompletableFuture());
    }

    public static <U> TickSyncCompletableFuture<U> from(CompletableFuture<U> future) {
        return new TickSyncCompletableFuture<U>(future);
    }

    private static Supplier<Void> runnableToSupplier(Runnable runnable) {
        return () -> {
            runnable.run();
            return null;
        };
    }

    private static <K> Function<K, Void> runnableToFunction(Runnable runnable) {
        return k -> {
            runnable.run();
            return null;
        };
    }

    private static <K> Function<K, Void> consumerToFunction(Consumer<K> consumer) {
        return k -> {
            consumer.accept(k);
            return null;
        };
    }

    private static <T, R> Callable<R> functionToCallable(Function<T, R> function, T value) {
        return () -> function.apply(value);
    }

    private static <K> TickSyncCompletableFuture<K> toCompletableFuture(ListenableFuture<K> listenableFuture) {
        final TickSyncCompletableFuture completableFuture = new TickSyncCompletableFuture();
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<K>(){

            public void onFailure(@Nonnull Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }

            public void onSuccess(K t) {
                completableFuture.complete(t);
            }
        });
        return completableFuture;
    }

    public static <K> TickSyncCompletableFuture<Object> supplyTickSync(Supplier<K> supplier, IThreadListener gameThread) {
        return TickSyncCompletableFuture.toCompletableFuture(gameThread.func_152344_a(supplier::get));
    }

    public static TickSyncCompletableFuture<Object> runTickSync(Runnable runnable, IThreadListener gameThread) {
        return TickSyncCompletableFuture.supplyTickSync(TickSyncCompletableFuture.runnableToSupplier(runnable), gameThread);
    }

    public <K> TickSyncCompletableFuture<K> thenApplyTickSync(Function<? super T, ? extends K> action, IThreadListener gameThread) {
        TickSyncCompletableFuture toReturn = new TickSyncCompletableFuture();
        this.base.thenAccept(result -> gameThread.func_152344_a(() -> toReturn.complete(action.apply(result))));
        return toReturn;
    }

    public TickSyncCompletableFuture<Void> thenAcceptTickSync(Consumer<? super T> action, IThreadListener gameThread) {
        return this.thenApplyTickSync(TickSyncCompletableFuture.consumerToFunction(action), gameThread);
    }

    public TickSyncCompletableFuture<Void> thenRunTickSync(Runnable action, IThreadListener gameThread) {
        return this.thenApplyTickSync(TickSyncCompletableFuture.runnableToFunction(action), gameThread);
    }

    public <U> TickSyncCompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return TickSyncCompletableFuture.from(this.base.thenApply(fn));
    }

    public <U> TickSyncCompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return TickSyncCompletableFuture.from(this.base.thenApplyAsync(fn));
    }

    public <U> TickSyncCompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return TickSyncCompletableFuture.from(this.base.thenApplyAsync(fn, executor));
    }

    public TickSyncCompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return TickSyncCompletableFuture.from(this.base.thenAccept((Consumer)action));
    }

    public TickSyncCompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return TickSyncCompletableFuture.from(this.base.thenAcceptAsync((Consumer)action));
    }

    public TickSyncCompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return TickSyncCompletableFuture.from(this.base.thenAcceptAsync((Consumer)action, executor));
    }

    public TickSyncCompletableFuture<Void> thenRun(Runnable action) {
        return TickSyncCompletableFuture.from(this.base.thenRun(action));
    }

    public TickSyncCompletableFuture<Void> thenRunAsync(Runnable action) {
        return TickSyncCompletableFuture.from(this.base.thenRunAsync(action));
    }

    public TickSyncCompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return TickSyncCompletableFuture.from(this.base.thenRunAsync(action, executor));
    }

    public <U, V> TickSyncCompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return TickSyncCompletableFuture.from(this.base.thenCombine(other, fn));
    }

    public <U, V> TickSyncCompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return TickSyncCompletableFuture.from(this.base.thenCombineAsync(other, fn));
    }

    public <U, V> TickSyncCompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return TickSyncCompletableFuture.from(this.base.thenCombineAsync(other, fn, executor));
    }

    public <U> TickSyncCompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return TickSyncCompletableFuture.from(this.base.thenAcceptBoth(other, (BiConsumer)action));
    }

    public <U> TickSyncCompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return TickSyncCompletableFuture.from(this.base.thenAcceptBothAsync(other, (BiConsumer)action));
    }

    public <U> TickSyncCompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return TickSyncCompletableFuture.from(this.base.thenAcceptBothAsync(other, (BiConsumer)action, executor));
    }

    public TickSyncCompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return TickSyncCompletableFuture.from(this.base.runAfterBoth((CompletionStage)other, action));
    }

    public TickSyncCompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return TickSyncCompletableFuture.from(this.base.runAfterBothAsync((CompletionStage)other, action));
    }

    public TickSyncCompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return TickSyncCompletableFuture.from(this.base.runAfterBothAsync((CompletionStage)other, action, executor));
    }

    public <U> TickSyncCompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return TickSyncCompletableFuture.from(this.base.applyToEither((CompletionStage)other, fn));
    }

    public <U> TickSyncCompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return TickSyncCompletableFuture.from(this.base.applyToEitherAsync((CompletionStage)other, fn));
    }

    public <U> TickSyncCompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return TickSyncCompletableFuture.from(this.base.applyToEitherAsync((CompletionStage)other, fn, executor));
    }

    public TickSyncCompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return TickSyncCompletableFuture.from(this.base.acceptEither((CompletionStage)other, (Consumer)action));
    }

    public TickSyncCompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return TickSyncCompletableFuture.from(this.base.acceptEitherAsync((CompletionStage)other, (Consumer)action));
    }

    public TickSyncCompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return TickSyncCompletableFuture.from(this.base.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor));
    }

    public TickSyncCompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return TickSyncCompletableFuture.from(this.base.runAfterEither((CompletionStage)other, action));
    }

    public TickSyncCompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return TickSyncCompletableFuture.from(this.base.runAfterEitherAsync((CompletionStage)other, action));
    }

    public TickSyncCompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return TickSyncCompletableFuture.from(this.base.runAfterEitherAsync((CompletionStage)other, action, executor));
    }

    public <U> TickSyncCompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return TickSyncCompletableFuture.from(this.base.thenCompose(fn));
    }

    public <U> TickSyncCompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return TickSyncCompletableFuture.from(this.base.thenComposeAsync(fn));
    }

    public <U> TickSyncCompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return TickSyncCompletableFuture.from(this.base.thenComposeAsync(fn, executor));
    }

    public TickSyncCompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return TickSyncCompletableFuture.from(this.base.whenComplete(action));
    }

    public TickSyncCompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return TickSyncCompletableFuture.from(this.base.whenCompleteAsync(action));
    }

    public TickSyncCompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return TickSyncCompletableFuture.from(this.base.whenCompleteAsync(action, executor));
    }

    public <U> TickSyncCompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return TickSyncCompletableFuture.from(this.base.handle(fn));
    }

    public <U> TickSyncCompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return TickSyncCompletableFuture.from(this.base.handleAsync(fn));
    }

    public <U> TickSyncCompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return TickSyncCompletableFuture.from(this.base.handleAsync(fn, executor));
    }

    public static <U> TickSyncCompletableFuture<U> supplyAsync(Supplier<U> action) {
        return TickSyncCompletableFuture.from(CompletableFuture.supplyAsync(action));
    }

    public static <U> TickSyncCompletableFuture<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        return TickSyncCompletableFuture.from(CompletableFuture.supplyAsync(supplier, executor));
    }

    public static TickSyncCompletableFuture<Void> runAsync(Runnable runnable) {
        return TickSyncCompletableFuture.from(CompletableFuture.runAsync(runnable));
    }

    public static TickSyncCompletableFuture<Void> runAsync(Runnable runnable, Executor executor) {
        return TickSyncCompletableFuture.from(CompletableFuture.runAsync(runnable, executor));
    }

    public static <U> TickSyncCompletableFuture<U> completedFuture(U value) {
        return TickSyncCompletableFuture.from(CompletableFuture.completedFuture(value));
    }

    public boolean isDone() {
        return this.base.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return this.base.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.base.get(timeout, unit);
    }

    public T join() {
        return this.base.join();
    }

    public T getNow(T valueIfAbsent) {
        return this.base.getNow(valueIfAbsent);
    }

    public boolean completeExceptionally(Throwable ex) {
        return this.base.completeExceptionally(ex);
    }

    public CompletableFuture<T> toCompletableFuture() {
        return this.base.toCompletableFuture();
    }

    public TickSyncCompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return TickSyncCompletableFuture.from(this.base.exceptionally(fn));
    }

    public static TickSyncCompletableFuture<Void> allOf(CompletableFuture<?> ... cfs) {
        return TickSyncCompletableFuture.from(CompletableFuture.allOf(cfs));
    }

    public static TickSyncCompletableFuture<Object> anyOf(CompletableFuture<?> ... cfs) {
        return TickSyncCompletableFuture.from(CompletableFuture.anyOf(cfs));
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.base.cancel(mayInterruptIfRunning);
    }

    public boolean complete(T value) {
        return this.base.complete(value);
    }

    public boolean isCancelled() {
        return this.base.isCancelled();
    }

    public boolean isCompletedExceptionally() {
        return this.base.isCompletedExceptionally();
    }

    public void obtrudeValue(T value) {
        this.base.obtrudeValue(value);
    }

    public void obtrudeException(Throwable ex) {
        this.base.obtrudeException(ex);
    }

    public int getNumberOfDependents() {
        return this.base.getNumberOfDependents();
    }

    private static class CompletableSupplier<K> {
        Supplier<K> supplier;
        CompletableFuture<K> completable;

        CompletableSupplier(Supplier<K> supplier, CompletableFuture<K> completable) {
            this.supplier = supplier;
            this.completable = completable;
        }

        void complete() {
            this.completable.complete(this.supplier.get());
        }
    }
}

