/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.multithreaded;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeWorldProvider;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.physics.collision.optimization.ShipCollisionTask;
import org.valkyrienskies.mod.common.physics.management.WorldPhysObjectManager;

public class VSThread
extends Thread {
    private static final Logger log = LogManager.getLogger(VSThread.class);
    private static final long NS_PER_TICK = 10000000L;
    private static final long MAX_LOST_TIME_NS = 1000000000L;
    private static final long TICK_TIME_QUEUE = 100L;
    private static int threadID = 0;
    private final World hostWorld;
    private final Queue<Long> latestPhysicsTickTimes;
    private int physicsTicksCount;
    private volatile boolean threadRunning;

    public VSThread(World host) {
        super("VS World Thread " + threadID);
        ++threadID;
        this.hostWorld = host;
        this.physicsTicksCount = 0;
        this.threadRunning = true;
        this.latestPhysicsTickTimes = new ConcurrentLinkedQueue<Long>();
        log.trace(this.getName() + " thread created.");
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean isSinglePlayerPaused() {
        return Minecraft.func_71410_x().func_147113_T();
    }

    @Override
    public void run() {
        long lostTickTime = 0L;
        while (this.threadRunning) {
            long startOfPhysicsTickTimeNano = System.nanoTime();
            if (lostTickTime > 1000000000L) {
                lostTickTime %= 1000000000L;
            }
            this.runGameLoop();
            long endOfPhysicsTickTimeNano = System.nanoTime();
            long deltaPhysicsTickTimeNano = endOfPhysicsTickTimeNano - startOfPhysicsTickTimeNano;
            try {
                long sleepTime = 10000000L - deltaPhysicsTickTimeNano;
                if (sleepTime > 0L) {
                    if (sleepTime > lostTickTime) {
                        lostTickTime = 0L;
                        VSThread.sleep((sleepTime -= lostTickTime) / 1000000L);
                    } else {
                        lostTickTime -= sleepTime;
                    }
                } else {
                    lostTickTime -= sleepTime;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            long endOfTickTimeFullNano = System.nanoTime();
            long deltaTickTimeFullNano = endOfTickTimeFullNano - startOfPhysicsTickTimeNano;
            this.latestPhysicsTickTimes.add(deltaTickTimeFullNano);
            if ((long)this.latestPhysicsTickTimes.size() <= 100L) continue;
            this.latestPhysicsTickTimes.poll();
        }
        log.trace(super.getName() + " killed");
    }

    private void runGameLoop() {
        MinecraftServer mcServer = this.hostWorld.func_73046_m();
        assert (mcServer != null);
        if (mcServer.func_71278_l()) {
            if (mcServer.func_71262_S()) {
                this.physicsTick();
            } else if (!VSThread.isSinglePlayerPaused()) {
                this.physicsTick();
            }
        }
    }

    private void physicsTick() {
        WorldPhysObjectManager manager = ValkyrienSkiesMod.VS_PHYSICS_MANAGER.getManagerForWorld(this.hostWorld);
        List<PhysicsWrapperEntity> physicsEntities = manager.getTickablePhysicsEntities();
        this.tickThePhysicsAndCollision(physicsEntities);
        this.tickSendUpdatesToPlayers(physicsEntities);
    }

    private void tickThePhysicsAndCollision(List<PhysicsWrapperEntity> shipsWithPhysics) {
        double newPhysSpeed = VSConfig.physSpeed;
        ArrayList<ShipCollisionTask> collisionTasks = new ArrayList<ShipCollisionTask>(shipsWithPhysics.size() * 2);
        for (PhysicsWrapperEntity wrapper : shipsWithPhysics) {
            if (wrapper.field_70148_d) continue;
            wrapper.getPhysicsObject().getPhysicsProcessor().rawPhysTickPreCol(newPhysSpeed);
            wrapper.getPhysicsObject().getPhysicsProcessor().getWorldCollision().tickUpdatingTheCollisionCache();
            wrapper.getPhysicsObject().getPhysicsProcessor().getWorldCollision().splitIntoCollisionTasks(collisionTasks);
        }
        IRotationNodeWorldProvider rotationNodeWorldProvider = (IRotationNodeWorldProvider)this.hostWorld;
        rotationNodeWorldProvider.getPhysicsRotationNodeWorld().processTorquePhysics(newPhysSpeed);
        try {
            ValkyrienSkiesMod.getPHYSICS_THREADS_EXECUTOR().invokeAll(collisionTasks);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (ShipCollisionTask task : collisionTasks) {
            PhysicsWrapperEntity wrapper = task.getToTask().getParent().getWrapperEntity();
            if (wrapper.field_70148_d) continue;
            task.getToTask().processCollisionTask(task);
        }
        for (PhysicsWrapperEntity wrapper : shipsWithPhysics) {
            if (!wrapper.field_70148_d) {
                try {
                    wrapper.getPhysicsObject().getPhysicsProcessor().rawPhysTickPostCol();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            wrapper.getPhysicsObject().getShipTransformationManager().updateAllTransforms(false, false, false);
        }
    }

    private void tickSendUpdatesToPlayers(List<PhysicsWrapperEntity> ships) {
        for (PhysicsWrapperEntity wrapper : ships) {
            wrapper.getPhysicsObject().getShipTransformationManager().sendPositionToPlayers(this.physicsTicksCount);
        }
        ++this.physicsTicksCount;
    }

    public void kill() {
        log.trace(super.getName() + " marked for death.");
        this.threadRunning = false;
    }

    public long getAveragePhysicsTickTimeNano() {
        if ((long)this.latestPhysicsTickTimes.size() >= 100L) {
            long average = 0L;
            for (Long tickTime : this.latestPhysicsTickTimes) {
                average += tickTime.longValue();
            }
            return average / 100L;
        }
        return 10000000L;
    }
}

