/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.network;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.valkyrienskies.mod.common.coordinates.ISubspacedEntity;
import org.valkyrienskies.mod.common.coordinates.ISubspacedEntityRecord;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.network.SubspacedEntityRecordMessage;
import org.valkyrienskies.mod.common.physmanagement.interaction.IDraggable;

public class SubspacedEntityRecordHandler
implements IMessageHandler<SubspacedEntityRecordMessage, IMessage> {
    public IMessage onMessage(SubspacedEntityRecordMessage message, MessageContext ctx) {
        IThreadListener threadScheduler = null;
        World world = null;
        if (ctx.side.isClient()) {
            threadScheduler = this.getClientThreadListener();
            world = this.getClientWorld();
        } else {
            threadScheduler = ctx.getServerHandler().field_147367_d;
            world = ctx.getServerHandler().field_147369_b.field_70170_p;
        }
        World worldFinal = world;
        threadScheduler.func_152344_a(() -> {
            Entity physicsEntity = worldFinal.func_73045_a(message.physicsObjectWrapperID);
            Entity subspacedEntity = worldFinal.func_73045_a(message.entitySubspacedID);
            if (physicsEntity != null && subspacedEntity != null) {
                PhysicsWrapperEntity wrapperEntity = (PhysicsWrapperEntity)physicsEntity;
                ISubspacedEntityRecord record = message.createRecordForThisMessage((ISubspacedEntity)subspacedEntity, wrapperEntity.getPhysicsObject().getSubspace());
                IDraggable draggable = (IDraggable)subspacedEntity;
                draggable.setForcedRelativeSubspace(wrapperEntity);
                wrapperEntity.getPhysicsObject().getSubspace().forceSubspaceRecord(record.getParentEntity(), record);
            } else {
                System.err.println("An incorrect SubspacedEntityRecordMessage has been thrown out");
            }
        });
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private IThreadListener getClientThreadListener() {
        return Minecraft.func_71410_x();
    }

    @SideOnly(value=Side.CLIENT)
    private World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }
}

