/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.valkyrienskies.mod.common.coordinates.CoordinateSpaceType;
import org.valkyrienskies.mod.common.coordinates.ISubspace;
import org.valkyrienskies.mod.common.coordinates.ISubspacedEntity;
import org.valkyrienskies.mod.common.coordinates.ISubspacedEntityRecord;
import org.valkyrienskies.mod.common.coordinates.ImplSubspacedEntityRecord;
import org.valkyrienskies.mod.common.coordinates.VectorImmutable;

public class SubspacedEntityRecordMessage
implements IMessage {
    public int physicsObjectWrapperID;
    public int entitySubspacedID;
    @Nullable
    public VectorImmutable position;
    @Nullable
    public VectorImmutable positionLastTick;
    @Nullable
    public VectorImmutable lookDirection;
    @Nullable
    public VectorImmutable velocity;
    @Nullable
    private ISubspacedEntityRecord subspacedEntityRecord;

    public SubspacedEntityRecordMessage(ISubspacedEntityRecord subspacedEntityRecord) {
        this.subspacedEntityRecord = subspacedEntityRecord;
    }

    public SubspacedEntityRecordMessage() {
    }

    public void fromBytes(ByteBuf buf) {
        this.physicsObjectWrapperID = buf.readInt();
        this.entitySubspacedID = buf.readInt();
        this.position = VectorImmutable.readFromByteBuf(buf);
        this.positionLastTick = VectorImmutable.readFromByteBuf(buf);
        this.lookDirection = VectorImmutable.readFromByteBuf(buf);
        this.velocity = VectorImmutable.readFromByteBuf(buf);
    }

    public void toBytes(ByteBuf buf) {
        if (this.subspacedEntityRecord.getParentSubspace().getSubspaceCoordinatesType() == CoordinateSpaceType.GLOBAL_COORDINATES) {
            throw new IllegalStateException("Just tried sending SubspacedEntityRecordMessage for a record that was made by the world subspace. This isn't right so we crash right here.");
        }
        buf.writeInt(this.subspacedEntityRecord.getParentSubspace().getSubspaceParentEntityID());
        buf.writeInt(this.subspacedEntityRecord.getParentEntity().getSubspacedEntityID());
        this.subspacedEntityRecord.getPosition().writeToByteBuf(buf);
        this.subspacedEntityRecord.getPositionLastTick().writeToByteBuf(buf);
        this.subspacedEntityRecord.getLookDirection().writeToByteBuf(buf);
        this.subspacedEntityRecord.getVelocity().writeToByteBuf(buf);
    }

    public ISubspacedEntityRecord createRecordForThisMessage(ISubspacedEntity entity, ISubspace provider) {
        return new ImplSubspacedEntityRecord(entity, provider, this.position, this.positionLastTick, this.lookDirection, this.velocity);
    }
}

