/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.valkyrienskies.mod.common.coordinates.ShipTransform;
import org.valkyrienskies.mod.common.entity.PhysicsWrapperEntity;
import org.valkyrienskies.mod.common.math.Quaternion;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.multithreaded.PhysicsShipTransform;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import valkyrienwarfare.api.TransformType;

public class WrapperPositionMessage
implements IMessage {
    private int relativeTick;
    private int entityID;
    private double posX;
    private double posY;
    private double posZ;
    private double pitch;
    private double yaw;
    private double roll;
    private Vector centerOfMass;
    private AxisAlignedBB shipBB;

    public WrapperPositionMessage() {
    }

    public WrapperPositionMessage(PhysicsShipTransform transformData, int entityID, int relativeTick) {
        this.setEntityID(entityID);
        this.setRelativeTick(relativeTick);
        this.setShipBB(transformData.getShipBoundingBox());
        this.setPosX(transformData.getPosX());
        this.setPosY(transformData.getPosY());
        this.setPosZ(transformData.getPosZ());
        this.setPitch(transformData.getPitch());
        this.setYaw(transformData.getYaw());
        this.setRoll(transformData.getRoll());
        this.setCenterOfMass(transformData.getCenterOfMass());
    }

    public WrapperPositionMessage(PhysicsWrapperEntity toSend, int relativeTick) {
        this.setEntityID(toSend.func_145782_y());
        this.setRelativeTick(relativeTick);
        this.setShipBB(toSend.getPhysicsObject().getShipBoundingBox());
        this.setPosX(toSend.field_70165_t);
        this.setPosY(toSend.field_70163_u);
        this.setPosZ(toSend.field_70161_v);
        this.setPitch(toSend.getPitch());
        this.setYaw(toSend.getYaw());
        this.setRoll(toSend.getRoll());
        this.setCenterOfMass(toSend.getPhysicsObject().getCenterCoord());
    }

    public WrapperPositionMessage(PhysicsObject toRunLocally) {
        this.setPosX(toRunLocally.getWrapperEntity().field_70165_t);
        this.setPosY(toRunLocally.getWrapperEntity().field_70163_u);
        this.setPosZ(toRunLocally.getWrapperEntity().field_70161_v);
        this.setPitch(toRunLocally.getWrapperEntity().getPitch());
        this.setYaw(toRunLocally.getWrapperEntity().getYaw());
        this.setRoll(toRunLocally.getWrapperEntity().getRoll());
        this.setCenterOfMass(toRunLocally.getCenterCoord());
        this.setShipBB(toRunLocally.getShipBoundingBox());
    }

    public WrapperPositionMessage(WrapperPositionMessage wrapperMessage) {
        this.posX = wrapperMessage.getPosX();
        this.posY = wrapperMessage.getPosY();
        this.posZ = wrapperMessage.getPosZ();
        this.pitch = wrapperMessage.getPitch();
        this.yaw = wrapperMessage.getYaw();
        this.roll = wrapperMessage.getRoll();
        this.centerOfMass = wrapperMessage.getCenterOfMass();
        this.relativeTick = wrapperMessage.getRelativeTick();
        this.shipBB = wrapperMessage.getShipBB();
        this.entityID = wrapperMessage.getEntityID();
    }

    public WrapperPositionMessage(WrapperPositionMessage[] transformations, double[] weights) {
        int i;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (i = 0; i < transformations.length; ++i) {
            x += weights[i] * transformations[i].posX;
            y += weights[i] * transformations[i].posY;
            z += weights[i] * transformations[i].posZ;
        }
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        for (i = 0; i < transformations.length; ++i) {
        }
        this.pitch = transformations[0].pitch;
        this.yaw = transformations[0].yaw;
        this.roll = transformations[0].roll;
        this.centerOfMass = transformations[0].centerOfMass;
        this.relativeTick = -1;
        this.shipBB = transformations[0].shipBB;
    }

    public void fromBytes(ByteBuf buf) {
        this.setEntityID(buf.readInt());
        this.setRelativeTick(buf.readInt());
        this.setPosX(buf.readDouble());
        this.setPosY(buf.readDouble());
        this.setPosZ(buf.readDouble());
        this.setPitch(buf.readDouble());
        this.setYaw(buf.readDouble());
        this.setRoll(buf.readDouble());
        this.setCenterOfMass(new Vector(buf.readDouble(), buf.readDouble(), buf.readDouble()));
        this.setShipBB(new AxisAlignedBB(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble()));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.getEntityID());
        buf.writeInt(this.getRelativeTick());
        buf.writeDouble(this.getPosX());
        buf.writeDouble(this.getPosY());
        buf.writeDouble(this.getPosZ());
        buf.writeDouble(this.getPitch());
        buf.writeDouble(this.getYaw());
        buf.writeDouble(this.getRoll());
        buf.writeDouble(this.getCenterOfMass().X);
        buf.writeDouble(this.getCenterOfMass().Y);
        buf.writeDouble(this.getCenterOfMass().Z);
        buf.writeDouble(this.getShipBB().field_72340_a);
        buf.writeDouble(this.getShipBB().field_72338_b);
        buf.writeDouble(this.getShipBB().field_72339_c);
        buf.writeDouble(this.getShipBB().field_72336_d);
        buf.writeDouble(this.getShipBB().field_72337_e);
        buf.writeDouble(this.getShipBB().field_72334_f);
    }

    public void applySmoothLerp(PhysicsObject physObj, double lerpFactor) {
        Vector CMDif = this.centerOfMass.getSubtraction(physObj.getCenterCoord());
        physObj.getShipTransformationManager().getCurrentTickTransform().rotate(CMDif, TransformType.SUBSPACE_TO_GLOBAL);
        physObj.getWrapperEntity().field_70165_t -= CMDif.X;
        physObj.getWrapperEntity().field_70163_u -= CMDif.Y;
        physObj.getWrapperEntity().field_70161_v -= CMDif.Z;
        physObj.getWrapperEntity().field_70142_S = physObj.getWrapperEntity().field_70165_t;
        physObj.getWrapperEntity().field_70137_T = physObj.getWrapperEntity().field_70163_u;
        physObj.getWrapperEntity().field_70136_U = physObj.getWrapperEntity().field_70161_v;
        physObj.getWrapperEntity().field_70165_t += (this.posX - physObj.getWrapperEntity().field_70165_t) * lerpFactor;
        physObj.getWrapperEntity().field_70163_u += (this.posY - physObj.getWrapperEntity().field_70163_u) * lerpFactor;
        physObj.getWrapperEntity().field_70161_v += (this.posZ - physObj.getWrapperEntity().field_70161_v) * lerpFactor;
        Quaternion prevRotation = physObj.getShipTransformationManager().getCurrentTickTransform().createRotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
        ShipTransform newRotationTransform = ShipTransform.createRotationTransform(this.pitch, this.yaw, this.roll);
        Quaternion newRotation = newRotationTransform.createRotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
        Quaternion slerpedRotation = Quaternion.slerpInterpolate(prevRotation, newRotation, lerpFactor);
        double[] slerpedRotationAngles = slerpedRotation.toRadians();
        physObj.getWrapperEntity().setPhysicsEntityRotation(Math.toDegrees(slerpedRotationAngles[0]), Math.toDegrees(slerpedRotationAngles[1]), Math.toDegrees(slerpedRotationAngles[2]));
        physObj.setCenterCoord(this.centerOfMass);
        physObj.setShipBoundingBox(this.shipBB);
    }

    public int getRelativeTick() {
        return this.relativeTick;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public double getPosX() {
        return this.posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public double getPosZ() {
        return this.posZ;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getRoll() {
        return this.roll;
    }

    public Vector getCenterOfMass() {
        return this.centerOfMass;
    }

    public AxisAlignedBB getShipBB() {
        return this.shipBB;
    }

    public void setRelativeTick(int relativeTick) {
        this.relativeTick = relativeTick;
    }

    public void setEntityID(int entityID) {
        this.entityID = entityID;
    }

    public void setPosX(double posX) {
        this.posX = posX;
    }

    public void setPosY(double posY) {
        this.posY = posY;
    }

    public void setPosZ(double posZ) {
        this.posZ = posZ;
    }

    public void setPitch(double pitch) {
        this.pitch = pitch;
    }

    public void setYaw(double yaw) {
        this.yaw = yaw;
    }

    public void setRoll(double roll) {
        this.roll = roll;
    }

    public void setCenterOfMass(Vector centerOfMass) {
        this.centerOfMass = centerOfMass;
    }

    public void setShipBB(AxisAlignedBB shipBB) {
        this.shipBB = shipBB;
    }
}

