/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.valkyrienskies.mod.common.block.IBlockForceProvider;
import org.valkyrienskies.mod.common.block.IBlockMassProvider;
import org.valkyrienskies.mod.common.block.IBlockTorqueProvider;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;

public class BlockPhysicsDetails {
    static final String BLOCK_MASS_VERSION = "v0.1";
    private static final double DEFAULT_MASS = 500.0;
    private static final HashMap<Block, Double> blockToMass = new HashMap();
    private static final HashMap<Material, Double> materialMass = new HashMap();
    public static final ArrayList<Block> blocksToNotPhysicsInfuse = new ArrayList();

    private static void onSync() {
        Arrays.stream(VSConfig.blockMass).map(str -> str.split("=")).filter(arr -> ((String[])arr).length == 2).map(arr -> Pair.of((Object)Block.func_149684_b((String)arr[0]), (Object)Double.parseDouble(arr[1]))).forEach(pair -> blockToMass.put((Block)pair.getLeft(), (Double)pair.getRight()));
    }

    private static void generateMaterialMasses() {
        materialMass.put(Material.field_151579_a, 0.0);
        materialMass.put(Material.field_151574_g, 8000.0);
        materialMass.put(Material.field_175972_I, 0.0);
        materialMass.put(Material.field_151570_A, 400.0);
        materialMass.put(Material.field_151568_F, 100.0);
        materialMass.put(Material.field_151593_r, 100.0);
        materialMass.put(Material.field_151594_q, 200.0);
        materialMass.put(Material.field_151571_B, 2000.0);
        materialMass.put(Material.field_151580_n, 300.0);
        materialMass.put(Material.field_151589_v, 2000.0);
        materialMass.put(Material.field_151596_z, 500.0);
        materialMass.put(Material.field_151566_D, 500.0);
        materialMass.put(Material.field_151581_o, 0.0);
        materialMass.put(Material.field_151592_s, 2000.0);
        materialMass.put(Material.field_151572_C, 1500.0);
        materialMass.put(Material.field_151577_b, 1500.0);
        materialMass.put(Material.field_151578_c, 1500.0);
        materialMass.put(Material.field_151588_w, 500.0);
        materialMass.put(Material.field_151573_f, 8000.0);
        materialMass.put(Material.field_151587_i, 2500.0);
        materialMass.put(Material.field_151584_j, 100.0);
        materialMass.put(Material.field_151598_x, 500.0);
        materialMass.put(Material.field_76233_E, 3000.0);
        materialMass.put(Material.field_151585_k, 300.0);
        materialMass.put(Material.field_151567_E, 0.0);
        materialMass.put(Material.field_151591_t, 100.0);
        materialMass.put(Material.field_151576_e, 3000.0);
        materialMass.put(Material.field_151595_p, 2000.0);
        materialMass.put(Material.field_151597_y, 500.0);
        materialMass.put(Material.field_151583_m, 100.0);
        materialMass.put(Material.field_189963_J, 0.0);
        materialMass.put(Material.field_151590_u, 2000.0);
        materialMass.put(Material.field_151582_l, 300.0);
        materialMass.put(Material.field_151586_h, 1000.0);
        materialMass.put(Material.field_151569_G, 100.0);
        materialMass.put(Material.field_151575_d, 500.0);
    }

    private static void generateBlockMasses() {
        blockToMass.put(Blocks.field_150350_a, 0.0);
        blockToMass.put((Block)Blocks.field_150480_ab, 0.0);
        blockToMass.put((Block)Blocks.field_150358_i, 0.0);
        blockToMass.put((Block)Blocks.field_150356_k, 0.0);
        blockToMass.put((Block)Blocks.field_150355_j, 0.0);
        blockToMass.put((Block)Blocks.field_150353_l, 0.0);
        blockToMass.put(Blocks.field_150357_h, 50000.0);
    }

    private static void generateBlocksToNotPhysicsInfuse() {
        blocksToNotPhysicsInfuse.add(Blocks.field_150350_a);
        blocksToNotPhysicsInfuse.add((Block)Blocks.field_150355_j);
        blocksToNotPhysicsInfuse.add((Block)Blocks.field_150358_i);
        blocksToNotPhysicsInfuse.add((Block)Blocks.field_150353_l);
        blocksToNotPhysicsInfuse.add((Block)Blocks.field_150356_k);
    }

    static double getMassFromState(IBlockState state, BlockPos pos, World world) {
        Block block = state.func_177230_c();
        if (block instanceof IBlockMassProvider) {
            return ((IBlockMassProvider)block).getBlockMass(world, pos, state);
        }
        return BlockPhysicsDetails.getMassOfBlock(block);
    }

    private static double getMassOfMaterial(Material material) {
        return materialMass.getOrDefault(material, 500.0);
    }

    private static double getMassOfBlock(Block block) {
        if (block instanceof BlockLiquid) {
            return 0.0;
        }
        if (blockToMass.get(block) != null) {
            return blockToMass.get(block);
        }
        return BlockPhysicsDetails.getMassOfMaterial(block.field_149764_J);
    }

    static void getForceFromState(IBlockState state, BlockPos pos, World world, double secondsToApply, PhysicsObject obj, Vector toSet) {
        Block block = state.func_177230_c();
        if (block instanceof IBlockForceProvider) {
            Vector forceVector = ((IBlockForceProvider)block).getBlockForceInWorldSpace(world, pos, state, obj, secondsToApply);
            if (forceVector == null) {
                toSet.zero();
            } else {
                toSet.X = forceVector.X;
                toSet.Y = forceVector.Y;
                toSet.Z = forceVector.Z;
            }
        }
    }

    public static boolean isBlockProvidingForce(IBlockState state, BlockPos pos, World world) {
        Block block = state.func_177230_c();
        return block instanceof IBlockForceProvider || block instanceof IBlockTorqueProvider;
    }

    static {
        BlockPhysicsDetails.generateBlockMasses();
        BlockPhysicsDetails.generateMaterialMasses();
        BlockPhysicsDetails.generateBlocksToNotPhysicsInfuse();
        VSConfig.registerSyncEvent(BlockPhysicsDetails::onSync);
        BlockPhysicsDetails.onSync();
    }
}

