/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics;

import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.vecmath.Matrix3d;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeWorld;
import org.valkyrienskies.addon.control.block.torque.IRotationNodeWorldProvider;
import org.valkyrienskies.addon.control.block.torque.ImplRotationNodeWorld;
import org.valkyrienskies.addon.control.nodenetwork.INodeController;
import org.valkyrienskies.mod.common.block.IBlockForceProvider;
import org.valkyrienskies.mod.common.block.IBlockTorqueProvider;
import org.valkyrienskies.mod.common.config.VSConfig;
import org.valkyrienskies.mod.common.math.Quaternion;
import org.valkyrienskies.mod.common.math.RotationMatrices;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.multithreaded.PhysicsShipTransform;
import org.valkyrienskies.mod.common.physics.BlockPhysicsDetails;
import org.valkyrienskies.mod.common.physics.PhysicsParticleManager;
import org.valkyrienskies.mod.common.physics.collision.WorldPhysicsCollider;
import org.valkyrienskies.mod.common.physics.management.PhysicsObject;
import org.valkyrienskies.mod.common.physics.management.ShipTransformationManager;
import org.valkyrienskies.mod.common.util.ValkyrienNBTUtils;
import valkyrienwarfare.api.TransformType;

public class PhysicsCalculations
implements IRotationNodeWorldProvider {
    public static final double DRAG_CONSTANT = 0.99;
    public static final double INERTIA_OFFSET = 0.4;
    public static final double EPSILON = 1.0E-8;
    private final PhysicsObject parent;
    private final WorldPhysicsCollider worldCollision;
    private final PhysicsParticleManager particleManager;
    private final Set<BlockPos> activeForcePositions;
    private final IRotationNodeWorld physicsRotationNodeWorld;
    public Vector gameTickCenterOfMass;
    public Vector linearMomentum;
    public Vector angularVelocity;
    public boolean actAsArchimedes;
    private Vector physCenterOfMass;
    private Vector torque;
    private double gameTickMass;
    private double physTickTimeDelta;
    private double[] gameMoITensor;
    private double[] physMOITensor;
    private double[] physInvMOITensor;
    private double physRoll;
    private double physPitch;
    private double physYaw;
    private double physX;
    private double physY;
    private double physZ;

    public PhysicsCalculations(PhysicsObject toProcess) {
        this.parent = toProcess;
        this.worldCollision = new WorldPhysicsCollider(this);
        this.particleManager = new PhysicsParticleManager(this);
        this.gameMoITensor = RotationMatrices.getZeroMatrix(3);
        this.physMOITensor = RotationMatrices.getZeroMatrix(3);
        this.setPhysInvMOITensor(RotationMatrices.getZeroMatrix(3));
        this.gameTickCenterOfMass = new Vector(toProcess.getCenterCoord());
        this.linearMomentum = new Vector();
        this.physCenterOfMass = new Vector();
        this.angularVelocity = new Vector();
        this.torque = new Vector();
        this.actAsArchimedes = false;
        this.activeForcePositions = ConcurrentHashMap.newKeySet();
        this.physicsRotationNodeWorld = new ImplRotationNodeWorld(this.parent);
    }

    public void onSetBlockState(IBlockState oldState, IBlockState newState, BlockPos pos) {
        World worldObj = this.getParent().world();
        if (!newState.equals(oldState)) {
            if (BlockPhysicsDetails.isBlockProvidingForce(newState, pos, worldObj)) {
                this.activeForcePositions.add(pos);
            } else {
                this.activeForcePositions.remove(pos);
            }
            double oldMass = BlockPhysicsDetails.getMassFromState(oldState, pos, worldObj);
            double newMass = BlockPhysicsDetails.getMassFromState(newState, pos, worldObj);
            double deltaMass = newMass - oldMass;
            if (Math.abs(deltaMass) > 1.0E-8) {
                double x = (double)pos.func_177958_n() + 0.5;
                double y = (double)pos.func_177956_o() + 0.5;
                double z = (double)pos.func_177952_p() + 0.5;
                this.addMassAt(x, y, z, deltaMass /= 9.0);
                this.addMassAt(x + 0.4, y + 0.4, z + 0.4, deltaMass);
                this.addMassAt(x + 0.4, y + 0.4, z - 0.4, deltaMass);
                this.addMassAt(x + 0.4, y - 0.4, z + 0.4, deltaMass);
                this.addMassAt(x + 0.4, y - 0.4, z - 0.4, deltaMass);
                this.addMassAt(x - 0.4, y + 0.4, z + 0.4, deltaMass);
                this.addMassAt(x - 0.4, y + 0.4, z - 0.4, deltaMass);
                this.addMassAt(x - 0.4, y - 0.4, z + 0.4, deltaMass);
                this.addMassAt(x - 0.4, y - 0.4, z - 0.4, deltaMass);
            }
        }
    }

    private void addMassAt(double x, double y, double z, double addedMass) {
        Vector prevCenterOfMass = new Vector(this.gameTickCenterOfMass);
        if (this.gameTickMass > 1.0E-4) {
            this.gameTickCenterOfMass.multiply(this.gameTickMass);
            this.gameTickCenterOfMass.add(new Vector(x, y, z).getProduct(addedMass));
            this.gameTickCenterOfMass.multiply(1.0 / (this.gameTickMass + addedMass));
        } else {
            this.gameTickCenterOfMass = new Vector(x, y, z);
            this.gameMoITensor = RotationMatrices.getZeroMatrix(3);
        }
        double cmShiftX = prevCenterOfMass.X - this.gameTickCenterOfMass.X;
        double cmShiftY = prevCenterOfMass.Y - this.gameTickCenterOfMass.Y;
        double cmShiftZ = prevCenterOfMass.Z - this.gameTickCenterOfMass.Z;
        double rx = x - this.gameTickCenterOfMass.X;
        double ry = y - this.gameTickCenterOfMass.Y;
        double rz = z - this.gameTickCenterOfMass.Z;
        this.gameMoITensor[0] = this.gameMoITensor[0] + (cmShiftY * cmShiftY + cmShiftZ * cmShiftZ) * this.gameTickMass + (ry * ry + rz * rz) * addedMass;
        this.gameMoITensor[1] = this.gameMoITensor[1] - cmShiftX * cmShiftY * this.gameTickMass - rx * ry * addedMass;
        this.gameMoITensor[2] = this.gameMoITensor[2] - cmShiftX * cmShiftZ * this.gameTickMass - rx * rz * addedMass;
        this.gameMoITensor[3] = this.gameMoITensor[1];
        this.gameMoITensor[4] = this.gameMoITensor[4] + (cmShiftX * cmShiftX + cmShiftZ * cmShiftZ) * this.gameTickMass + (rx * rx + rz * rz) * addedMass;
        this.gameMoITensor[5] = this.gameMoITensor[5] - cmShiftY * cmShiftZ * this.gameTickMass - ry * rz * addedMass;
        this.gameMoITensor[6] = this.gameMoITensor[2];
        this.gameMoITensor[7] = this.gameMoITensor[5];
        this.gameMoITensor[8] = this.gameMoITensor[8] + (cmShiftX * cmShiftX + cmShiftY * cmShiftY) * this.gameTickMass + (rx * rx + ry * ry) * addedMass;
        if (this.gameTickMass + addedMass < 1.0E-4) {
            this.gameTickMass = 1.0E-4;
            this.getParent().setPhysicsEnabled(false);
        } else {
            this.gameTickMass += addedMass;
        }
    }

    public void generatePhysicsTransform() {
        this.physRoll = this.getParent().getWrapperEntity().getRoll();
        this.physPitch = this.getParent().getWrapperEntity().getPitch();
        this.physYaw = this.getParent().getWrapperEntity().getYaw();
        this.physX = this.getParent().getWrapperEntity().field_70165_t;
        this.physY = this.getParent().getWrapperEntity().field_70163_u;
        this.physZ = this.getParent().getWrapperEntity().field_70161_v;
        this.physCenterOfMass.setValue(this.gameTickCenterOfMass);
        PhysicsShipTransform physicsTransform = new PhysicsShipTransform(this.physX, this.physY, this.physZ, this.physPitch, this.physYaw, this.physRoll, this.physCenterOfMass, this.getParent().getShipBoundingBox(), this.getParent().getShipTransformationManager().getCurrentTickTransform());
        this.getParent().getShipTransformationManager().setCurrentPhysicsTransform(physicsTransform);
        this.getParent().getShipTransformationManager().updatePreviousPhysicsTransform();
    }

    public void rawPhysTickPreCol(double newPhysSpeed) {
        if (this.getParent().isPhysicsEnabled()) {
            this.updatePhysSpeedAndIters(newPhysSpeed);
            this.updateParentCenterOfMass();
            this.calculateFramedMOITensor();
            if (!this.parent.getShipAligningToGrid()) {
                if (!this.actAsArchimedes) {
                    this.calculateForces();
                } else {
                    this.calculateForcesArchimedes();
                }
            } else {
                this.calculateForcesDeconstruction();
            }
        }
    }

    public void rawPhysTickPostCol() {
        if (!this.isPhysicsBroken()) {
            if (this.getParent().isPhysicsEnabled()) {
                if (VSConfig.doAirshipRotation) {
                    this.integrateAngularVelocity();
                }
                if (VSConfig.doAirshipMovement) {
                    this.integrateLinearVelocity();
                }
            }
        } else {
            this.getParent().setPhysicsEnabled(false);
            this.linearMomentum.zero();
            this.angularVelocity.zero();
        }
        PhysicsShipTransform finalPhysTransform = new PhysicsShipTransform(this.physX, this.physY, this.physZ, this.physPitch, this.physYaw, this.physRoll, this.physCenterOfMass, this.getParent().getShipBoundingBox(), this.getParent().getShipTransformationManager().getCurrentTickTransform());
        this.getParent().getShipTransformationManager().updatePreviousPhysicsTransform();
        this.getParent().getShipTransformationManager().setCurrentPhysicsTransform(finalPhysTransform);
        this.updatePhysCenterOfMass();
    }

    private boolean isPhysicsBroken() {
        if (this.angularVelocity.lengthSq() > 50000.0 || this.linearMomentum.lengthSq() * this.getInvMass() * this.getInvMass() > 50000.0 || this.angularVelocity.isNaN() || this.linearMomentum.isNaN()) {
            System.out.println("Ship tried moving too fast; freezing it and reseting velocities");
            return true;
        }
        return false;
    }

    public void updateParentCenterOfMass() {
        Vector parentCM = this.getParent().getCenterCoord();
        if (!this.getParent().getCenterCoord().equals(this.gameTickCenterOfMass)) {
            Vector CMDif = this.gameTickCenterOfMass.getSubtraction(parentCM);
            if (this.getParent().getShipTransformationManager().getCurrentPhysicsTransform() != null) {
                this.getParent().getShipTransformationManager().getCurrentPhysicsTransform().rotate(CMDif, TransformType.SUBSPACE_TO_GLOBAL);
            }
            this.getParent().getWrapperEntity().field_70165_t -= CMDif.X;
            this.getParent().getWrapperEntity().field_70163_u -= CMDif.Y;
            this.getParent().getWrapperEntity().field_70161_v -= CMDif.Z;
            this.getParent().getCenterCoord().setValue(this.gameTickCenterOfMass);
        }
    }

    private void updatePhysCenterOfMass() {
        if (!this.physCenterOfMass.equals(this.gameTickCenterOfMass)) {
            Vector CMDif = this.physCenterOfMass.getSubtraction(this.gameTickCenterOfMass);
            this.getParent().getShipTransformationManager().getCurrentPhysicsTransform().rotate(CMDif, TransformType.SUBSPACE_TO_GLOBAL);
            this.physX += CMDif.X;
            this.physY += CMDif.Y;
            this.physZ += CMDif.Z;
            this.physCenterOfMass.setValue(this.gameTickCenterOfMass);
        }
    }

    private void calculateFramedMOITensor() {
        double[] framedMOI = RotationMatrices.getZeroMatrix(3);
        Matrix3d rotationMatrix = this.getParent().getShipTransformationManager().getCurrentPhysicsTransform().createRotationMatrix(TransformType.SUBSPACE_TO_GLOBAL);
        Matrix3d inertiaBodyFrame = new Matrix3d(this.gameMoITensor);
        inertiaBodyFrame.mul(rotationMatrix);
        rotationMatrix.transpose();
        inertiaBodyFrame.mul(rotationMatrix);
        framedMOI[0] = inertiaBodyFrame.m00;
        framedMOI[1] = inertiaBodyFrame.m01;
        framedMOI[2] = inertiaBodyFrame.m02;
        framedMOI[3] = inertiaBodyFrame.m10;
        framedMOI[4] = inertiaBodyFrame.m11;
        framedMOI[5] = inertiaBodyFrame.m12;
        framedMOI[6] = inertiaBodyFrame.m20;
        framedMOI[7] = inertiaBodyFrame.m21;
        framedMOI[8] = inertiaBodyFrame.m22;
        this.physMOITensor = framedMOI;
        this.setPhysInvMOITensor(RotationMatrices.inverse3by3(framedMOI));
    }

    protected void calculateForces() {
        this.applyAirDrag();
        this.applyGravity();
        Vector blockForce = new Vector();
        Vector inBodyWO = new Vector();
        Vector crossVector = new Vector();
        World worldObj = this.getParent().world();
        if (VSConfig.doPhysicsBlocks) {
            PriorityQueue<INodeController> nodesPriorityQueue = new PriorityQueue<INodeController>(this.parent.getPhysicsControllersInShip());
            while (nodesPriorityQueue.size() > 0) {
                INodeController controller = (INodeController)nodesPriorityQueue.poll();
                controller.onPhysicsTick(this.parent, this, this.getPhysicsTimeDeltaPerPhysTick());
            }
            this.physicsRotationNodeWorld.processTorquePhysics(this.getPhysicsTimeDeltaPerPhysTick());
            TreeMap torqueProviders = new TreeMap();
            for (BlockPos pos : this.activeForcePositions) {
                IBlockState state = this.getParent().getChunkAt(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4).func_177435_g(pos);
                Block blockAt = state.func_177230_c();
                if (blockAt instanceof IBlockForceProvider) {
                    try {
                        BlockPhysicsDetails.getForceFromState(state, pos, worldObj, this.getPhysicsTimeDeltaPerPhysTick(), this.getParent(), blockForce);
                        Vector otherPosition = ((IBlockForceProvider)blockAt).getCustomBlockForcePosition(worldObj, pos, state, this.getParent(), this.getPhysicsTimeDeltaPerPhysTick());
                        if (otherPosition != null) {
                            inBodyWO.setValue(otherPosition);
                            inBodyWO.subtract(this.physCenterOfMass);
                            this.getParent().getShipTransformationManager().getCurrentPhysicsTransform().rotate(inBodyWO, TransformType.SUBSPACE_TO_GLOBAL);
                        } else {
                            inBodyWO.setValue((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                            inBodyWO.subtract(this.physCenterOfMass);
                            this.getParent().getShipTransformationManager().getCurrentPhysicsTransform().rotate(inBodyWO, TransformType.SUBSPACE_TO_GLOBAL);
                        }
                        this.addForceAtPoint(inBodyWO, blockForce, crossVector);
                        if (!((IBlockForceProvider)blockAt).doesForceSpawnParticles()) continue;
                        Vector particlePos = otherPosition != null ? new Vector(otherPosition) : new Vector((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                        this.parent.getShipTransformationManager().getCurrentPhysicsTransform().transform(particlePos, TransformType.SUBSPACE_TO_GLOBAL);
                        float posX = (float)particlePos.X;
                        float posY = (float)particlePos.Y;
                        float posZ = (float)particlePos.Z;
                        float particleMass = 5.0f;
                        float velX = (float)(-(blockForce.X / (double)particleMass));
                        float velY = (float)(-(blockForce.Y / (double)particleMass));
                        float velZ = (float)(-(blockForce.Z / (double)particleMass));
                        float particleLife = 0.5f;
                        this.particleManager.spawnPhysicsParticle(posX, posY, posZ, velX, velY, velZ, particleMass, particleLife);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(blockAt instanceof IBlockTorqueProvider)) continue;
                IBlockTorqueProvider torqueProviderBlock = (IBlockTorqueProvider)blockAt;
                if (!torqueProviders.containsKey(torqueProviderBlock)) {
                    torqueProviders.put(torqueProviderBlock, new LinkedList());
                }
                ((List)torqueProviders.get(torqueProviderBlock)).add(pos);
            }
            for (IBlockTorqueProvider torqueProviderBlock : torqueProviders.keySet()) {
                List blockPositions = (List)torqueProviders.get(torqueProviderBlock);
                for (BlockPos pos : blockPositions) {
                    this.convertTorqueToVelocity();
                    Vector torqueVector = torqueProviderBlock.getTorqueInGlobal(this, pos);
                    if (torqueVector == null) continue;
                    this.torque.add(torqueVector);
                }
            }
        }
        this.particleManager.physicsTickAfterAllPreForces((float)this.getPhysicsTimeDeltaPerPhysTick());
        this.convertTorqueToVelocity();
    }

    private void applyGravity() {
        if (VSConfig.doGravity) {
            this.addForceAtPoint(new Vector(0.0, 0.0, 0.0), VSConfig.gravity().getProduct(this.gameTickMass * this.getPhysicsTimeDeltaPerPhysTick()));
        }
    }

    private void calculateForcesArchimedes() {
        this.applyAirDrag();
    }

    private void calculateForcesDeconstruction() {
        Vector idealAngularVelocity;
        this.applyAirDrag();
        Quaternion gridRotation = new Quaternion(0.0, 0.0, 0.0, 1.0);
        Quaternion inverseCurrentRotation = this.parent.getShipTransformationManager().getCurrentPhysicsTransform().createRotationQuaternion(TransformType.GLOBAL_TO_SUBSPACE);
        Quaternion r = gridRotation.crossProduct(inverseCurrentRotation);
        double theta = 2.0 * Math.acos(r.getW());
        if (theta > Math.PI) {
            theta -= Math.PI * 2;
        }
        if ((idealAngularVelocity = new Vector(r.getX(), r.getY(), r.getZ())).lengthSq() < 1.0E-8) {
            return;
        }
        double timeStep = 1.0;
        double idealAngularVelocityMultiple = -theta / (timeStep * idealAngularVelocity.length());
        idealAngularVelocity.multiply(idealAngularVelocityMultiple);
        Vector angularVelocityDif = idealAngularVelocity.getSubtraction(this.angularVelocity);
        angularVelocityDif.multiply(0.01);
        this.angularVelocity.subtract(angularVelocityDif);
    }

    protected void applyAirDrag() {
        double drag = this.getDragForPhysTick();
        this.linearMomentum.multiply(drag);
        this.angularVelocity.multiply(drag);
    }

    public void convertTorqueToVelocity() {
        if (!this.torque.isZero()) {
            this.angularVelocity.add(RotationMatrices.get3by3TransformedVec(this.getPhysInvMOITensor(), this.torque));
            this.torque.zero();
        }
    }

    public void addForceAtPoint(Vector inBodyWO, Vector forceToApply) {
        this.torque.add(inBodyWO.cross(forceToApply));
        this.linearMomentum.add(forceToApply);
    }

    public void addForceAtPoint(Vector inBodyWO, Vector forceToApply, Vector crossVector) {
        crossVector.setCross(inBodyWO, forceToApply);
        this.torque.add(crossVector);
        this.linearMomentum.add(forceToApply);
    }

    public void updatePhysSpeedAndIters(double newPhysSpeed) {
        this.physTickTimeDelta = newPhysSpeed;
    }

    private void integrateAngularVelocity() {
        ShipTransformationManager coordTrans = this.getParent().getShipTransformationManager();
        double[] rotationChange = RotationMatrices.getRotationMatrix(this.angularVelocity.X, this.angularVelocity.Y, this.angularVelocity.Z, this.angularVelocity.length() * this.getPhysicsTimeDeltaPerPhysTick());
        Quaternion rotationChangeQuat = Quaternion.QuaternionFromMatrix(rotationChange);
        Quaternion initialRotation = coordTrans.getCurrentPhysicsTransform().createRotationQuaternion(TransformType.SUBSPACE_TO_GLOBAL);
        Quaternion finalRotation = initialRotation.crossProduct(rotationChangeQuat);
        double[] radians = finalRotation.toRadians();
        this.physPitch = Double.isNaN(radians[0]) ? 0.0 : (double)((float)Math.toDegrees(radians[0]));
        this.physYaw = Double.isNaN(radians[1]) ? 0.0 : (double)((float)Math.toDegrees(radians[1]));
        this.physRoll = Double.isNaN(radians[2]) ? 0.0 : (double)((float)Math.toDegrees(radians[2]));
    }

    private void integrateLinearVelocity() {
        double momentMod = this.getPhysicsTimeDeltaPerPhysTick() * this.getInvMass();
        this.physX += this.linearMomentum.X * momentMod;
        this.physY += this.linearMomentum.Y * momentMod;
        this.physZ += this.linearMomentum.Z * momentMod;
        this.physY = Math.min(Math.max(this.physY, VSConfig.shipLowerLimit), VSConfig.shipUpperLimit);
    }

    public Vector getVelocityAtPoint(Vector inBodyWO) {
        Vector speed = this.angularVelocity.cross(inBodyWO);
        double invMass = this.getInvMass();
        speed.X += this.linearMomentum.X * invMass;
        speed.Y += this.linearMomentum.Y * invMass;
        speed.Z += this.linearMomentum.Z * invMass;
        return speed;
    }

    public void writeToNBTTag(NBTTagCompound compound) {
        compound.func_74780_a("mass", this.gameTickMass);
        ValkyrienNBTUtils.writeVectorToNBT("linear", this.linearMomentum, compound);
        ValkyrienNBTUtils.writeVectorToNBT("angularVelocity", this.angularVelocity, compound);
        ValkyrienNBTUtils.writeVectorToNBT("CM", this.gameTickCenterOfMass, compound);
        ValkyrienNBTUtils.write3x3MatrixToNBT("MOI", this.gameMoITensor, compound);
        this.physicsRotationNodeWorld.writeToNBTTag(compound);
        compound.func_74778_a("block_mass_ver", "v0.1");
    }

    public void readFromNBTTag(NBTTagCompound compound) {
        this.linearMomentum = ValkyrienNBTUtils.readVectorFromNBT("linear", compound);
        this.angularVelocity = ValkyrienNBTUtils.readVectorFromNBT("angularVelocity", compound);
        this.gameTickCenterOfMass = ValkyrienNBTUtils.readVectorFromNBT("CM", compound);
        this.gameTickMass = compound.func_74769_h("mass");
        this.gameMoITensor = ValkyrienNBTUtils.read3x3MatrixFromNBT("MOI", compound);
        this.physicsRotationNodeWorld.readFromNBTTag(compound);
        if (!"v0.1".equals(compound.func_74779_i("block_mass_ver"))) {
            this.recalculateShipInertia();
        }
    }

    public void recalculateShipInertia() {
        this.linearMomentum.zero();
        this.angularVelocity.zero();
        this.gameTickCenterOfMass.zero();
        this.gameTickMass = 0.0;
        this.gameMoITensor = RotationMatrices.getZeroMatrix(3);
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        for (BlockPos pos : this.getParent().getBlockPositions()) {
            this.onSetBlockState(air, this.getParent().getChunkAt(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4).func_177435_g(pos), pos);
        }
    }

    public double getMass() {
        return this.gameTickMass;
    }

    public double getInvMass() {
        return 1.0 / this.gameTickMass;
    }

    public double getPhysicsTimeDeltaPerPhysTick() {
        return this.physTickTimeDelta;
    }

    public double getDragForPhysTick() {
        return Math.pow(0.99, this.getPhysicsTimeDeltaPerPhysTick() * 20.0);
    }

    public void addPotentialActiveForcePos(BlockPos pos) {
        this.activeForcePositions.add(pos);
    }

    public double[] getPhysInvMOITensor() {
        return this.physInvMOITensor;
    }

    private void setPhysInvMOITensor(double[] physInvMOITensor) {
        this.physInvMOITensor = physInvMOITensor;
    }

    public double[] getPhysMOITensor() {
        return this.physMOITensor;
    }

    public PhysicsObject getParent() {
        return this.parent;
    }

    public WorldPhysicsCollider getWorldCollision() {
        return this.worldCollision;
    }

    public double getInertiaAlongRotationAxis() {
        Vector rotationAxis = new Vector(this.angularVelocity);
        rotationAxis.normalize();
        RotationMatrices.applyTransform3by3(this.getPhysMOITensor(), rotationAxis);
        return rotationAxis.length();
    }

    @Deprecated
    public Vector getCopyOfPhysCoordinates() {
        return new Vector(this.physX, this.physY, this.physZ);
    }

    @Override
    public IRotationNodeWorld getPhysicsRotationNodeWorld() {
        return this.physicsRotationNodeWorld;
    }
}

