/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.physics;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import org.valkyrienskies.mod.common.math.Vector;
import org.valkyrienskies.mod.common.physics.PhysicsCalculations;
import valkyrienwarfare.api.TransformType;

public class PhysicsParticleManager {
    private final PhysicsCalculations parent;
    private List<PhysicsParticle> physicsParticles;

    public PhysicsParticleManager(PhysicsCalculations parent) {
        this.parent = parent;
        this.physicsParticles = new ArrayList<PhysicsParticle>();
    }

    public void spawnPhysicsParticle(float posX, float posY, float posZ, float velX, float velY, float velZ, float mass, float timeToLive) {
        this.physicsParticles.add(new PhysicsParticle(posX, posY, posZ, velX, velY, velZ, mass, timeToLive));
    }

    public void physicsTickAfterAllPreForces(float timeStep) {
        ArrayList<PhysicsParticle> aliveParticles = new ArrayList<PhysicsParticle>(this.physicsParticles.size());
        BlockPos.MutableBlockPos bufferBlockPos = new BlockPos.MutableBlockPos();
        Vector bufferVector = new Vector();
        Vector bufferVectorForcePos = new Vector();
        Vector bufferVectorForce = new Vector();
        for (PhysicsParticle physicsParticle : this.physicsParticles) {
            physicsParticle.tickParticle(this.parent, bufferBlockPos, bufferVector, timeStep);
            if (!physicsParticle.isParticleDead()) {
                aliveParticles.add(physicsParticle);
                continue;
            }
            if (!physicsParticle.addMomentumToShip) continue;
            bufferVectorForcePos.setValue((double)physicsParticle.posX - this.parent.getParent().getWrapperEntity().field_70165_t, (double)physicsParticle.posY - this.parent.getParent().getWrapperEntity().field_70163_u, (double)physicsParticle.posZ - this.parent.getParent().getWrapperEntity().field_70161_v);
            bufferVectorForce.setValue(physicsParticle.velX * physicsParticle.mass, physicsParticle.velY * physicsParticle.mass, physicsParticle.velZ * physicsParticle.mass);
            this.parent.addForceAtPoint(bufferVectorForcePos, bufferVectorForce);
        }
        this.physicsParticles = aliveParticles;
    }

    private static class PhysicsParticle {
        private float posX;
        private float posY;
        private float posZ;
        private float velX;
        private float velY;
        private float velZ;
        private float mass;
        private float particleLife;
        private boolean isParticleDead;
        private boolean addMomentumToShip;

        PhysicsParticle(float posX, float posY, float posZ, float velX, float velY, float velZ, float mass, float particleLife) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.velX = velX;
            this.velY = velY;
            this.velZ = velZ;
            this.mass = mass;
            this.particleLife = particleLife;
            this.isParticleDead = false;
        }

        public Vector getParticleMomentum() {
            return new Vector(this.velX * this.mass, this.velY * this.mass, this.velZ * this.mass);
        }

        public void tickParticle(PhysicsCalculations physicsSource, BlockPos.MutableBlockPos bufferBlockPos, Vector bufferVector, float timeStep) {
            this.posX += this.velX * timeStep;
            this.posY += this.velY * timeStep;
            this.posZ += this.velZ * timeStep;
            this.particleLife -= timeStep;
            this.isParticleDead = this.particleLife < 0.0f;
            bufferBlockPos.func_189532_c((double)this.posX, (double)this.posY, (double)this.posZ);
            if (!this.canParticlePassThrough(physicsSource.getParent().world(), (BlockPos)bufferBlockPos)) {
                this.isParticleDead = true;
            }
            if (!this.isParticleDead) {
                bufferVector.setValue(this.posX, this.posY, this.posZ);
                physicsSource.getParent().getShipTransformationManager().getCurrentPhysicsTransform().transform(bufferVector, TransformType.GLOBAL_TO_SUBSPACE);
                bufferBlockPos.func_189532_c(bufferVector.X, bufferVector.Y, bufferVector.Z);
                if (!this.canParticlePassThrough(physicsSource.getParent().world(), (BlockPos)bufferBlockPos)) {
                    this.isParticleDead = true;
                    this.addMomentumToShip = true;
                }
            }
        }

        private boolean canParticlePassThrough(World world, BlockPos pos) {
            ChunkProviderServer serverProvider = (ChunkProviderServer)world.func_72863_F();
            long chunkKey = ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
            if (!serverProvider.field_73244_f.containsKey(chunkKey)) {
                this.isParticleDead = true;
                return true;
            }
            IBlockState collisionState = ((Chunk)serverProvider.field_73244_f.get(chunkKey)).func_177435_g(pos);
            return collisionState.func_177230_c().func_176205_b((IBlockAccess)world, pos);
        }

        public boolean isParticleDead() {
            return this.isParticleDead;
        }

        public boolean addMomentumToShip() {
            return this.addMomentumToShip;
        }
    }
}

